/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.storage.autocrafting;

import com.denfop.api.storage.StorageStack;
import com.denfop.api.storage.autocrafting.AutoCraftOutput;
import com.denfop.api.storage.autocrafting.AutoCraftStack;
import com.denfop.api.storage.autocrafting.AutoCraftVisualStep;
import com.denfop.api.storage.autocrafting.PatternStack;
import com.denfop.api.storage.autocrafting.SameStack;
import com.denfop.api.storage.cell.ICell;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class AutoCraftSystemVisual {
    private final SameStack output;
    Map<PatternStack, AutoCraftStack> patternStackList = new HashMap<PatternStack, AutoCraftStack>();
    boolean canAdd = true;
    AutoCraftOutput autoCraftOutput;
    List<AutoCraftVisualStep> visualSteps = new LinkedList<AutoCraftVisualStep>();
    private final Map<ResourceLocation, List<PatternStack>> patternCacheItem = new HashMap<ResourceLocation, List<PatternStack>>();
    private final Map<ResourceLocation, List<PatternStack>> patternCacheFluid = new HashMap<ResourceLocation, List<PatternStack>>();
    Map<PatternStack, List<PatternStack>> patternSource = new HashMap<PatternStack, List<PatternStack>>();
    Map<String, List<StorageStack>> storage;

    public AutoCraftSystemVisual(SameStack stack) {
        this.output = stack;
    }

    private void buildPatternCache(List<PatternStack> patterns) {
        this.patternCacheItem.clear();
        this.patternCacheFluid.clear();
        for (PatternStack ps : patterns) {
            ResourceLocation rl;
            if (ps.output().isItem()) {
                rl = BuiltInRegistries.f_257033_.m_7981_((Object)ps.output().getStack().m_41720_());
                this.patternCacheItem.computeIfAbsent(rl, k -> new ArrayList()).add(ps);
                continue;
            }
            if (!ps.output().isFluid()) continue;
            rl = BuiltInRegistries.f_257020_.m_7981_((Object)ps.output().getFluidStack().getFluid());
            this.patternCacheFluid.computeIfAbsent(rl, k -> new ArrayList()).add(ps);
        }
    }

    public void create(List<PatternStack> patterns, List<ICell> cellItemStack, List<ICell> cellFluidStack) {
        this.buildPatternCache(patterns);
        this.resolveCraft(this.output, this.output.getAmount(), patterns, cellItemStack, cellFluidStack);
    }

    public boolean canAddToProcessor() {
        return this.canAdd;
    }

    public SameStack getOutput() {
        return this.output;
    }

    public CompoundTag writeToNBT() {
        CompoundTag tag = new CompoundTag();
        CompoundTag outputTag = this.output.writeToNBT();
        tag.m_128365_("Output", (Tag)outputTag);
        ListTag patternList = new ListTag();
        for (AutoCraftStack stack : this.patternStackList.values()) {
            patternList.add((Object)stack.writeToNBT());
        }
        tag.m_128365_("PatternStacks", (Tag)patternList);
        tag.m_128379_("CanAdd", this.canAdd);
        if (this.autoCraftOutput != null) {
            tag.m_128365_("AutoCraftOutput", (Tag)this.autoCraftOutput.writeToNBT());
        }
        return tag;
    }

    public static AutoCraftSystemVisual readFromNBT(CompoundTag tag) {
        SameStack output = SameStack.readFromNBT(tag.m_128469_("Output"));
        AutoCraftSystemVisual system = new AutoCraftSystemVisual(output);
        ListTag list = tag.m_128437_("PatternStacks", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag stackTag = list.m_128728_(i);
            AutoCraftStack stack = AutoCraftStack.readFromNBT(stackTag);
            system.patternStackList.put(stack.getPatternStack(), stack);
        }
        if (tag.m_128441_("CanAdd")) {
            system.canAdd = tag.m_128471_("CanAdd");
        }
        if (tag.m_128441_("AutoCraftOutput")) {
            system.autoCraftOutput = AutoCraftOutput.readFromNBT(tag.m_128469_("AutoCraftOutput"));
        }
        return system;
    }

    public List<AutoCraftVisualStep> getVisualSteps() {
        return this.visualSteps;
    }

    public AutoCraftOutput getAutoCraftOutput() {
        return this.autoCraftOutput;
    }

    public List<AutoCraftStack> getPatternStackList() {
        return new ArrayList<AutoCraftStack>(this.patternStackList.values());
    }

    private boolean hasCycle(PatternStack start, PatternStack target, Set<PatternStack> visited) {
        if (start.equals(target)) {
            return true;
        }
        if (!this.patternSource.containsKey(start)) {
            return false;
        }
        visited.add(start);
        for (PatternStack next : this.patternSource.get(start)) {
            if (visited.contains(next) || !this.hasCycle(next, target, visited)) continue;
            return true;
        }
        visited.remove(start);
        return false;
    }

    private void resolveCraft(SameStack target, int countMultiplier, List<PatternStack> patterns, List<ICell> cellItemStacks, List<ICell> cellFluidStacks) {
        PatternStack pattern = this.findPatternFor(target);
        if (pattern == null) {
            this.canAdd = false;
            this.visualSteps.add(new AutoCraftVisualStep(target, 0, 0, target.getAmount() * countMultiplier));
            return;
        }
        HashSet<PatternStack> checkPattern = new HashSet<PatternStack>();
        countMultiplier = (int)Math.ceil((double)countMultiplier / (1.0 * (double)pattern.output().getAmount()));
        this.autoCraftOutput = new AutoCraftOutput(pattern, countMultiplier);
        this.visualSteps.add(new AutoCraftVisualStep(target, 0, countMultiplier * pattern.output().getAmount(), countMultiplier * pattern.output().getAmount()));
        checkPattern.add(pattern);
        this.storage = new HashMap<String, List<StorageStack>>();
        this.findAllStacks(cellItemStacks, cellFluidStacks);
        ArrayDeque<Pair> stack = new ArrayDeque<Pair>();
        for (SameStack sameStack : pattern.inputs()) {
            if (sameStack.isItem()) {
                stack.push(new Pair((Object)sameStack.getStack(), (Object)countMultiplier));
            } else {
                stack.push(new Pair((Object)sameStack.getFluidStack(), (Object)countMultiplier));
            }
            LinkedList<PatternStack> patternStacks = new LinkedList<PatternStack>();
            PatternStack patternInput = this.findPatternFor(sameStack);
            if (patternInput != null) {
                patternStacks.add(patternInput);
            }
            this.patternSource.put(pattern, new ArrayList(patternStacks));
        }
        block1: while (!stack.isEmpty()) {
            Object patternInput;
            int craftsNeeded;
            PatternStack ps;
            Pair pair = (Pair)stack.pop();
            Object current = pair.getFirst();
            int multiplier = (Integer)pair.getSecond();
            if (current instanceof ItemStack) {
                ItemStack currentItem = (ItemStack)current;
                ps = this.findPatternFor(currentItem);
                if (ps == null) {
                    int availableCount = 0;
                    int required = currentItem.m_41613_() * multiplier;
                    Tuple<Integer, Integer> tuple = this.getAvailableStacks(currentItem);
                    if (tuple != null) {
                        availableCount = (Integer)tuple.m_14418_();
                    }
                    if (availableCount > 0) {
                        if (availableCount < required) {
                            this.canAdd = false;
                        }
                        this.removeAvailableStacks(currentItem, (Tuple<Integer, Integer>)new Tuple((Object)availableCount, (Object)((Integer)tuple.m_14419_())));
                        this.visualSteps.add(new AutoCraftVisualStep(currentItem, Math.min(availableCount, required), 0, required - availableCount));
                        continue;
                    }
                    this.canAdd = false;
                    this.visualSteps.add(new AutoCraftVisualStep(currentItem, 0, 0, Math.max(0, required - availableCount)));
                    continue;
                }
                if (!checkPattern.add(ps)) {
                    List dependencies = this.patternSource.getOrDefault(ps, new ArrayList());
                    for (PatternStack dep : dependencies) {
                        if (!this.hasCycle(dep, ps, new HashSet<PatternStack>())) continue;
                        this.canAdd = false;
                        this.visualSteps.add(new AutoCraftVisualStep(currentItem, 0, 0, currentItem.m_41613_() * multiplier));
                        continue block1;
                    }
                }
                int availableCount = 0;
                Tuple<Integer, Integer> tuple = this.getAvailableStacks(currentItem);
                int required = currentItem.m_41613_() * multiplier;
                if (tuple != null) {
                    availableCount = (Integer)tuple.m_14418_();
                }
                if (required > availableCount) {
                    craftsNeeded = (int)Math.ceil((double)required / (double)ps.output().getAmount());
                    AutoCraftStack autoCraftStack = this.patternStackList.get(ps);
                    if (autoCraftStack == null) {
                        autoCraftStack = new AutoCraftStack(ps, craftsNeeded);
                        this.patternStackList.put(ps, autoCraftStack);
                    } else {
                        autoCraftStack.addAmountAll(craftsNeeded);
                    }
                    this.visualSteps.add(new AutoCraftVisualStep(currentItem, availableCount, required - availableCount, required));
                    if (tuple != null) {
                        this.removeAvailableStacks(currentItem, (Tuple<Integer, Integer>)new Tuple((Object)availableCount, (Object)((Integer)tuple.m_14419_())));
                    }
                } else {
                    if (tuple == null) continue;
                    this.removeAvailableStacks(currentItem, (Tuple<Integer, Integer>)new Tuple((Object)availableCount, (Object)((Integer)tuple.m_14419_())));
                    continue;
                }
                for (SameStack input : ps.inputs()) {
                    if (!input.getStack().m_41619_()) {
                        stack.push(new Pair((Object)input.getStack(), (Object)craftsNeeded));
                    }
                    if (!input.getFluidStack().isEmpty()) {
                        stack.push(new Pair((Object)input.getFluidStack(), (Object)craftsNeeded));
                    }
                    LinkedList<Object> patternStacks = new LinkedList<Object>();
                    patternInput = this.findPatternFor(input);
                    if (patternInput != null) {
                        patternStacks.add(patternInput);
                    }
                    this.patternSource.put(pattern, new ArrayList(patternStacks));
                }
                continue;
            }
            if (!(current instanceof FluidStack)) continue;
            FluidStack currentFluid = (FluidStack)current;
            ps = this.findPatternFor(currentFluid);
            if (ps == null) {
                int availableAmount = 0;
                Tuple<Integer, Integer> tuple = this.getAvailableStacks(currentFluid);
                if (tuple != null) {
                    availableAmount = (Integer)tuple.m_14418_();
                }
                int required = currentFluid.getAmount() * multiplier;
                if (availableAmount > 0) {
                    if (availableAmount < required) {
                        this.canAdd = false;
                    }
                    this.visualSteps.add(new AutoCraftVisualStep(currentFluid, Math.min(availableAmount, required), 0, required - availableAmount));
                    continue;
                }
                this.canAdd = false;
                this.visualSteps.add(new AutoCraftVisualStep(currentFluid, 0, 0, required - availableAmount));
                continue;
            }
            if (!checkPattern.add(ps)) continue;
            int availableCount = 0;
            for (ICell cell : cellItemStacks) {
                for (StorageStack s : cell.getStorageStackFromFluid(currentFluid)) {
                    availableCount += s.getCount();
                }
            }
            int required = currentFluid.getAmount() * multiplier;
            if ((required -= availableCount) <= 0) continue;
            craftsNeeded = (int)Math.ceil((double)required / (double)ps.output().getAmount());
            AutoCraftStack autoCraftStack = this.patternStackList.get(ps);
            if (autoCraftStack == null) {
                autoCraftStack = new AutoCraftStack(ps, craftsNeeded);
                this.patternStackList.put(ps, autoCraftStack);
            } else {
                autoCraftStack.addAmountAll(craftsNeeded);
            }
            this.visualSteps.add(new AutoCraftVisualStep(currentFluid, availableCount, required - availableCount, required));
            for (SameStack input : ps.inputs()) {
                if (!input.getStack().m_41619_()) {
                    stack.push(new Pair((Object)input.getStack(), (Object)craftsNeeded));
                }
                if (!input.getFluidStack().isEmpty()) {
                    stack.push(new Pair((Object)input.getFluidStack(), (Object)craftsNeeded));
                }
                LinkedList<Object> patternStacks = new LinkedList<Object>();
                patternInput = this.findPatternFor(input);
                if (patternInput != null) {
                    patternStacks.add(patternInput);
                }
                this.patternSource.put(pattern, new ArrayList(patternStacks));
            }
        }
        this.visualSteps = this.mergeDuplicateSteps(this.visualSteps);
    }

    private List<AutoCraftVisualStep> mergeDuplicateSteps(List<AutoCraftVisualStep> steps) {
        HashMap<Object, AutoCraftVisualStep> merged = new HashMap<Object, AutoCraftVisualStep>();
        for (AutoCraftVisualStep step : steps) {
            Object key = step.stack();
            merged.merge(key, step, (a, b) -> new AutoCraftVisualStep(a.stack(), a.have() + b.have(), a.create() + b.create(), a.need() + b.need()));
        }
        return new ArrayList<AutoCraftVisualStep>(merged.values());
    }

    private Tuple<Integer, Integer> getAvailableStacks(ItemStack stack) {
        ResourceLocation rl = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        List<StorageStack> storages = this.storage.get(rl);
        if (storages == null) {
            return null;
        }
        for (int i = 0; i < storages.size(); ++i) {
            StorageStack storageStack = storages.get(i);
            if (!storageStack.equals(stack.m_41783_())) continue;
            return new Tuple((Object)storageStack.getCount(), (Object)i);
        }
        return null;
    }

    private void removeAvailableStacks(ItemStack stack, Tuple<Integer, Integer> tuple) {
        if ((Integer)tuple.m_14418_() == 0) {
            return;
        }
        ResourceLocation rl = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        StorageStack storages = this.storage.get(rl).get((Integer)tuple.m_14419_());
        storages.removeCount((Integer)tuple.m_14418_());
        if (storages.getCount() <= 0) {
            this.storage.get(rl).remove((Integer)tuple.m_14419_());
        }
    }

    private Tuple<Integer, Integer> getAvailableStacks(FluidStack stack) {
        ResourceLocation rl = BuiltInRegistries.f_257020_.m_7981_((Object)stack.getFluid());
        List<StorageStack> storages = this.storage.get(rl);
        if (storages == null) {
            return null;
        }
        for (int i = 0; i < storages.size(); ++i) {
            StorageStack storageStack = storages.get(i);
            if (!storageStack.equals(stack.getTag())) continue;
            return new Tuple((Object)storageStack.getCount(), (Object)i);
        }
        return null;
    }

    private void removeAvailableStacks(FluidStack stack, Tuple<Integer, Integer> tuple) {
        if ((Integer)tuple.m_14418_() == 0) {
            return;
        }
        ResourceLocation rl = BuiltInRegistries.f_257020_.m_7981_((Object)stack.getFluid());
        StorageStack storages = this.storage.get(rl).get((Integer)tuple.m_14419_());
        storages.removeCount((Integer)tuple.m_14418_());
        if (storages.getCount() <= 0) {
            this.storage.get(rl).remove((Integer)tuple.m_14419_());
        }
    }

    private void findAllStacks(List<ICell> cellItemStacks, List<ICell> cellFluidStacks) {
        List<Object> storageStackList;
        Map<String, List<StorageStack>> cellStorage;
        for (ICell cell : cellItemStacks) {
            cellStorage = cell.getStorageStack();
            for (Map.Entry<String, List<StorageStack>> entry : cellStorage.entrySet()) {
                if (!this.storage.containsKey(entry.getKey())) {
                    storageStackList = new ArrayList();
                    entry.getValue().forEach(storageStack -> storageStackList.add(storageStack.copy()));
                    this.storage.put(entry.getKey(), storageStackList);
                    continue;
                }
                storageStackList = this.storage.get(entry.getKey());
                block2: for (StorageStack stack : entry.getValue()) {
                    for (StorageStack storageStack2 : storageStackList) {
                        if (!storageStack2.equals(stack)) continue;
                        storageStack2.addCount(stack.getCount());
                        continue block2;
                    }
                    storageStackList.add(stack.copy());
                }
            }
        }
        for (ICell cell : cellFluidStacks) {
            cellStorage = cell.getStorageStack();
            for (Map.Entry<String, List<StorageStack>> entry : cellStorage.entrySet()) {
                if (!this.storage.containsKey(entry.getKey())) {
                    storageStackList = new ArrayList();
                    entry.getValue().forEach(storageStack -> storageStackList.add(storageStack.copy()));
                    this.storage.put(entry.getKey(), storageStackList);
                    continue;
                }
                storageStackList = this.storage.get(entry.getKey());
                block6: for (StorageStack stack : entry.getValue()) {
                    for (StorageStack storageStack3 : storageStackList) {
                        if (!storageStack3.equals(stack)) continue;
                        storageStack3.addCount(stack.getCount());
                        continue block6;
                    }
                    storageStackList.add(stack.copy());
                }
            }
        }
    }

    private PatternStack findPatternFor(ItemStack stack) {
        List<PatternStack> list = this.patternCacheItem.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()));
        if (list == null) {
            return null;
        }
        for (PatternStack ps : list) {
            if (!NbtUtils.m_129235_((Tag)ps.output().getStack().m_41783_(), (Tag)stack.m_41783_(), (boolean)true)) continue;
            return ps;
        }
        return null;
    }

    private PatternStack findPatternFor(SameStack stack) {
        List<PatternStack> list;
        if (stack.isItem()) {
            list = this.patternCacheItem.get(BuiltInRegistries.f_257033_.m_7981_((Object)stack.getStack().m_41720_()));
            if (list == null) {
                return null;
            }
            for (PatternStack ps : list) {
                if (!ps.output().isItem() || !ps.output().getStack().m_150930_(stack.getStack().m_41720_()) || !NbtUtils.m_129235_((Tag)ps.output().getStack().m_41783_(), (Tag)stack.getStack().m_41783_(), (boolean)true)) continue;
                return ps;
            }
        }
        if (stack.isFluid()) {
            list = this.patternCacheItem.get(BuiltInRegistries.f_257020_.m_7981_((Object)stack.getFluidStack().getFluid()));
            if (list == null) {
                return null;
            }
            for (PatternStack ps : list) {
                if (!ps.output().isFluid() || !ps.output().getFluidStack().isFluidEqual(stack.getFluidStack())) continue;
                return ps;
            }
        }
        return null;
    }

    private PatternStack findPatternFor(FluidStack stack) {
        List<PatternStack> list = this.patternCacheItem.get(BuiltInRegistries.f_257020_.m_7981_((Object)stack.getFluid()));
        if (list == null) {
            return null;
        }
        for (PatternStack ps : list) {
            if (!ps.output().getFluidStack().isFluidEqual(stack)) continue;
            return ps;
        }
        return null;
    }
}

