/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.storage.autocrafting;

import com.denfop.api.storage.autocrafting.AutoCraftOutput;
import com.denfop.api.storage.autocrafting.AutoCraftStack;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class AutoCraftSystem {
    private final AutoCraftOutput autoCraftOutput;
    List<AutoCraftStack> patternStacks = new LinkedList<AutoCraftStack>();
    boolean isEnd = false;
    int count;

    public AutoCraftSystem(AutoCraftOutput autoCraftOutput, List<AutoCraftStack> patternStacks) {
        this.autoCraftOutput = autoCraftOutput;
        this.count = autoCraftOutput.count();
        this.patternStacks = patternStacks;
    }

    public CompoundTag writeToTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("AutoCraftOutput", (Tag)this.autoCraftOutput.writeToNBT());
        ListTag listTag = new ListTag();
        for (AutoCraftStack stack : this.patternStacks) {
            listTag.add((Object)stack.writeToNBT());
        }
        tag.m_128365_("PatternStacks", (Tag)listTag);
        tag.m_128379_("IsEnd", this.isEnd);
        tag.m_128405_("Count", this.count);
        return tag;
    }

    public static AutoCraftSystem readFromTag(CompoundTag tag) {
        AutoCraftOutput output = AutoCraftOutput.readFromNBT(tag.m_128469_("AutoCraftOutput"));
        int count = tag.m_128451_("Count");
        AutoCraftSystem system = new AutoCraftSystem(output, new LinkedList<AutoCraftStack>());
        system.count = count;
        system.isEnd = tag.m_128471_("IsEnd");
        ListTag listTag = tag.m_128437_("PatternStacks", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag stackTag = listTag.m_128728_(i);
            system.patternStacks.add(AutoCraftStack.readFromNBT(stackTag));
        }
        return system;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public AutoCraftOutput getAutoCraftOutput() {
        return this.autoCraftOutput;
    }

    public List<AutoCraftStack> getPatternStacks() {
        return this.patternStacks;
    }

    public void removeCountAutoCraftStack(int amount) {
        this.count -= Math.min(amount, this.count);
        this.isEnd = this.count == 0;
    }
}

