/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.storage.autocrafting;

import com.denfop.api.storage.autocrafting.PatternStack;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class AutoCraftOutput {
    private final PatternStack patternStack;
    private int amount;
    private int all;
    private int create = 0;

    public AutoCraftOutput(PatternStack patternStack, int amount) {
        this.patternStack = patternStack;
        this.amount = amount;
        this.all = patternStack.output().getAmount() * amount;
    }

    public AutoCraftOutput(PatternStack patternStack, int amount, int all, int create) {
        this.patternStack = patternStack;
        this.amount = amount;
        this.all = all;
        this.create = create;
    }

    public void addCreate(int create) {
        this.create += create;
    }

    public void removeCreate(int create) {
        this.create -= create;
    }

    public int getCreate() {
        return this.create;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoCraftOutput that = (AutoCraftOutput)o;
        return Objects.equals(this.patternStack, that.patternStack);
    }

    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("PatternStack", (Tag)this.patternStack.writeToNBT());
        nbt.m_128405_("Amount", this.amount);
        nbt.m_128405_("All", this.all);
        nbt.m_128405_("Create", this.create);
        return nbt;
    }

    public static AutoCraftOutput readFromNBT(CompoundTag nbt) {
        PatternStack patternStack = PatternStack.readFromNBT(nbt.m_128469_("PatternStack"));
        int amount = nbt.m_128451_("Amount");
        int all = nbt.m_128451_("All");
        int create = nbt.m_128451_("Create");
        return new AutoCraftOutput(patternStack, amount, all, create);
    }

    public int hashCode() {
        return Objects.hash(this.patternStack);
    }

    public void removeAmount(int amount) {
        this.amount -= amount;
    }

    public void removeAllAmount(int amount) {
        this.all -= amount;
    }

    public PatternStack getPatternStack() {
        return this.patternStack;
    }

    public int getAmount() {
        return this.amount;
    }

    public int getAll() {
        return this.all;
    }

    public void addAmount(int amount) {
        this.amount += amount;
    }

    public PatternStack patternStack() {
        return this.patternStack;
    }

    public int count() {
        return this.amount;
    }
}

