/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space;

import com.denfop.api.space.IBaseResource;
import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.rovers.enums.EnumTypeRovers;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BaseResource
implements IBaseResource {
    private final FluidStack fluidStack;
    private final EnumTypeRovers typeRovers;
    private ItemStack stack;
    private int max;
    private int min;
    private IBody body;
    private int percentplanet;

    public BaseResource(ItemStack stack, int minchance, int maxchance, int percentplanet, IBody body, EnumTypeRovers typeRovers) {
        this.stack = stack;
        this.fluidStack = null;
        this.max = maxchance;
        this.typeRovers = typeRovers;
        this.min = minchance;
        this.body = body;
        this.percentplanet = percentplanet;
        SpaceNet.instance.addResource(this);
    }

    public BaseResource(FluidStack fluidStack, int minchance, int maxchance, int percentplanet, IBody body, EnumTypeRovers typeRovers) {
        this.stack = null;
        this.fluidStack = fluidStack;
        this.max = maxchance;
        this.min = minchance;
        this.body = body;
        this.typeRovers = typeRovers;
        this.percentplanet = percentplanet;
        SpaceNet.instance.addResource(this);
    }

    public BaseResource(CompoundTag tagCompound) {
        this.percentplanet = tagCompound.m_128445_("percentplanet");
        this.min = tagCompound.m_128445_("min");
        this.max = tagCompound.m_128445_("max");
        this.stack = tagCompound.m_128471_("hasItem") ? ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_("stack")) : null;
        this.fluidStack = tagCompound.m_128471_("hasFluid") ? FluidStack.loadFluidStackFromNBT((CompoundTag)tagCompound.m_128469_("fluidStack")) : null;
        this.typeRovers = EnumTypeRovers.values()[tagCompound.m_128445_("rovers")];
    }

    @Override
    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    @Override
    public int getPercentResearchBody() {
        return this.percentplanet;
    }

    @Override
    public int getChance() {
        return this.min;
    }

    @Override
    public int getMaxChance() {
        return this.max;
    }

    @Override
    public IBody getBody() {
        return this.body;
    }

    @Override
    public int getPercentPanel() {
        return this.percentplanet;
    }

    @Override
    public CompoundTag writeNBTTag(CompoundTag tagCompound) {
        tagCompound.m_128344_("percentplanet", (byte)this.percentplanet);
        tagCompound.m_128344_("min", (byte)this.min);
        tagCompound.m_128344_("max", (byte)this.max);
        tagCompound.m_128344_("rovers", (byte)this.typeRovers.ordinal());
        tagCompound.m_128379_("hasItem", this.stack != null);
        if (this.stack != null) {
            tagCompound.m_128365_("stack", (Tag)this.stack.m_41739_(new CompoundTag()));
        }
        tagCompound.m_128379_("hasFluid", this.fluidStack != null);
        if (this.fluidStack != null) {
            tagCompound.m_128365_("fluidStack", (Tag)this.fluidStack.writeToNBT(new CompoundTag()));
        }
        return tagCompound;
    }

    @Override
    public EnumTypeRovers getTypeRovers() {
        return this.typeRovers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseResource that = (BaseResource)o;
        return this.max == that.max && this.min == that.min && this.percentplanet == that.percentplanet && Objects.equals(this.fluidStack, that.fluidStack) && this.typeRovers == that.typeRovers && Objects.equals(this.stack, that.stack) && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fluidStack, this.typeRovers, this.stack, this.max, this.min, this.body, this.percentplanet});
    }
}

