/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.bee.genetics;

import com.denfop.api.bee.genetics.EnumGenetic;
import com.denfop.api.bee.genetics.GeneticTraits;
import com.denfop.api.bee.genetics.GenomeBase;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class Genome
implements GenomeBase {
    Map<EnumGenetic, GeneticTraits> geneticTraitsMap = new HashMap<EnumGenetic, GeneticTraits>();
    private ItemStack stack;

    public Genome(ItemStack stack) {
        CompoundTag nbt;
        CompoundTag nbt1 = ModUtils.nbt(stack);
        if (!nbt1.m_128441_("genome")) {
            nbt = new CompoundTag();
            nbt1.m_128365_("genome", (Tag)nbt);
        }
        nbt = nbt1.m_128469_("genome");
        ListTag tagList = nbt.m_128437_("genomeList", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag genomeNbt = tagList.m_128728_(i);
            byte meta = genomeNbt.m_128445_("meta");
            GeneticTraits geneticTraits = GeneticTraits.values()[meta];
            this.geneticTraitsMap.put(geneticTraits.getGenetic(), geneticTraits);
        }
        this.stack = stack;
    }

    public Genome(Map<EnumGenetic, GeneticTraits> geneticTraitsMap) {
        this.geneticTraitsMap = new HashMap<EnumGenetic, GeneticTraits>(geneticTraitsMap);
    }

    public Map<EnumGenetic, GeneticTraits> getGeneticTraitsMap() {
        return this.geneticTraitsMap;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Genome genome = (Genome)o;
        return this.geneticTraitsMap.values().size() == genome.geneticTraitsMap.size() && this.checkGenomes(genome);
    }

    private boolean checkGenomes(Genome genome) {
        ArrayList<GeneticTraits> geneticTraits = new ArrayList<GeneticTraits>(genome.geneticTraitsMap.values());
        ArrayList<GeneticTraits> geneticTraits1 = new ArrayList<GeneticTraits>(this.geneticTraitsMap.values());
        geneticTraits1.removeIf(geneticTraits::contains);
        return geneticTraits1.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.geneticTraitsMap);
    }

    public void addGenome(GeneticTraits geneticTraits, ItemStack stack) {
        if (!this.geneticTraitsMap.containsKey((Object)geneticTraits.getGenetic())) {
            this.geneticTraitsMap.put(geneticTraits.getGenetic(), geneticTraits);
            this.writeNBT(ModUtils.nbt(stack));
        }
    }

    public void addGenome(GeneticTraits geneticTraits) {
        if (!this.geneticTraitsMap.containsKey((Object)geneticTraits.getGenetic())) {
            this.geneticTraitsMap.put(geneticTraits.getGenetic(), geneticTraits);
            this.writeNBT(ModUtils.nbt(this.stack));
        }
    }

    public void removeGenome(GeneticTraits geneticTraits, ItemStack stack) {
        if (this.geneticTraitsMap.containsKey((Object)geneticTraits.getGenetic())) {
            this.geneticTraitsMap.remove((Object)geneticTraits.getGenetic(), (Object)geneticTraits);
            this.writeNBT(ModUtils.nbt(stack));
        }
    }

    public GeneticTraits removeGenome(EnumGenetic genetic, ItemStack stack) {
        if (this.geneticTraitsMap.containsKey((Object)genetic)) {
            GeneticTraits value = this.geneticTraitsMap.remove((Object)genetic);
            this.writeNBT(ModUtils.nbt(stack));
            return value;
        }
        return null;
    }

    @Override
    public CompoundTag writeNBT(CompoundTag nbtTagCompound) {
        ListTag genomeNBT = new ListTag();
        for (GeneticTraits geneticTraits : this.geneticTraitsMap.values()) {
            CompoundTag nbtTagCompound1 = new CompoundTag();
            nbtTagCompound1.m_128344_("meta", (byte)geneticTraits.ordinal());
            genomeNBT.add((Object)nbtTagCompound1);
        }
        CompoundTag nbt = nbtTagCompound.m_128469_("genome");
        nbt.m_128365_("genomeList", (Tag)genomeNBT);
        nbtTagCompound.m_128365_("genome", (Tag)nbt);
        return nbtTagCompound;
    }

    @Override
    public boolean hasGenome(EnumGenetic genome) {
        return this.geneticTraitsMap.containsKey((Object)genome);
    }

    @Override
    public <T> T getLevelGenome(EnumGenetic genome, Class<T> tClass) {
        return this.geneticTraitsMap.get((Object)genome).getValue(tClass);
    }

    @Override
    public GeneticTraits getGenome(EnumGenetic genome) {
        return this.geneticTraitsMap.get((Object)genome);
    }

    @Override
    public Genome copy() {
        Genome genome = new Genome(this.geneticTraitsMap);
        genome.stack = this.stack.m_41777_();
        return genome;
    }
}

