/*
 * Decompiled with CFR 0.152.
 */
package com.impatus.uibuttons;

import com.impatus.uibuttons.ButtonsConfig;
import com.impatus.uibuttons.EditorScreen;
import com.impatus.uibuttons.MacroButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod(value="uibuttons")
public class UIMacroButtonsMod {
    public static final List<Button> LIVE_BUTTONS = new ArrayList<Button>();
    public static boolean EDIT_MODE = false;
    public static boolean DRAG_MODE = false;
    private static int draggingIndex = -1;
    private static int grabDX = 0;
    private static int grabDY = 0;
    private static boolean SUPPRESS_CLOSE_ON_EDITOR_OPEN = false;
    private static final int GUI_W = 176;
    private static final int GUI_H = 166;
    private static final int GRID = 2;

    public UIMacroButtonsMod() {
        ButtonsConfig.load();
    }

    private static int snap(int v, int grid) {
        if (grid <= 1) {
            return v;
        }
        int r = v % grid;
        if (r < 0) {
            r += grid;
        }
        return v - r;
    }

    @Mod.EventBusSubscriber(modid="uibuttons", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
        }

        @SubscribeEvent
        public static void onScreenClosing(ScreenEvent.Closing event) {
            Screen s = event.getScreen();
            boolean isInventory = s instanceof InventoryScreen;
            boolean isContainer = s instanceof AbstractContainerScreen;
            if (!EDIT_MODE || !isInventory && !isContainer) {
                return;
            }
            if (SUPPRESS_CLOSE_ON_EDITOR_OPEN) {
                SUPPRESS_CLOSE_ON_EDITOR_OPEN = false;
                return;
            }
            EDIT_MODE = false;
            DRAG_MODE = false;
            draggingIndex = -1;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                mc.f_91065_.m_93076_().m_93785_((Component)Component.m_237113_((String)"[UI Buttons] Edit mode OFF"));
            }
        }

        @SubscribeEvent
        public static void onScreenInit(ScreenEvent.Init.Post event) {
            Screen s = event.getScreen();
            boolean isInventory = s instanceof InventoryScreen;
            boolean isContainer = s instanceof AbstractContainerScreen;
            if (!isInventory && !isContainer) {
                LIVE_BUTTONS.clear();
                return;
            }
            int left = (s.f_96543_ - 176) / 2;
            int top = (s.f_96544_ - 166) / 2;
            LIVE_BUTTONS.clear();
            for (int i = 0; i < ButtonsConfig.buttons.size(); ++i) {
                int x;
                int index = i;
                ButtonsConfig.ButtonSpec spec = ButtonsConfig.buttons.get(i);
                if (spec.scope == ButtonsConfig.Scope.INVENTORY_ONLY && !isInventory) {
                    LIVE_BUTTONS.add(null);
                    continue;
                }
                MacroButton btn = new MacroButton(x, switch (spec.anchor) {
                    case ButtonsConfig.Anchor.RIGHT -> {
                        x = left + 176 + spec.xOffset;
                        yield top + spec.yOffset;
                    }
                    case ButtonsConfig.Anchor.LEFT -> {
                        x = left - spec.xOffset - spec.width;
                        yield top + spec.yOffset;
                    }
                    case ButtonsConfig.Anchor.BOTTOM -> {
                        x = left + (176 - spec.width) / 2 + spec.xOffset;
                        yield top + 166 + spec.yOffset;
                    }
                    default -> {
                        x = left + 176 + spec.xOffset;
                        yield top + spec.yOffset;
                    }
                }, Math.max(20, spec.width), Math.max(20, spec.height), spec, b -> {
                    Minecraft mc = Minecraft.m_91087_();
                    if (EDIT_MODE) {
                        if (!DRAG_MODE) {
                            SUPPRESS_CLOSE_ON_EDITOR_OPEN = true;
                            mc.m_91152_((Screen)new EditorScreen(index));
                        }
                    } else if (mc.f_91074_ != null && mc.f_91074_.f_108617_ != null) {
                        String cmd;
                        String string = cmd = spec.command == null ? "" : spec.command.trim();
                        if (!cmd.isEmpty()) {
                            if (cmd.startsWith("/")) {
                                cmd = cmd.substring(1);
                            }
                            mc.f_91074_.f_108617_.m_246623_(cmd);
                        }
                    }
                });
                event.addListener((GuiEventListener)btn);
                LIVE_BUTTONS.add(btn);
            }
            if (EDIT_MODE && isInventory) {
                int newX = left + 176 + 4;
                int newY = Math.max(4, top - 22);
                Button createBtn = Button.m_253074_((Component)Component.m_237113_((String)"Create Macro"), b -> {
                    SUPPRESS_CLOSE_ON_EDITOR_OPEN = true;
                    Minecraft.m_91087_().m_91152_((Screen)new EditorScreen());
                }).m_252987_(newX, newY, 100, 20).m_253136_();
                event.addListener((GuiEventListener)createBtn);
                int dragX = newX + 106;
                int dragY = newY;
                Button dragBtn = Button.m_253074_((Component)Component.m_237113_((String)("Drag: " + (DRAG_MODE ? "ON" : "OFF"))), b -> {
                    DRAG_MODE = !DRAG_MODE;
                    b.m_93666_((Component)Component.m_237113_((String)("Drag: " + (DRAG_MODE ? "ON" : "OFF"))));
                    draggingIndex = -1;
                }).m_252987_(dragX, dragY, 90, 20).m_253136_();
                event.addListener((GuiEventListener)dragBtn);
            }
        }

        @SubscribeEvent
        public static void onMouseDown(ScreenEvent.MouseButtonPressed.Pre event) {
            if (!EDIT_MODE || !DRAG_MODE) {
                return;
            }
            Screen s = event.getScreen();
            boolean isInventory = s instanceof InventoryScreen;
            boolean isContainer = s instanceof AbstractContainerScreen;
            if (!isInventory && !isContainer) {
                return;
            }
            if (event.getButton() != 0) {
                return;
            }
            if (LIVE_BUTTONS.isEmpty()) {
                return;
            }
            int mx = (int)Math.round(event.getMouseX());
            int my = (int)Math.round(event.getMouseY());
            for (int i = 0; i < LIVE_BUTTONS.size(); ++i) {
                Button btn = LIVE_BUTTONS.get(i);
                if (btn == null) continue;
                int x = btn.m_252754_();
                int y = btn.m_252907_();
                int w = btn.m_5711_();
                int h = btn.m_93694_();
                if (mx < x || mx >= x + w || my < y || my >= y + h) continue;
                draggingIndex = i;
                grabDX = mx - x;
                grabDY = my - y;
                return;
            }
        }

        @SubscribeEvent
        public static void onMouseDrag(ScreenEvent.MouseDragged.Pre event) {
            Button live;
            if (!EDIT_MODE || !DRAG_MODE) {
                return;
            }
            if (draggingIndex < 0) {
                return;
            }
            Screen s = event.getScreen();
            boolean isInventory = s instanceof InventoryScreen;
            boolean isContainer = s instanceof AbstractContainerScreen;
            if (!isInventory && !isContainer) {
                return;
            }
            if (draggingIndex >= ButtonsConfig.buttons.size()) {
                draggingIndex = -1;
                return;
            }
            ButtonsConfig.ButtonSpec spec = ButtonsConfig.buttons.get(draggingIndex);
            Button button = live = draggingIndex < LIVE_BUTTONS.size() ? LIVE_BUTTONS.get(draggingIndex) : null;
            if (live == null) {
                draggingIndex = -1;
                return;
            }
            int left = (s.f_96543_ - 176) / 2;
            int top = (s.f_96544_ - 166) / 2;
            int mx = (int)Math.round(event.getMouseX());
            int my = (int)Math.round(event.getMouseY());
            int newX = UIMacroButtonsMod.snap(mx - grabDX, 2);
            int newY = UIMacroButtonsMod.snap(my - grabDY, 2);
            switch (spec.anchor) {
                case RIGHT: {
                    spec.xOffset = newX - (left + 176);
                    spec.yOffset = newY - top;
                    break;
                }
                case LEFT: {
                    spec.xOffset = left - spec.width - newX;
                    if (spec.xOffset < 0) {
                        spec.xOffset = 0;
                    }
                    spec.yOffset = newY - top;
                    break;
                }
                case BOTTOM: {
                    int baseX = left + (176 - spec.width) / 2;
                    spec.xOffset = newX - baseX;
                    spec.yOffset = newY - (top + 166);
                }
            }
            live.m_252865_(newX);
            live.m_253211_(newY);
        }

        @SubscribeEvent
        public static void onMouseUp(ScreenEvent.MouseButtonReleased.Pre event) {
            if (!EDIT_MODE || !DRAG_MODE) {
                return;
            }
            if (event.getButton() != 0) {
                return;
            }
            if (draggingIndex >= 0) {
                ButtonsConfig.save();
                draggingIndex = -1;
            }
        }
    }
}

