/*
 * Decompiled with CFR 0.152.
 */
package com.impatus.uibuttons;

import com.impatus.uibuttons.ButtonsConfig;
import com.impatus.uibuttons.IconManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class IconPickerScreen
extends Screen {
    private final Screen parent;
    private final BiConsumer<ButtonsConfig.IconKind, String> onPick;
    private ButtonsConfig.IconKind kindInit;
    private String valueInit;
    private CycleButton<ButtonsConfig.IconKind> sourceBtn;
    private EditBox searchBox;
    private static final int CELL = 20;
    private static final int PAD = 6;
    private int cols = 12;
    private int rows = 6;
    private int pageSize = this.cols * this.rows;
    private int gridX;
    private int gridY;
    private int gridW;
    private int gridH;
    private final List<String> all = new ArrayList<String>();
    private List<String> filtered = new ArrayList<String>();
    private int page = 0;
    private String selectedValue = null;
    private Button prevBtn;
    private Button nextBtn;
    private Button useBtn;
    private Button cancelBtn;

    public IconPickerScreen(Screen parent, ButtonsConfig.IconKind currentKind, String currentValue, BiConsumer<ButtonsConfig.IconKind, String> onPick) {
        super((Component)Component.m_237113_((String)"Pick Icon"));
        this.parent = parent;
        this.kindInit = currentKind == null || currentKind == ButtonsConfig.IconKind.NONE ? ButtonsConfig.IconKind.ITEM : currentKind;
        this.valueInit = currentValue == null ? "" : currentValue;
        this.onPick = onPick;
    }

    protected void m_7856_() {
        int cx = this.f_96543_ / 2;
        int panelW = Math.min(Math.max(420, 320), this.f_96543_ - 40);
        int y = this.f_96544_ / 2 - 132;
        this.sourceBtn = (CycleButton)this.m_142416_((GuiEventListener)CycleButton.m_168894_(k -> Component.m_237113_((String)k.name())).m_168961_((Object[])new ButtonsConfig.IconKind[]{ButtonsConfig.IconKind.ITEM, ButtonsConfig.IconKind.IMAGE}).m_168948_((Object)this.kindInit).m_168930_(cx - panelW / 2, y, panelW, 20, (Component)Component.m_237113_((String)"Source")));
        this.searchBox = new EditBox(this.f_96547_, cx - panelW / 2, y += 24, panelW, 20, (Component)Component.m_237113_((String)"Search"));
        this.searchBox.m_94199_(200);
        this.searchBox.m_94144_("");
        this.m_142416_((GuiEventListener)this.searchBox);
        y += 28;
        this.cols = Math.max(6, Math.min(16, (panelW + 6) / 26));
        this.rows = 6;
        this.pageSize = this.cols * this.rows;
        this.gridW = this.cols * 26 - 6;
        this.gridH = this.rows * 26 - 6;
        this.gridX = cx - this.gridW / 2;
        this.gridY = y;
        int controlsY = this.gridY + this.gridH + 12;
        this.prevBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<< Prev"), b -> {
            if (this.page > 0) {
                --this.page;
                this.updateNavStates();
            }
        }).m_252987_(cx - panelW / 2, controlsY, 80, 20).m_253136_());
        this.nextBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Next >>"), b -> {
            int maxPage = Math.max(0, (this.filtered.size() - 1) / this.pageSize);
            if (this.page < maxPage) {
                ++this.page;
                this.updateNavStates();
            }
        }).m_252987_(cx - panelW / 2 + 86, controlsY, 80, 20).m_253136_());
        this.useBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Use Selected"), b -> {
            if (this.selectedValue != null) {
                this.onPick.accept((ButtonsConfig.IconKind)((Object)((Object)this.sourceBtn.m_168883_())), this.selectedValue);
                Minecraft.m_91087_().m_91152_(this.parent);
            }
        }).m_252987_(cx + panelW / 2 - 180, controlsY, 110, 20).m_253136_());
        this.cancelBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> Minecraft.m_91087_().m_91152_(this.parent)).m_252987_(cx + panelW / 2 - 64, controlsY, 64, 20).m_253136_());
        this.rebuildData();
        this.m_264313_((GuiEventListener)this.searchBox);
    }

    private void rebuildData() {
        this.all.clear();
        this.selectedValue = null;
        if (this.sourceBtn.m_168883_() == ButtonsConfig.IconKind.ITEM) {
            for (ResourceLocation id : ForgeRegistries.ITEMS.getKeys()) {
                this.all.add(id.toString());
            }
            Collections.sort(this.all);
        } else {
            try (Stream<Path> stream = Files.list(ButtonsConfig.IMG_DIR);){
                this.all.addAll(stream.filter(p -> p.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".png")).map(p -> p.getFileName().toString()).sorted(Comparator.naturalOrder()).collect(Collectors.toList()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.filterAndGotoValue(this.valueInit);
        this.updateNavStates();
    }

    private void filterAndGotoValue(String preferredValue) {
        int idx;
        String q = this.searchBox.m_94155_().trim().toLowerCase(Locale.ROOT);
        if (q.isEmpty()) {
            this.filtered = this.all;
        } else {
            String[] tokens = q.split("\\s+");
            this.filtered = this.all.stream().filter(s -> {
                String t = s.toLowerCase(Locale.ROOT);
                for (String tok : tokens) {
                    if (t.contains(tok)) continue;
                    return false;
                }
                return true;
            }).collect(Collectors.toList());
        }
        this.page = 0;
        this.selectedValue = null;
        if (preferredValue != null && !preferredValue.isEmpty() && (idx = this.filtered.indexOf(preferredValue)) >= 0) {
            this.page = idx / this.pageSize;
            this.selectedValue = preferredValue;
        }
    }

    private void updateNavStates() {
        int maxPage = Math.max(0, (this.filtered.size() - 1) / this.pageSize);
        if (this.prevBtn != null) {
            boolean bl = this.prevBtn.f_93623_ = this.page > 0;
        }
        if (this.nextBtn != null) {
            boolean bl = this.nextBtn.f_93623_ = this.page < maxPage;
        }
        if (this.useBtn != null) {
            this.useBtn.f_93623_ = this.selectedValue != null;
        }
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        boolean r = super.m_5534_(codePoint, modifiers);
        if (this.searchBox.m_93696_()) {
            this.filterAndGotoValue(null);
            this.updateNavStates();
        }
        return r;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean r = super.m_7933_(keyCode, scanCode, modifiers);
        if (this.searchBox.m_93696_()) {
            this.filterAndGotoValue(null);
            this.updateNavStates();
        }
        return r;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseY >= (double)this.gridY && mouseY < (double)(this.gridY + this.gridH) && mouseX >= (double)this.gridX && mouseX < (double)(this.gridX + this.gridW)) {
            int idxInPage;
            int globalIdx;
            int relX = (int)mouseX - this.gridX;
            int relY = (int)mouseY - this.gridY;
            int col = relX / 26;
            int row = relY / 26;
            if (col >= 0 && col < this.cols && row >= 0 && row < this.rows && (globalIdx = this.page * this.pageSize + (idxInPage = row * this.cols + col)) >= 0 && globalIdx < this.filtered.size()) {
                this.selectedValue = this.filtered.get(globalIdx);
                this.updateNavStates();
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.sourceBtn != null && this.sourceBtn.m_168883_() != this.kindInit) {
            this.kindInit = (ButtonsConfig.IconKind)((Object)this.sourceBtn.m_168883_());
            this.rebuildData();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(g);
        super.m_88315_(g, mouseX, mouseY, partialTicks);
        int cx = this.f_96543_ / 2;
        g.m_280137_(this.f_96547_, "Pick Icon", cx, this.f_96544_ / 2 - 148, 0xFFFFFF);
        g.m_280509_(this.gridX - 2, this.gridY - 2, this.gridX + this.gridW + 2, this.gridY + this.gridH + 2, 0x66000000);
        int start = this.page * this.pageSize;
        int end = Math.min(this.filtered.size(), start + this.pageSize);
        for (int i = 0; i < end - start; ++i) {
            int col = i % this.cols;
            int row = i / this.cols;
            int x = this.gridX + col * 26;
            int y = this.gridY + row * 26;
            String val = this.filtered.get(start + i);
            if (val.equals(this.selectedValue)) {
                g.m_280509_(x - 1, y - 1, x + 20 + 1, y, -1);
                g.m_280509_(x - 1, y + 20, x + 20 + 1, y + 20 + 1, -1);
                g.m_280509_(x - 1, y, x, y + 20, -1);
                g.m_280509_(x + 20, y, x + 20 + 1, y + 20, -1);
            }
            if (this.sourceBtn.m_168883_() == ButtonsConfig.IconKind.ITEM) {
                try {
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(val));
                    if (item == null) continue;
                    ItemStack stack = new ItemStack((ItemLike)item);
                    g.m_280480_(stack, x + 2, y + 2);
                }
                catch (Exception item) {}
                continue;
            }
            IconManager.Img img = IconManager.get(val);
            if (img != null) {
                g.m_280411_(img.rl, x, y, 20, 20, 0.0f, 0.0f, img.w, img.h, img.w, img.h);
                continue;
            }
            g.m_280509_(x, y, x + 20, y + 20, -14540254);
            g.m_280056_(this.f_96547_, "X", x + 7, y + 6, -65536, false);
        }
        g.m_280137_(this.f_96547_, "Items: ids like minecraft:diamond \u2022 Images: put PNGs in config/uibuttons/textures/", cx, this.gridY + this.gridH + 36, 0xAAAAAA);
    }
}

