/*
 * Decompiled with CFR 0.152.
 */
package com.impatus.uibuttons;

import com.impatus.uibuttons.ButtonsConfig;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public final class IconManager {
    private static final Map<String, Img> CACHE = new HashMap<String, Img>();

    public static Img get(String fileName) {
        Img img;
        block12: {
            if (fileName == null || fileName.isBlank()) {
                return null;
            }
            Path p = ButtonsConfig.IMG_DIR.resolve(fileName).normalize();
            if (!p.startsWith(ButtonsConfig.IMG_DIR)) {
                return null;
            }
            if (!Files.exists(p, new LinkOption[0])) {
                return null;
            }
            Img cached = CACHE.get(fileName);
            if (cached != null) {
                return cached;
            }
            InputStream in = Files.newInputStream(p, new OpenOption[0]);
            try {
                NativeImage img2 = NativeImage.m_85058_((InputStream)in);
                DynamicTexture tex = new DynamicTexture(img2);
                String key = "icons/" + Integer.toHexString(fileName.hashCode());
                ResourceLocation rl = new ResourceLocation("uibuttons", key);
                Minecraft.m_91087_().m_91097_().m_118495_(rl, (AbstractTexture)tex);
                Img wrapped = new Img(rl, img2.m_84982_(), img2.m_85084_());
                CACHE.put(fileName, wrapped);
                img = wrapped;
                if (in == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            in.close();
        }
        return img;
    }

    public static final class Img {
        public final ResourceLocation rl;
        public final int w;
        public final int h;

        public Img(ResourceLocation rl, int w, int h) {
            this.rl = rl;
            this.w = w;
            this.h = h;
        }
    }
}

