/*
 * Decompiled with CFR 0.152.
 */
package com.impatus.uibuttons;

import com.impatus.uibuttons.ButtonsConfig;
import com.impatus.uibuttons.IconPickerScreen;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class EditorScreen
extends Screen {
    private EditBox labelBox;
    private EditBox cmdBox;
    private EditBox widthBox;
    private EditBox heightBox;
    private EditBox iconValueBox;
    private String pendingIconValue = null;
    private final Integer editIndex;
    private static final int GUI_W = 176;
    private static final int GUI_H = 166;
    private static final int PADX = 6;
    private static final int PADY = 10;
    private static final int SP = 4;

    public EditorScreen() {
        super((Component)Component.m_237113_((String)"Create Macro"));
        this.editIndex = null;
    }

    public EditorScreen(int index) {
        super((Component)Component.m_237113_((String)"Edit Macro"));
        this.editIndex = index;
    }

    protected void m_7856_() {
        int cx = this.f_96543_ / 2;
        int y = this.f_96544_ / 2 - 90;
        int w = 200;
        ButtonsConfig.ButtonSpec existing = null;
        if (this.editIndex != null && this.editIndex >= 0 && this.editIndex < ButtonsConfig.buttons.size()) {
            existing = ButtonsConfig.buttons.get(this.editIndex);
        }
        if (this.pendingIconValue == null) {
            this.pendingIconValue = existing != null ? existing.iconValue : "";
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Label (optional):"), b -> {}).m_252987_(cx - w / 2 - 110, y, 100, 20).m_253136_());
        this.labelBox = new EditBox(this.f_96547_, cx - w / 2, y, w, 20, (Component)Component.m_237113_((String)"Label"));
        this.labelBox.m_94199_(64);
        this.labelBox.m_94144_(existing != null ? (existing.label == null ? "" : existing.label) : "");
        this.m_142416_((GuiEventListener)this.labelBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Command:"), b -> {}).m_252987_(cx - w / 2 - 110, y += 24, 100, 20).m_253136_());
        this.cmdBox = new EditBox(this.f_96547_, cx - w / 2, y, w, 20, (Component)Component.m_237113_((String)"Command"));
        this.cmdBox.m_94144_(existing != null ? existing.command : "/help");
        this.m_142416_((GuiEventListener)this.cmdBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Width:"), b -> {}).m_252987_(cx - w / 2 - 110, y += 24, 100, 20).m_253136_());
        this.widthBox = new EditBox(this.f_96547_, cx - w / 2, y, 96, 20, (Component)Component.m_237113_((String)"Width"));
        this.widthBox.m_94153_(EditorScreen::isDigits);
        this.widthBox.m_94144_(String.valueOf(existing != null ? Math.max(20, existing.width) : 20));
        this.m_142416_((GuiEventListener)this.widthBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Height:"), b -> {}).m_252987_(cx + w / 2 - 96, y, 96, 20).m_253136_());
        this.heightBox = new EditBox(this.f_96547_, cx + w / 2, y, 96, 20, (Component)Component.m_237113_((String)"Height"));
        this.heightBox.m_94153_(EditorScreen::isDigits);
        this.heightBox.m_94144_(String.valueOf(existing != null ? Math.max(20, existing.height) : 20));
        this.m_142416_((GuiEventListener)this.heightBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Icon Value:"), b -> {}).m_252987_(cx - w / 2 - 110, y += 24, 100, 20).m_253136_());
        this.iconValueBox = new EditBox(this.f_96547_, cx - w / 2, y, w, 20, (Component)Component.m_237113_((String)"Icon Value"));
        this.iconValueBox.m_94199_(200);
        this.iconValueBox.m_94144_(this.pendingIconValue);
        this.m_142416_((GuiEventListener)this.iconValueBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Pick\u2026"), b -> Minecraft.m_91087_().m_91152_((Screen)new IconPickerScreen(this, ButtonsConfig.IconKind.ITEM, this.iconValueBox.m_94155_(), (kind, value) -> {
            this.pendingIconValue = value;
            this.iconValueBox.m_94144_(value);
        }))).m_252987_(cx + w / 2 + 6, y, 64, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Open icons folder"), b -> {
            try {
                Util.m_137581_().m_137644_(ButtonsConfig.IMG_DIR.toFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).m_252987_(cx - w / 2, y += 24, w, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> this.onSave()).m_252987_(cx - 90, y += 24, 80, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.onCancel()).m_252987_(cx + 10, y, 80, 20).m_253136_());
        y += 24;
        if (existing != null) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Delete"), b -> this.onDelete()).m_252987_(cx - 40, y, 80, 20).m_253136_());
        }
        this.m_264313_((GuiEventListener)this.labelBox);
    }

    private static boolean isDigits(String s) {
        if (s == null || s.isEmpty()) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private void onSave() {
        String iconVal;
        String label = this.labelBox.m_94155_();
        String cmd = this.cmdBox.m_94155_().trim();
        if (cmd.isEmpty()) {
            cmd = "/help";
        }
        int w = this.parseOr(this.widthBox.m_94155_(), 20);
        int h = this.parseOr(this.heightBox.m_94155_(), 20);
        if (w < 20) {
            w = 20;
        }
        if (h < 20) {
            h = 20;
        }
        String string = iconVal = this.pendingIconValue != null ? this.pendingIconValue.trim() : this.iconValueBox.m_94155_().trim();
        if (this.editIndex != null && this.editIndex >= 0 && this.editIndex < ButtonsConfig.buttons.size()) {
            spec = ButtonsConfig.buttons.get(this.editIndex);
            spec.label = label;
            spec.command = cmd;
            spec.anchor = ButtonsConfig.Anchor.RIGHT;
            spec.scope = ButtonsConfig.Scope.INVENTORY_ONLY;
            spec.width = w;
            spec.height = h;
            spec.iconValue = iconVal;
        } else {
            spec = new ButtonsConfig.ButtonSpec();
            spec.label = label;
            spec.command = cmd;
            spec.anchor = ButtonsConfig.Anchor.RIGHT;
            spec.scope = ButtonsConfig.Scope.INVENTORY_ONLY;
            spec.width = w;
            spec.height = h;
            spec.iconValue = iconVal;
            int indexSameAnchor = this.countWithAnchor(spec.anchor);
            int rowsPerCol = Math.max(1, 146 / (h + 4));
            int col = indexSameAnchor / rowsPerCol;
            int row = indexSameAnchor % rowsPerCol;
            spec.xOffset = 6 + col * (w + 4);
            spec.yOffset = 10 + row * (h + 4);
            ButtonsConfig.buttons.add(spec);
        }
        ButtonsConfig.save();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            mc.m_91152_((Screen)new InventoryScreen((Player)mc.f_91074_));
        } else {
            this.m_7379_();
        }
    }

    private void onDelete() {
        if (this.editIndex != null && this.editIndex >= 0 && this.editIndex < ButtonsConfig.buttons.size()) {
            ButtonsConfig.buttons.remove(this.editIndex);
            ButtonsConfig.save();
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            mc.m_91152_((Screen)new InventoryScreen((Player)mc.f_91074_));
        } else {
            this.m_7379_();
        }
    }

    private int countWithAnchor(ButtonsConfig.Anchor a) {
        int c = 0;
        for (ButtonsConfig.ButtonSpec s : ButtonsConfig.buttons) {
            if (s.anchor != a) continue;
            ++c;
        }
        return c;
    }

    private int parseOr(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private void onCancel() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            mc.m_91152_((Screen)new InventoryScreen((Player)mc.f_91074_));
        } else {
            this.m_7379_();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(g);
        super.m_88315_(g, mouseX, mouseY, partialTicks);
        int cx = this.f_96543_ / 2;
        g.m_280137_(this.f_96547_, "Tip: Label is optional (shown as tooltip). Use Pick\u2026 for items/PNGs. Save to apply.", cx, this.f_96544_ / 2 - 140, 0xAAAAAA);
        g.m_280137_(this.f_96547_, this.editIndex == null ? "Create Macro" : "Edit Macro", cx, this.f_96544_ / 2 - 120, 0xFFFFFF);
    }
}

