/*
 * Decompiled with CFR 0.152.
 */
package com.impatus.uibuttons;

import com.impatus.uibuttons.ButtonsConfig;
import com.impatus.uibuttons.EditorScreen;
import com.impatus.uibuttons.UIMacroButtonsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EditorController {
    public static boolean dragEnabled = true;
    private static Button lockBtnRef = null;
    private static Button createBtnRef = null;
    private static final int GRID = 8;
    private static int draggingIndex = -1;
    private static int grabDX = 0;
    private static int grabDY = 0;
    private static int leftCache = 0;
    private static int topCache = 0;
    private static final int GUI_W = 176;
    private static final int GUI_H = 166;

    @SubscribeEvent
    public void onScreenInit(ScreenEvent.Init.Post event) {
        if (!UIMacroButtonsMod.EDIT_MODE) {
            return;
        }
        Screen s = event.getScreen();
        boolean isInventory = s instanceof InventoryScreen;
        boolean isContainer = s instanceof AbstractContainerScreen;
        if (!isInventory && !isContainer) {
            return;
        }
        lockBtnRef = Button.m_253074_((Component)Component.m_237113_((String)(dragEnabled ? "Drag: ON" : "Drag: OFF")), b -> {
            boolean bl = dragEnabled = !dragEnabled;
            if (lockBtnRef != null) {
                lockBtnRef.m_93666_((Component)Component.m_237113_((String)(dragEnabled ? "Drag: ON" : "Drag: OFF")));
            }
        }).m_252987_(6, 6, 80, 20).m_253136_();
        event.addListener((GuiEventListener)lockBtnRef);
        createBtnRef = Button.m_253074_((Component)Component.m_237113_((String)"Create Macro"), b -> Minecraft.m_91087_().m_91152_((Screen)new EditorScreen())).m_252987_(92, 6, 110, 20).m_253136_();
        event.addListener((GuiEventListener)createBtnRef);
    }

    @SubscribeEvent
    public void onMousePressed(ScreenEvent.MouseButtonPressed.Pre event) {
        if (!UIMacroButtonsMod.EDIT_MODE) {
            return;
        }
        Screen s = event.getScreen();
        boolean isInventory = s instanceof InventoryScreen;
        boolean isContainer = s instanceof AbstractContainerScreen;
        if (!isInventory && !isContainer) {
            return;
        }
        leftCache = (s.f_96543_ - 176) / 2;
        topCache = (s.f_96544_ - 166) / 2;
        double mx = event.getMouseX();
        double my = event.getMouseY();
        if (event.getButton() == 1) {
            for (int i = ButtonsConfig.buttons.size() - 1; i >= 0; --i) {
                ButtonsConfig.ButtonSpec spec = ButtonsConfig.buttons.get(i);
                if (spec.scope == ButtonsConfig.Scope.INVENTORY_ONLY && !isInventory) continue;
                int[] xy = EditorController.btnTopLeft(spec, leftCache, topCache);
                int x = xy[0];
                int y = xy[1];
                if (!(mx >= (double)x) || !(mx <= (double)(x + spec.width)) || !(my >= (double)y) || !(my <= (double)(y + spec.height))) continue;
                Minecraft.m_91087_().m_91152_((Screen)new EditorScreen(i));
                event.setCanceled(true);
                return;
            }
            return;
        }
        if (event.getButton() == 0 && dragEnabled) {
            for (int i = ButtonsConfig.buttons.size() - 1; i >= 0; --i) {
                ButtonsConfig.ButtonSpec spec = ButtonsConfig.buttons.get(i);
                if (spec.scope == ButtonsConfig.Scope.INVENTORY_ONLY && !isInventory) continue;
                int[] xy = EditorController.btnTopLeft(spec, leftCache, topCache);
                int x = xy[0];
                int y = xy[1];
                if (!(mx >= (double)x) || !(mx <= (double)(x + spec.width)) || !(my >= (double)y) || !(my <= (double)(y + spec.height))) continue;
                draggingIndex = i;
                grabDX = (int)Math.round(mx) - x;
                grabDY = (int)Math.round(my) - y;
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onMouseDragged(ScreenEvent.MouseDragged.Pre event) {
        if (!UIMacroButtonsMod.EDIT_MODE || !dragEnabled) {
            return;
        }
        if (draggingIndex < 0) {
            return;
        }
        double mx = event.getMouseX();
        double my = event.getMouseY();
        int desiredX = (int)Math.round(mx) - grabDX;
        int desiredY = (int)Math.round(my) - grabDY;
        int snappedX = EditorController.snapToGrid(desiredX, leftCache, 8);
        int snappedY = EditorController.snapToGrid(desiredY, topCache, 8);
        ButtonsConfig.ButtonSpec spec = ButtonsConfig.buttons.get(draggingIndex);
        switch (spec.anchor) {
            case RIGHT: {
                spec.xOffset = snappedX - (leftCache + 176);
                spec.yOffset = snappedY - topCache;
                break;
            }
            case LEFT: {
                spec.xOffset = leftCache - snappedX - spec.width;
                spec.yOffset = snappedY - topCache;
                break;
            }
            case BOTTOM: {
                int centerBase = leftCache + (176 - spec.width) / 2;
                spec.xOffset = snappedX - centerBase;
                spec.yOffset = snappedY - (topCache + 166);
            }
        }
        Button live = UIMacroButtonsMod.LIVE_BUTTONS.get(draggingIndex);
        if (live != null) {
            live.m_264152_(snappedX, snappedY);
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onMouseReleased(ScreenEvent.MouseButtonReleased.Pre event) {
        if (!UIMacroButtonsMod.EDIT_MODE || !dragEnabled) {
            return;
        }
        if (event.getButton() != 0) {
            return;
        }
        if (draggingIndex < 0) {
            return;
        }
        draggingIndex = -1;
        ButtonsConfig.save();
        event.setCanceled(true);
    }

    private static int snapToGrid(int value, int origin, int grid) {
        int rel = value - origin;
        int half = grid / 2;
        int snappedRel = (rel + (rel >= 0 ? half : -half)) / grid * grid;
        return origin + snappedRel;
    }

    private static int[] btnTopLeft(ButtonsConfig.ButtonSpec spec, int left, int top) {
        int[] nArray;
        switch (spec.anchor) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case RIGHT: {
                int[] nArray2 = new int[2];
                nArray2[0] = left + 176 + spec.xOffset;
                nArray = nArray2;
                nArray2[1] = top + spec.yOffset;
                break;
            }
            case LEFT: {
                int[] nArray3 = new int[2];
                nArray3[0] = left - spec.xOffset - spec.width;
                nArray = nArray3;
                nArray3[1] = top + spec.yOffset;
                break;
            }
            case BOTTOM: {
                int[] nArray4 = new int[2];
                nArray4[0] = left + (176 - spec.width) / 2 + spec.xOffset;
                nArray = nArray4;
                nArray4[1] = top + 166 + spec.yOffset;
            }
        }
        return nArray;
    }
}

