/*
 * Decompiled with CFR 0.152.
 */
package com.impatus.uibuttons;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;

public final class ButtonsConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type LIST_TYPE = new TypeToken<List<ButtonSpec>>(){}.getType();
    public static final Path DIR = FMLPaths.CONFIGDIR.get().resolve("uibuttons");
    public static final Path FILE = DIR.resolve("buttons.json");
    public static final Path IMG_DIR = DIR.resolve("textures");
    public static List<ButtonSpec> buttons = new ArrayList<ButtonSpec>();

    public static void load() {
        block11: {
            try {
                if (!Files.exists(DIR, new LinkOption[0])) {
                    Files.createDirectories(DIR, new FileAttribute[0]);
                }
                if (!Files.exists(IMG_DIR, new LinkOption[0])) {
                    Files.createDirectories(IMG_DIR, new FileAttribute[0]);
                }
                if (!Files.exists(FILE, new LinkOption[0])) {
                    ButtonsConfig.save();
                    return;
                }
                try (BufferedReader r = Files.newBufferedReader(FILE, StandardCharsets.UTF_8);){
                    List list = (List)GSON.fromJson((Reader)r, LIST_TYPE);
                    buttons = list != null ? list : new ArrayList();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (buttons != null) break block11;
                buttons = new ArrayList<ButtonSpec>();
            }
        }
    }

    public static void save() {
        try {
            if (!Files.exists(DIR, new LinkOption[0])) {
                Files.createDirectories(DIR, new FileAttribute[0]);
            }
            try (BufferedWriter w = Files.newBufferedWriter(FILE, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson(buttons, LIST_TYPE, (Appendable)w);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class ButtonSpec {
        public String label = "BTN";
        public String command = "/help";
        public Anchor anchor = Anchor.RIGHT;
        public int xOffset = 6;
        public int yOffset = 10;
        public int width = 20;
        public int height = 20;
        public Scope scope = Scope.INVENTORY_ONLY;
        public IconKind iconKind = IconKind.NONE;
        public String iconValue = "";
        public boolean iconOnly = true;
    }

    public static enum IconKind {
        NONE,
        ITEM,
        IMAGE;

    }

    public static enum Scope {
        INVENTORY_ONLY,
        ANY_CONTAINER;

    }

    public static enum Anchor {
        RIGHT,
        LEFT,
        BOTTOM;

    }
}

