/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util.inventory;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.common.util.CoordUtil;
import de.srendi.advancedperipherals.common.util.inventory.FluidFilter;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemFluidHandler;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemItemHandler;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryUtil {
    private InventoryUtil() {
    }

    public static IItemHandler extractHandler(@Nullable Object object) {
        ICapabilityProvider capabilityProvider;
        LazyOptional cap;
        if (object instanceof ICapabilityProvider && (cap = (capabilityProvider = (ICapabilityProvider)object).getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler itemHandler = (IItemHandler)object;
            return itemHandler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    public static int moveItem(IItemHandler inventoryFrom, IItemHandler inventoryTo, ItemFilter filter) {
        if (inventoryFrom == null) {
            return 0;
        }
        int fromSlot = filter.getFromSlot();
        int toSlot = filter.getToSlot();
        int amount = filter.getCount();
        int transferableAmount = 0;
        if (inventoryFrom instanceof IStorageSystemItemHandler) {
            IStorageSystemItemHandler storageSystemHandler = (IStorageSystemItemHandler)inventoryFrom;
            for (int i = toSlot == -1 ? 0 : toSlot; i < (toSlot == -1 ? inventoryTo.getSlots() : toSlot + 1); ++i) {
                ItemStack extracted = storageSystemHandler.extractItem(filter, filter.getCount(), true);
                if (extracted.m_41619_()) continue;
                ItemStack inserted = toSlot == -1 ? ItemHandlerHelper.insertItem((IItemHandler)inventoryTo, (ItemStack)extracted, (boolean)false) : inventoryTo.insertItem(toSlot, extracted, false);
                amount -= extracted.m_41613_() - inserted.m_41613_();
                if ((transferableAmount += storageSystemHandler.extractItem(filter, extracted.m_41613_() - inserted.m_41613_(), false).m_41613_()) >= filter.getCount()) break;
            }
            return transferableAmount;
        }
        if (inventoryTo instanceof IStorageSystemItemHandler) {
            IStorageSystemItemHandler storageSystemHandler = (IStorageSystemItemHandler)inventoryTo;
            for (int i = fromSlot == -1 ? 0 : fromSlot; i < (fromSlot == -1 ? inventoryFrom.getSlots() : fromSlot + 1); ++i) {
                ItemStack extracted;
                if (!filter.test(inventoryFrom.getStackInSlot(i)) || (extracted = inventoryFrom.extractItem(i, amount - transferableAmount, true)).m_41619_()) continue;
                ItemStack inserted = storageSystemHandler.insertItem(toSlot, extracted, false);
                amount -= inserted.m_41613_();
                if ((transferableAmount += inventoryFrom.extractItem(i, extracted.m_41613_() - inserted.m_41613_(), false).m_41613_()) >= filter.getCount()) break;
            }
            return transferableAmount;
        }
        for (int i = fromSlot == -1 ? 0 : fromSlot; i < (fromSlot == -1 ? inventoryFrom.getSlots() : fromSlot + 1); ++i) {
            ItemStack extracted;
            if (!filter.test(inventoryFrom.getStackInSlot(i)) || (extracted = inventoryFrom.extractItem(i, amount - transferableAmount, true)).m_41619_()) continue;
            ItemStack inserted = toSlot == -1 ? ItemHandlerHelper.insertItem((IItemHandler)inventoryTo, (ItemStack)extracted, (boolean)false) : inventoryTo.insertItem(toSlot, extracted, false);
            amount -= inserted.m_41613_();
            if ((transferableAmount += inventoryFrom.extractItem(i, extracted.m_41613_() - inserted.m_41613_(), false).m_41613_()) >= filter.getCount()) break;
        }
        return transferableAmount;
    }

    public static int moveFluid(IFluidHandler inventoryFrom, IFluidHandler inventoryTo, FluidFilter filter) {
        if (inventoryFrom == null) {
            return 0;
        }
        int amount = filter.getCount();
        int transferableAmount = 0;
        if (inventoryFrom instanceof IStorageSystemFluidHandler) {
            IStorageSystemFluidHandler storageSystemHandler = (IStorageSystemFluidHandler)inventoryFrom;
            FluidStack extracted = storageSystemHandler.drain(filter, IFluidHandler.FluidAction.SIMULATE);
            int inserted = inventoryTo.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
            return transferableAmount += storageSystemHandler.drain(filter.setCount(inserted), IFluidHandler.FluidAction.EXECUTE).getAmount();
        }
        if (inventoryTo instanceof IStorageSystemFluidHandler) {
            IStorageSystemFluidHandler storageSystemHandler = (IStorageSystemFluidHandler)inventoryTo;
            if (filter.test(inventoryFrom.getFluidInTank(0))) {
                FluidStack toExtract = inventoryFrom.getFluidInTank(0).copy();
                toExtract.setAmount(amount);
                FluidStack extracted = inventoryFrom.drain(toExtract, IFluidHandler.FluidAction.SIMULATE);
                if (extracted.isEmpty()) {
                    return 0;
                }
                int inserted = storageSystemHandler.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
                extracted.setAmount(inserted);
                transferableAmount += inventoryFrom.drain(extracted, IFluidHandler.FluidAction.EXECUTE).getAmount();
            }
            return transferableAmount;
        }
        return transferableAmount;
    }

    @Nullable
    public static IItemHandler getHandlerFromName(@NotNull IComputerAccess access, String name) throws LuaException {
        IPeripheral location = access.getAvailablePeripheral(name);
        if (location == null) {
            return null;
        }
        return InventoryUtil.extractHandler(location.getTarget());
    }

    @Nullable
    public static IItemHandler getHandlerFromDirection(@NotNull String direction, @NotNull IPeripheralOwner owner) throws LuaException {
        Level level = owner.getLevel();
        Objects.requireNonNull(level);
        Direction relativeDirection = CoordUtil.getDirection(owner.getOrientation(), direction);
        BlockEntity target = level.m_7702_(owner.getPos().m_121945_(relativeDirection));
        if (target == null) {
            return null;
        }
        return InventoryUtil.extractHandler(target);
    }
}

