/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.create;

import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import dan200.computercraft.api.lua.LuaFunction;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.lib.peripherals.APGenericPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BasinIntegration
implements APGenericPeripheral {
    @Override
    @NotNull
    public String getPeripheralType() {
        return "basin";
    }

    @LuaFunction(mainThread=true)
    public final List<Object> getInputFluids(BasinBlockEntity blockEntity) {
        IFluidHandler handler = (IFluidHandler)((SmartFluidTankBehaviour)blockEntity.getTanks().getFirst()).getCapability().orElse(null);
        if (handler == null) {
            return null;
        }
        int size = handler.getTanks();
        ArrayList<Object> tanks = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            FluidStack fluid = handler.getFluidInTank(i);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("amount", fluid.getAmount());
            data.put("fluid", ForgeRegistries.FLUIDS.getKey((Object)fluid.getFluid()).toString());
            tanks.add(data);
        }
        return tanks;
    }

    @LuaFunction(mainThread=true)
    public final List<Object> getOutputFluids(BasinBlockEntity blockEntity) {
        IFluidHandler handler = (IFluidHandler)((SmartFluidTankBehaviour)blockEntity.getTanks().getSecond()).getCapability().orElse(null);
        if (handler == null) {
            return null;
        }
        int size = handler.getTanks();
        ArrayList<Object> tanks = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            FluidStack fluid = handler.getFluidInTank(i);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("amount", fluid.getAmount());
            data.put("fluid", ForgeRegistries.FLUIDS.getKey((Object)fluid.getFluid()).toString());
            tanks.add(data);
        }
        return tanks;
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getFilter(BasinBlockEntity blockEntity) {
        return LuaConverter.stackToObject(blockEntity.getFilter().getFilter());
    }

    @LuaFunction(mainThread=true)
    public final List<Object> getInventory(BasinBlockEntity blockEntity) {
        Optional handlerOptional = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
        if (handlerOptional.isEmpty()) {
            return null;
        }
        IItemHandler handler = (IItemHandler)handlerOptional.get();
        ArrayList<Object> items = new ArrayList<Object>();
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            if (handler.getStackInSlot(slot).m_41619_()) continue;
            items.add(LuaConverter.stackToObject(handler.getStackInSlot(slot)));
        }
        return items;
    }
}

