/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import com.google.gson.JsonSyntaxException;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SimpleFreeOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.IPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.PocketPeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.blocks.base.PeripheralBlockEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.events.Events;
import de.srendi.advancedperipherals.common.util.CoordUtil;
import de.srendi.advancedperipherals.common.util.StringUtil;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralFunction;
import de.srendi.advancedperipherals.network.APNetworking;
import de.srendi.advancedperipherals.network.toclient.ToastToClientPacket;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class ChatBoxPeripheral
extends BasePeripheral<IPeripheralOwner> {
    public static final String PERIPHERAL_TYPE = "chatBox";
    private long lastConsumedMessage;

    protected ChatBoxPeripheral(IPeripheralOwner owner) {
        super(PERIPHERAL_TYPE, owner);
        owner.attachOperation(SimpleFreeOperation.CHAT_MESSAGE);
        this.lastConsumedMessage = Events.getLastChatMessageID() - 1L;
    }

    public ChatBoxPeripheral(PeripheralBlockEntity<?> tileEntity) {
        this(new BlockEntityPeripheralOwner(tileEntity));
    }

    public ChatBoxPeripheral(ITurtleAccess turtle, TurtleSide side) {
        this(new TurtlePeripheralOwner(turtle, side));
    }

    public ChatBoxPeripheral(IPocketAccess pocket) {
        this(new PocketPeripheralOwner(pocket));
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enableChatBox.get();
    }

    protected MethodResult withChatOperation(IPeripheralFunction<Object, MethodResult> function) throws LuaException {
        return this.withOperation(SimpleFreeOperation.CHAT_MESSAGE, null, null, function, null);
    }

    private MutableComponent appendPrefix(String prefix, String brackets, String color) {
        MutableComponent prefixComponent = Component.m_237113_((String)((String)APConfig.PERIPHERALS_CONFIG.defaultChatBoxPrefix.get()));
        if (!prefix.isEmpty()) {
            try {
                MutableComponent formattablePrefix;
                prefixComponent = formattablePrefix = Component.Serializer.m_130701_((String)prefix);
            }
            catch (JsonSyntaxException exception) {
                AdvancedPeripherals.debug("Non json prefix, using plain text instead.");
                prefixComponent = Component.m_237113_((String)prefix);
            }
        }
        if (brackets.isEmpty()) {
            brackets = "[]";
        }
        return Component.m_237113_((String)(color + brackets.charAt(0) + "\u00a7r")).m_7220_((Component)prefixComponent).m_130946_(color + brackets.charAt(1) + "\u00a7r ");
    }

    private ServerPlayer getPlayer(String argument) {
        if (argument.matches("\\b[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}\\b")) {
            return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(UUID.fromString(argument));
        }
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(argument);
    }

    private boolean checkBrackets(Optional<String> brackets) {
        return brackets.isPresent() && brackets.get().length() != 2;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendFormattedMessage(@NotNull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            String message = arguments.getString(0);
            int maxRange = (Integer)APConfig.PERIPHERALS_CONFIG.chatBoxMaxRange.get();
            int range = arguments.optInt(4, -1);
            ResourceKey dimension = this.getLevel().m_46472_();
            MutableComponent component = Component.Serializer.m_130701_((String)message);
            if (component == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect json"});
            }
            if (this.checkBrackets(arguments.optString(2))) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ...)"});
            }
            MutableComponent preparedMessage = this.appendPrefix(StringUtil.convertAndToSectionMark(arguments.optString(1, (String)APConfig.PERIPHERALS_CONFIG.defaultChatBoxPrefix.get())), arguments.optString(2, "[]"), StringUtil.convertAndToSectionMark(arguments.optString(3, ""))).m_7220_((Component)component);
            for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                if (!((Boolean)APConfig.PERIPHERALS_CONFIG.chatBoxMultiDimensional.get()).booleanValue() && player.m_9236_().m_46472_() != dimension || !CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, range, maxRange)) continue;
                player.m_213846_((Component)preparedMessage);
            }
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendMessage(@NotNull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            String message = arguments.getString(0);
            int maxRange = (Integer)APConfig.PERIPHERALS_CONFIG.chatBoxMaxRange.get();
            int range = arguments.optInt(4, -1);
            ResourceKey dimension = this.getLevel().m_46472_();
            if (this.checkBrackets(arguments.optString(2))) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ...)"});
            }
            MutableComponent preparedMessage = this.appendPrefix(StringUtil.convertAndToSectionMark(arguments.optString(1, (String)APConfig.PERIPHERALS_CONFIG.defaultChatBoxPrefix.get())), arguments.optString(2, "[]"), StringUtil.convertAndToSectionMark(arguments.optString(3, ""))).m_130946_(message);
            for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                if (!((Boolean)APConfig.PERIPHERALS_CONFIG.chatBoxMultiDimensional.get()).booleanValue() && player.m_9236_().m_46472_() != dimension || !CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, range, maxRange)) continue;
                player.m_213846_((Component)preparedMessage);
            }
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendFormattedMessageToPlayer(@NotNull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            String message = arguments.getString(0);
            String playerName = arguments.getString(1);
            int maxRange = (Integer)APConfig.PERIPHERALS_CONFIG.chatBoxMaxRange.get();
            int range = arguments.optInt(5, -1);
            ResourceKey dimension = this.getLevel().m_46472_();
            ServerPlayer player = this.getPlayer(playerName);
            if (player == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect player name/uuid"});
            }
            MutableComponent component = Component.Serializer.m_130701_((String)message);
            if (component == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect json"});
            }
            if (this.checkBrackets(arguments.optString(3))) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ...)"});
            }
            MutableComponent preparedMessage = this.appendPrefix(StringUtil.convertAndToSectionMark(arguments.optString(2, (String)APConfig.PERIPHERALS_CONFIG.defaultChatBoxPrefix.get())), arguments.optString(3, "[]"), StringUtil.convertAndToSectionMark(arguments.optString(4, ""))).m_7220_((Component)component);
            if (!((Boolean)APConfig.PERIPHERALS_CONFIG.chatBoxMultiDimensional.get()).booleanValue() && player.m_9236_().m_46472_() != dimension) {
                return MethodResult.of((Object[])new Object[]{false, "NOT_SAME_DIMENSION"});
            }
            if (CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, range, maxRange)) {
                player.m_213846_((Component)preparedMessage);
            }
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendFormattedToastToPlayer(@NotNull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            String message = arguments.getString(0);
            String title = arguments.getString(1);
            String playerName = arguments.getString(2);
            int maxRange = (Integer)APConfig.PERIPHERALS_CONFIG.chatBoxMaxRange.get();
            int range = arguments.optInt(6, -1);
            ResourceKey dimension = this.getLevel().m_46472_();
            ServerPlayer player = this.getPlayer(playerName);
            if (player == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect player name/uuid"});
            }
            MutableComponent messageComponent = Component.Serializer.m_130701_((String)message);
            if (messageComponent == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect json for message"});
            }
            MutableComponent titleComponent = Component.Serializer.m_130701_((String)title);
            if (titleComponent == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect json for title"});
            }
            if (this.checkBrackets(arguments.optString(4))) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ,,,)"});
            }
            MutableComponent preparedMessage = this.appendPrefix(StringUtil.convertAndToSectionMark(arguments.optString(3, (String)APConfig.PERIPHERALS_CONFIG.defaultChatBoxPrefix.get())), arguments.optString(4, "[]"), StringUtil.convertAndToSectionMark(arguments.optString(5, ""))).m_7220_((Component)messageComponent);
            if (!((Boolean)APConfig.PERIPHERALS_CONFIG.chatBoxMultiDimensional.get()).booleanValue() && player.m_9236_().m_46472_() != dimension) {
                return MethodResult.of((Object[])new Object[]{false, "NOT_SAME_DIMENSION"});
            }
            if (CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, range, maxRange)) {
                ToastToClientPacket packet = new ToastToClientPacket((Component)titleComponent, (Component)preparedMessage);
                APNetworking.sendTo(packet, player);
            }
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendMessageToPlayer(@NotNull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            String message = arguments.getString(0);
            String playerName = arguments.getString(1);
            int maxRange = (Integer)APConfig.PERIPHERALS_CONFIG.chatBoxMaxRange.get();
            int range = arguments.optInt(5, -1);
            ResourceKey dimension = this.getLevel().m_46472_();
            ServerPlayer player = this.getPlayer(playerName);
            if (player == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect player name/uuid"});
            }
            if (this.checkBrackets(arguments.optString(3))) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ...)"});
            }
            MutableComponent preparedMessage = this.appendPrefix(StringUtil.convertAndToSectionMark(arguments.optString(2, (String)APConfig.PERIPHERALS_CONFIG.defaultChatBoxPrefix.get())), arguments.optString(3, "[]"), StringUtil.convertAndToSectionMark(arguments.optString(4, ""))).m_130946_(message);
            if (!((Boolean)APConfig.PERIPHERALS_CONFIG.chatBoxMultiDimensional.get()).booleanValue() && player.m_9236_().m_46472_() != dimension) {
                return MethodResult.of((Object[])new Object[]{false, "NOT_SAME_DIMENSION"});
            }
            if (CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, range, maxRange)) {
                player.m_240418_((Component)preparedMessage, false);
            }
            return MethodResult.of((Object)true);
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult sendToastToPlayer(@NotNull IArguments arguments) throws LuaException {
        return this.withChatOperation(ignored -> {
            String message = arguments.getString(0);
            String title = arguments.getString(1);
            String playerName = arguments.getString(2);
            int maxRange = (Integer)APConfig.PERIPHERALS_CONFIG.chatBoxMaxRange.get();
            int range = arguments.optInt(6, -1);
            ResourceKey dimension = this.getLevel().m_46472_();
            ServerPlayer player = this.getPlayer(playerName);
            if (player == null) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect player name/uuid"});
            }
            if (this.checkBrackets(arguments.optString(4))) {
                return MethodResult.of((Object[])new Object[]{null, "incorrect bracket string (e.g. [], {}, <>, ...)"});
            }
            MutableComponent preparedMessage = this.appendPrefix(StringUtil.convertAndToSectionMark(arguments.optString(3, (String)APConfig.PERIPHERALS_CONFIG.defaultChatBoxPrefix.get())), arguments.optString(4, "[]"), StringUtil.convertAndToSectionMark(arguments.optString(5, ""))).m_130946_(message);
            if (!((Boolean)APConfig.PERIPHERALS_CONFIG.chatBoxMultiDimensional.get()).booleanValue() && player.m_9236_().m_46472_() != dimension) {
                return MethodResult.of((Object[])new Object[]{false, "NOT_SAME_DIMENSION"});
            }
            if (CoordUtil.isInRange(this.getPos(), this.getLevel(), (Player)player, range, maxRange)) {
                ToastToClientPacket packet = new ToastToClientPacket((Component)Component.m_237113_((String)title), (Component)preparedMessage);
                APNetworking.sendTo(packet, player);
            }
            return MethodResult.of((Object)true);
        });
    }

    public void update() {
        this.lastConsumedMessage = Events.traverseChatMessages(this.lastConsumedMessage, message -> {
            for (IComputerAccess computer : this.getConnectedComputers()) {
                computer.queueEvent("chat", new Object[]{message.username(), message.message(), message.uuid(), message.isHidden()});
            }
        });
    }
}

