/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.item.storage;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.AEKeyFilter;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.items.contents.CellConfig;
import appeng.util.ConfigInventory;
import com.the9grounds.aeadditions.api.IAEAdditionsStorageCell;
import com.the9grounds.aeadditions.me.storage.AEAdditionsCellHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BE\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J6\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0$2\b\u0010&\u001a\u0004\u0018\u00010'H\u0017J\"\u0010(\u001a\u00020)2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020 H\u0016J\u0010\u0010.\u001a\u00020\f2\u0006\u0010-\u001a\u00020 H\u0016J\u0012\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010 H\u0016J\u0012\u00102\u001a\u0002032\b\u00101\u001a\u0004\u0018\u00010 H\u0016J\b\u00104\u001a\u00020\nH\u0016J\b\u00105\u001a\u00020\u0010H\u0016J\u0010\u00106\u001a\u00020\f2\u0006\u0010-\u001a\u00020 H\u0016J\u0012\u00107\u001a\u0002082\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0012\u00109\u001a\u00020)2\b\u00101\u001a\u0004\u0018\u00010 H\u0016J\u001c\u0010:\u001a\u00020;2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010<\u001a\u0004\u0018\u00010=H\u0016J\u001c\u0010>\u001a\u00020\u001e2\b\u00101\u001a\u0004\u0018\u00010 2\b\u0010?\u001a\u0004\u0018\u000103H\u0016J&\u0010@\u001a\b\u0012\u0004\u0012\u00020 0A2\u0006\u0010!\u001a\u00020\"2\u0006\u0010*\u001a\u00020+2\u0006\u0010B\u001a\u00020CH\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\u000e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013\u00a8\u0006D"}, d2={"Lcom/the9grounds/aeadditions/item/storage/StorageCell;", "Lnet/minecraft/world/item/Item;", "Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;", "Lappeng/api/storage/cells/ICellWorkbenchItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "component", "Lnet/minecraft/world/level/ItemLike;", "housingItem", "_idleDrain", "", "_bytesPerType", "", "kiloBytes", "numberOfTypes", "_keyType", "Lappeng/api/stacks/AEKeyType;", "(Lnet/minecraft/world/item/Item$Properties;Lnet/minecraft/world/level/ItemLike;Lnet/minecraft/world/level/ItemLike;DIIILappeng/api/stacks/AEKeyType;)V", "get_bytesPerType", "()I", "get_idleDrain", "()D", "get_keyType", "()Lappeng/api/stacks/AEKeyType;", "getComponent", "()Lnet/minecraft/world/level/ItemLike;", "getHousingItem", "getKiloBytes", "getNumberOfTypes", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "lines", "", "Lnet/minecraft/network/chat/Component;", "advancedTooltips", "Lnet/minecraft/world/item/TooltipFlag;", "disassembleDrive", "", "player", "Lnet/minecraft/world/entity/player/Player;", "getBytes", "cellItem", "getBytesPerType", "getConfigInventory", "Lappeng/util/ConfigInventory;", "is", "getFuzzyMode", "Lappeng/api/config/FuzzyMode;", "getIdleDrain", "getKeyType", "getTotalTypes", "getUpgrades", "Lappeng/api/upgrades/IUpgradeInventory;", "isEditable", "onItemUseFirst", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "setFuzzyMode", "fzMode", "use", "Lnet/minecraft/world/InteractionResultHolder;", "hand", "Lnet/minecraft/world/InteractionHand;", "AEAdditions-1.20.1"})
@SourceDebugExtension(value={"SMAP\nStorageCell.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageCell.kt\ncom/the9grounds/aeadditions/item/storage/StorageCell\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1855#2,2:111\n*S KotlinDebug\n*F\n+ 1 StorageCell.kt\ncom/the9grounds/aeadditions/item/storage/StorageCell\n*L\n81#1:111,2\n*E\n"})
public final class StorageCell
extends Item
implements IAEAdditionsStorageCell,
ICellWorkbenchItem {
    @NotNull
    private final ItemLike component;
    @NotNull
    private final ItemLike housingItem;
    private final double _idleDrain;
    private final int _bytesPerType;
    private final int kiloBytes;
    private final int numberOfTypes;
    @NotNull
    private final AEKeyType _keyType;

    public StorageCell(@NotNull Item.Properties properties, @NotNull ItemLike component, @NotNull ItemLike housingItem, double _idleDrain, int _bytesPerType, int kiloBytes, int numberOfTypes, @NotNull AEKeyType _keyType) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)housingItem, (String)"housingItem");
        Intrinsics.checkNotNullParameter((Object)_keyType, (String)"_keyType");
        super(properties);
        this.component = component;
        this.housingItem = housingItem;
        this._idleDrain = _idleDrain;
        this._bytesPerType = _bytesPerType;
        this.kiloBytes = kiloBytes;
        this.numberOfTypes = numberOfTypes;
        this._keyType = _keyType;
    }

    @NotNull
    public final ItemLike getComponent() {
        return this.component;
    }

    @NotNull
    public final ItemLike getHousingItem() {
        return this.housingItem;
    }

    public final double get_idleDrain() {
        return this._idleDrain;
    }

    public final int get_bytesPerType() {
        return this._bytesPerType;
    }

    public final int getKiloBytes() {
        return this.kiloBytes;
    }

    public final int getNumberOfTypes() {
        return this.numberOfTypes;
    }

    @NotNull
    public final AEKeyType get_keyType() {
        return this._keyType;
    }

    @Override
    public int getBytes(@NotNull ItemStack cellItem) {
        Intrinsics.checkNotNullParameter((Object)cellItem, (String)"cellItem");
        return this.kiloBytes * 1024;
    }

    @Override
    public int getBytesPerType(@NotNull ItemStack cellItem) {
        Intrinsics.checkNotNullParameter((Object)cellItem, (String)"cellItem");
        return this._bytesPerType;
    }

    @Override
    public int getTotalTypes(@NotNull ItemStack cellItem) {
        Intrinsics.checkNotNullParameter((Object)cellItem, (String)"cellItem");
        return this.numberOfTypes;
    }

    @Override
    public double getIdleDrain() {
        return this._idleDrain;
    }

    public boolean isEditable(@Nullable ItemStack is) {
        return true;
    }

    @Override
    @NotNull
    public AEKeyType getKeyType() {
        return this._keyType;
    }

    @NotNull
    public ConfigInventory getConfigInventory(@Nullable ItemStack is) {
        ConfigInventory configInventory = CellConfig.create((AEKeyFilter)this._keyType.filter(), (ItemStack)is);
        Intrinsics.checkNotNullExpressionValue((Object)configInventory, (String)"create(_keyType.filter(), `is`)");
        return configInventory;
    }

    @NotNull
    public IUpgradeInventory getUpgrades(@Nullable ItemStack stack) {
        IUpgradeInventory iUpgradeInventory = UpgradeInventories.forItem((ItemStack)stack, (int)4);
        Intrinsics.checkNotNullExpressionValue((Object)iUpgradeInventory, (String)"forItem(stack, 4)");
        return iUpgradeInventory;
    }

    @NotNull
    public FuzzyMode getFuzzyMode(@Nullable ItemStack is) {
        FuzzyMode fuzzyMode;
        ItemStack itemStack = is;
        Intrinsics.checkNotNull((Object)itemStack);
        String fz = itemStack.m_41784_().m_128461_("FuzzyMode");
        Intrinsics.checkNotNullExpressionValue((Object)fz, (String)"fz");
        if (((CharSequence)fz).length() == 0) {
            fuzzyMode = FuzzyMode.IGNORE_ALL;
        } else {
            FuzzyMode fuzzyMode2;
            try {
                fuzzyMode2 = FuzzyMode.valueOf((String)fz);
            }
            catch (Throwable t) {
                fuzzyMode2 = FuzzyMode.IGNORE_ALL;
            }
            fuzzyMode = fuzzyMode2;
        }
        return fuzzyMode;
    }

    public void setFuzzyMode(@Nullable ItemStack is, @Nullable FuzzyMode fzMode) {
        ItemStack itemStack = is;
        Intrinsics.checkNotNull((Object)itemStack);
        CompoundTag compoundTag = itemStack.m_41784_();
        FuzzyMode fuzzyMode = fzMode;
        Intrinsics.checkNotNull((Object)fuzzyMode);
        compoundTag.m_128359_("FuzzyMode", fuzzyMode.name());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        this.disassembleDrive(player.m_21120_(hand), level, player);
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)level.f_46443_), (Object)player.m_21120_(hand));
    }

    private final boolean disassembleDrive(ItemStack stack, Level level, Player player) {
        if (player.m_6047_()) {
            KeyCounter list;
            if (level.f_46443_) {
                return false;
            }
            Inventory inventory = player.m_150109_();
            appeng.api.storage.cells.StorageCell inv = StorageCells.getCellInventory((ItemStack)stack, null);
            if (inv != null && Intrinsics.areEqual((Object)inventory.m_36056_(), (Object)stack) && (list = inv.getAvailableStacks()).isEmpty()) {
                inventory.m_6836_(inventory.f_35977_, ItemStack.f_41583_);
                inventory.m_150079_(new ItemStack(this.component));
                Iterable $this$forEach$iv = (Iterable)this.getUpgrades(stack);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl = false;
                    inventory.m_150079_(it);
                }
                inventory.m_150079_(new ItemStack(this.housingItem));
                return true;
            }
        }
        return false;
    }

    @NotNull
    public InteractionResult onItemUseFirst(@Nullable ItemStack stack, @Nullable UseOnContext context) {
        InteractionResult interactionResult;
        UseOnContext useOnContext = context;
        Intrinsics.checkNotNull((Object)useOnContext);
        Level level = useOnContext.m_43725_();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"context!!.level");
        Player player = context.m_43723_();
        Intrinsics.checkNotNull((Object)player);
        if (this.disassembleDrive(stack, level, player)) {
            InteractionResult interactionResult2 = InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
            interactionResult = interactionResult2;
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult2, (String)"{\n            Interactio\u2026l.isClientSide)\n        }");
        } else {
            interactionResult = InteractionResult.PASS;
        }
        return interactionResult;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nullable ItemStack stack, @Nullable Level level, @NotNull List<Component> lines, @Nullable TooltipFlag advancedTooltips) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        AEAdditionsCellHandler.INSTANCE.addCellInformationToTooltip(stack, lines);
    }

    @Override
    public boolean isBlackListed(@Nullable ItemStack cellItem, @Nullable AEKey requestedAddition) {
        return IAEAdditionsStorageCell.DefaultImpls.isBlackListed(this, cellItem, requestedAddition);
    }

    @Override
    public boolean storableInStorageCell() {
        return IAEAdditionsStorageCell.DefaultImpls.storableInStorageCell(this);
    }

    @Override
    public boolean isStorageCell(@Nullable ItemStack i) {
        return IAEAdditionsStorageCell.DefaultImpls.isStorageCell(this, i);
    }
}

