/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import net.minecraftforge.eventbus.api.EventListenerHelper;
import net.minecraftforge.eventbus.api.IGenericEvent;

public final class InternalUtils {
    private static final MethodHandle GET_PERMITTED_SUBCLASSES;

    private InternalUtils() {
    }

    public static Class<?>[] getPermittedSubclasses(Class<?> clazz) {
        try {
            return GET_PERMITTED_SUBCLASSES.invokeExact(clazz);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean couldBeCancelled(Class<?> eventType) {
        return InternalUtils.couldBeCancelled(eventType, IGenericEvent.class.isAssignableFrom(eventType));
    }

    public static boolean couldBeCancelled(Class<?> eventType, boolean isGenericEvent) {
        if (isGenericEvent || EventListenerHelper.isCancelable(eventType)) {
            return true;
        }
        if (Modifier.isFinal(eventType.getModifiers())) {
            return false;
        }
        Class<?>[] permittedSubclasses = InternalUtils.getPermittedSubclasses(eventType);
        if (permittedSubclasses == null || permittedSubclasses.length == 0) {
            return true;
        }
        for (Class<?> subclass : permittedSubclasses) {
            if (!InternalUtils.couldBeCancelled(subclass)) continue;
            return true;
        }
        return false;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType methodType = MethodType.methodType(Class[].class);
        if (Runtime.version().feature() >= 17) {
            try {
                GET_PERMITTED_SUBCLASSES = lookup.findVirtual(Class.class, "getPermittedSubclasses", methodType).asType(methodType.insertParameterTypes(0, Class.class));
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError("Failed to find Class#getPermittedSubclasses(Class): " + e);
            }
        } else {
            GET_PERMITTED_SUBCLASSES = MethodHandles.empty(methodType.insertParameterTypes(0, Class.class));
        }
    }
}

