/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.internal;

import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraftforge.eventbus.internal.Cache;

final class CacheCopyOnWrite<K, V>
implements Cache<K, V> {
    private final Object lock = new Object();
    private final IntFunction<Map<K, V>> factory;
    private final Map<K, V> map;
    private volatile Map<K, V> readable;

    CacheCopyOnWrite(IntFunction<Map<K, V>> factory) {
        this.factory = factory;
        this.map = factory.apply(32);
        this.readable = this.map;
    }

    @Override
    public V get(K key) {
        return this.readable.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <I> V computeIfAbsent(K key, Function<K, I> factory, Function<I, V> finalizer) {
        V ret = this.get(key);
        if (ret != null) {
            return ret;
        }
        I intermediate = factory.apply(key);
        Object object = this.lock;
        synchronized (object) {
            ret = this.map.get(key);
            if (ret == null) {
                ret = finalizer.apply(intermediate);
                this.map.put(key, ret);
                Map<K, V> newMap = this.factory.apply(this.map.size());
                newMap.putAll(this.map);
                this.readable = newMap;
            }
            return ret;
        }
    }
}

