/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.internal;

import java.util.HashMap;
import java.util.function.Function;
import net.minecraftforge.eventbus.internal.CacheConcurrent;
import net.minecraftforge.eventbus.internal.CacheCopyOnWrite;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public interface Cache<K, V> {
    public V get(K var1);

    default public V computeIfAbsent(K key, Function<K, V> factory) {
        return (V)this.computeIfAbsent(key, factory, Function.identity());
    }

    public <I> V computeIfAbsent(K var1, Function<K, I> var2, Function<I, V> var3);

    public static <K, V> Cache<K, V> create() {
        String type = System.getProperty("eb.cache_type");
        if (type == null || "concurrent".equals(type)) {
            return new CacheConcurrent();
        }
        if ("copy".equals(type)) {
            return new CacheCopyOnWrite(HashMap::new);
        }
        throw new IllegalArgumentException("Unknown `eb.cache_type` " + type);
    }
}

