/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.api;

import java.util.EnumSet;
import net.minecraftforge.eventbus.BusBuilderImpl;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.IEventExceptionHandler;

public interface BusBuilder {
    public static BusBuilder builder() {
        return new BusBuilderImpl();
    }

    public BusBuilder setTrackPhases(boolean var1);

    default public BusBuilder setPhasesToTrack(EnumSet<EventPriority> phases) {
        throw new UnsupportedOperationException();
    }

    default public BusBuilder setPhasesToTrack(EventPriority ... phases) {
        return this.setPhasesToTrack(EnumSet.of(phases[0], phases));
    }

    default public BusBuilder setPhasesToTrack(EventPriority phase) {
        return this.setPhasesToTrack(EnumSet.of(phase));
    }

    public BusBuilder setExceptionHandler(IEventExceptionHandler var1);

    public BusBuilder startShutdown();

    public BusBuilder checkTypesOnDispatch();

    public BusBuilder markerType(Class<?> var1);

    public BusBuilder useModLauncher();

    public IEventBus build();
}

