/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.mojang.authlib.Environment;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.launcher.Authlib1Utils;
import com.mojang.authlib.launcher.GenericGameProfile;
import com.mojang.authlib.launcher.LauncherUtils;
import com.mojang.authlib.minecraft.HttpMinecraftSessionService;
import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionException;

public class YggdrasilMinecraftSessionService
extends HttpMinecraftSessionService {
    public YggdrasilMinecraftSessionService(YggdrasilAuthenticationService authenticationService, Environment environment) {
        super(authenticationService);
    }

    @Override
    public void joinServer(GameProfile gameProfile, String username, String serverId) throws AuthenticationException {
        try {
            Boolean ok = LauncherUtils.joinServerAsync(gameProfile.getName(), username, serverId).get();
            if (!ok.booleanValue()) {
                throw new RuntimeException("You can't join to this server");
            }
        }
        catch (Throwable e) {
            Throwable exc = e;
            if (exc instanceof CompletionException) {
                CompletionException ce = (CompletionException)exc;
                exc = ce.getCause();
            }
            throw new AuthenticationException(exc.getMessage(), exc);
        }
    }

    public GameProfile hasJoinedServer(GameProfile gameProfile, String serverId) throws AuthenticationUnavailableException {
        try {
            GenericGameProfile profile = LauncherUtils.checkServerAsync(gameProfile.getName(), serverId, null).get();
            return Authlib1Utils.createGameProfile(profile);
        }
        catch (Throwable e) {
            Throwable exc = e;
            if (exc instanceof CompletionException) {
                CompletionException ce = (CompletionException)exc;
                exc = ce.getCause();
            }
            throw new AuthenticationUnavailableException(exc.getMessage(), exc);
        }
    }

    public GameProfile hasJoinedServer(GameProfile gameProfile, String serverId, String ip) throws AuthenticationUnavailableException {
        try {
            GenericGameProfile profile = LauncherUtils.checkServerAsync(gameProfile.getName(), serverId, ip).get();
            return Authlib1Utils.createGameProfile(profile);
        }
        catch (Throwable e) {
            Throwable exc = e;
            if (exc instanceof CompletionException) {
                CompletionException ce = (CompletionException)exc;
                exc = ce.getCause();
            }
            throw new AuthenticationUnavailableException(exc.getMessage(), exc);
        }
    }

    @Override
    public GameProfile hasJoinedServer(GameProfile gameProfile, String serverId, InetAddress inetAddress) throws AuthenticationUnavailableException {
        try {
            GenericGameProfile profile = LauncherUtils.checkServerAsync(gameProfile.getName(), serverId, inetAddress == null ? null : inetAddress.toString()).get();
            return Authlib1Utils.createGameProfile(profile);
        }
        catch (Throwable e) {
            Throwable exc = e;
            if (exc instanceof CompletionException) {
                CompletionException ce = (CompletionException)exc;
                exc = ce.getCause();
            }
            throw new AuthenticationUnavailableException(exc.getMessage(), exc);
        }
    }

    @Override
    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getTextures(GameProfile gameProfile, boolean secure) {
        if (gameProfile == null) {
            LauncherUtils.debug("Authlib: getTextures GameProfile is null", new Object[0]);
            return null;
        }
        Property texturesProperty = gameProfile.getProperties().get("textures").stream().findFirst().orElse(null);
        if (texturesProperty == null) {
            LauncherUtils.debug("Authlib: getTextures property not found", new Object[0]);
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> map = Authlib1Utils.parseTextureProperty(texturesProperty);
        LauncherUtils.debug("Authlib: getTextures %s", map);
        return map;
    }

    @Override
    public GameProfile fillProfileProperties(GameProfile gameProfile, boolean secure) {
        try {
            GenericGameProfile genericGameProfile;
            if (gameProfile.getId() != null) {
                genericGameProfile = LauncherUtils.findByUUID(gameProfile.getId()).get();
            } else if (gameProfile.getName() != null) {
                genericGameProfile = LauncherUtils.findByUsername(gameProfile.getName()).get();
            } else {
                return gameProfile;
            }
            return Authlib1Utils.createGameProfile(genericGameProfile, gameProfile);
        }
        catch (Exception e) {
            Throwable exc = e;
            if (exc instanceof CompletionException) {
                CompletionException c = (CompletionException)exc;
                exc = c.getCause();
            }
            LauncherUtils.error(exc);
            return gameProfile;
        }
    }

    @Override
    public String getSecurePropertyValue(Property property) throws InsecurePublicKeyException {
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    @Override
    public YggdrasilAuthenticationService getAuthenticationService() {
        return (YggdrasilAuthenticationService)super.getAuthenticationService();
    }
}

