/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.freetype;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class TT_HoriHeader
extends Struct<TT_HoriHeader> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERSION;
    public static final int ASCENDER;
    public static final int DESCENDER;
    public static final int LINE_GAP;
    public static final int ADVANCE_WIDTH_MAX;
    public static final int MIN_LEFT_SIDE_BEARING;
    public static final int MIN_RIGHT_SIDE_BEARING;
    public static final int XMAX_EXTENT;
    public static final int CARET_SLOPE_RISE;
    public static final int CARET_SLOPE_RUN;
    public static final int CARET_OFFSET;
    public static final int RESERVED;
    public static final int METRIC_DATA_FORMAT;
    public static final int NUMBER_OF_HMETRICS;
    public static final int LONG_METRICS;
    public static final int SHORT_METRICS;

    protected TT_HoriHeader(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected TT_HoriHeader create(long address, @Nullable ByteBuffer container) {
        return new TT_HoriHeader(address, container);
    }

    public TT_HoriHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), TT_HoriHeader.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="FT_Fixed")
    public long Version() {
        return TT_HoriHeader.nVersion(this.address());
    }

    @NativeType(value="FT_Short")
    public short Ascender() {
        return TT_HoriHeader.nAscender(this.address());
    }

    @NativeType(value="FT_Short")
    public short Descender() {
        return TT_HoriHeader.nDescender(this.address());
    }

    @NativeType(value="FT_Short")
    public short Line_Gap() {
        return TT_HoriHeader.nLine_Gap(this.address());
    }

    @NativeType(value="FT_UShort")
    public short advance_Width_Max() {
        return TT_HoriHeader.nadvance_Width_Max(this.address());
    }

    @NativeType(value="FT_Short")
    public short min_Left_Side_Bearing() {
        return TT_HoriHeader.nmin_Left_Side_Bearing(this.address());
    }

    @NativeType(value="FT_Short")
    public short min_Right_Side_Bearing() {
        return TT_HoriHeader.nmin_Right_Side_Bearing(this.address());
    }

    @NativeType(value="FT_Short")
    public short xMax_Extent() {
        return TT_HoriHeader.nxMax_Extent(this.address());
    }

    @NativeType(value="FT_Short")
    public short caret_Slope_Rise() {
        return TT_HoriHeader.ncaret_Slope_Rise(this.address());
    }

    @NativeType(value="FT_Short")
    public short caret_Slope_Run() {
        return TT_HoriHeader.ncaret_Slope_Run(this.address());
    }

    @NativeType(value="FT_Short")
    public short caret_Offset() {
        return TT_HoriHeader.ncaret_Offset(this.address());
    }

    @NativeType(value="FT_Short[4]")
    public ShortBuffer Reserved() {
        return TT_HoriHeader.nReserved(this.address());
    }

    @NativeType(value="FT_Short")
    public short Reserved(int index) {
        return TT_HoriHeader.nReserved(this.address(), index);
    }

    @NativeType(value="FT_Short")
    public short metric_Data_Format() {
        return TT_HoriHeader.nmetric_Data_Format(this.address());
    }

    @NativeType(value="FT_UShort")
    public short number_Of_HMetrics() {
        return TT_HoriHeader.nnumber_Of_HMetrics(this.address());
    }

    @NativeType(value="void *")
    public @Nullable ByteBuffer long_metrics(int capacity) {
        return TT_HoriHeader.nlong_metrics(this.address(), capacity);
    }

    @NativeType(value="void *")
    public @Nullable ByteBuffer short_metrics(int capacity) {
        return TT_HoriHeader.nshort_metrics(this.address(), capacity);
    }

    public static TT_HoriHeader create(long address) {
        return new TT_HoriHeader(address, null);
    }

    public static @Nullable TT_HoriHeader createSafe(long address) {
        return address == 0L ? null : new TT_HoriHeader(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static long nVersion(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)VERSION));
    }

    public static short nAscender(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)ASCENDER));
    }

    public static short nDescender(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)DESCENDER));
    }

    public static short nLine_Gap(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)LINE_GAP));
    }

    public static short nadvance_Width_Max(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)ADVANCE_WIDTH_MAX));
    }

    public static short nmin_Left_Side_Bearing(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)MIN_LEFT_SIDE_BEARING));
    }

    public static short nmin_Right_Side_Bearing(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)MIN_RIGHT_SIDE_BEARING));
    }

    public static short nxMax_Extent(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)XMAX_EXTENT));
    }

    public static short ncaret_Slope_Rise(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)CARET_SLOPE_RISE));
    }

    public static short ncaret_Slope_Run(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)CARET_SLOPE_RUN));
    }

    public static short ncaret_Offset(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)CARET_OFFSET));
    }

    public static ShortBuffer nReserved(long struct) {
        return MemoryUtil.memShortBuffer((long)(struct + (long)RESERVED), (int)4);
    }

    public static short nReserved(long struct, int index) {
        return MemoryUtil.memGetShort((long)(struct + (long)RESERVED + Checks.check((int)index, (int)4) * 2L));
    }

    public static short nmetric_Data_Format(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)METRIC_DATA_FORMAT));
    }

    public static short nnumber_Of_HMetrics(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)NUMBER_OF_HMETRICS));
    }

    public static @Nullable ByteBuffer nlong_metrics(long struct, int capacity) {
        return MemoryUtil.memByteBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)LONG_METRICS)), (int)capacity);
    }

    public static @Nullable ByteBuffer nshort_metrics(long struct, int capacity) {
        return MemoryUtil.memByteBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)SHORT_METRICS)), (int)capacity);
    }

    static {
        Struct.Layout layout = TT_HoriHeader.__struct((Struct.Member[])new Struct.Member[]{TT_HoriHeader.__member((int)CLONG_SIZE), TT_HoriHeader.__member((int)2), TT_HoriHeader.__member((int)2), TT_HoriHeader.__member((int)2), TT_HoriHeader.__member((int)2), TT_HoriHeader.__member((int)2), TT_HoriHeader.__member((int)2), TT_HoriHeader.__member((int)2), TT_HoriHeader.__member((int)2), TT_HoriHeader.__member((int)2), TT_HoriHeader.__member((int)2), TT_HoriHeader.__array((int)2, (int)4), TT_HoriHeader.__member((int)2), TT_HoriHeader.__member((int)2), TT_HoriHeader.__member((int)POINTER_SIZE), TT_HoriHeader.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERSION = layout.offsetof(0);
        ASCENDER = layout.offsetof(1);
        DESCENDER = layout.offsetof(2);
        LINE_GAP = layout.offsetof(3);
        ADVANCE_WIDTH_MAX = layout.offsetof(4);
        MIN_LEFT_SIDE_BEARING = layout.offsetof(5);
        MIN_RIGHT_SIDE_BEARING = layout.offsetof(6);
        XMAX_EXTENT = layout.offsetof(7);
        CARET_SLOPE_RISE = layout.offsetof(8);
        CARET_SLOPE_RUN = layout.offsetof(9);
        CARET_OFFSET = layout.offsetof(10);
        RESERVED = layout.offsetof(11);
        METRIC_DATA_FORMAT = layout.offsetof(12);
        NUMBER_OF_HMETRICS = layout.offsetof(13);
        LONG_METRICS = layout.offsetof(14);
        SHORT_METRICS = layout.offsetof(15);
    }

    public static class Buffer
    extends StructBuffer<TT_HoriHeader, Buffer> {
        private static final TT_HoriHeader ELEMENT_FACTORY = TT_HoriHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected TT_HoriHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="FT_Fixed")
        public long Version() {
            return TT_HoriHeader.nVersion(this.address());
        }

        @NativeType(value="FT_Short")
        public short Ascender() {
            return TT_HoriHeader.nAscender(this.address());
        }

        @NativeType(value="FT_Short")
        public short Descender() {
            return TT_HoriHeader.nDescender(this.address());
        }

        @NativeType(value="FT_Short")
        public short Line_Gap() {
            return TT_HoriHeader.nLine_Gap(this.address());
        }

        @NativeType(value="FT_UShort")
        public short advance_Width_Max() {
            return TT_HoriHeader.nadvance_Width_Max(this.address());
        }

        @NativeType(value="FT_Short")
        public short min_Left_Side_Bearing() {
            return TT_HoriHeader.nmin_Left_Side_Bearing(this.address());
        }

        @NativeType(value="FT_Short")
        public short min_Right_Side_Bearing() {
            return TT_HoriHeader.nmin_Right_Side_Bearing(this.address());
        }

        @NativeType(value="FT_Short")
        public short xMax_Extent() {
            return TT_HoriHeader.nxMax_Extent(this.address());
        }

        @NativeType(value="FT_Short")
        public short caret_Slope_Rise() {
            return TT_HoriHeader.ncaret_Slope_Rise(this.address());
        }

        @NativeType(value="FT_Short")
        public short caret_Slope_Run() {
            return TT_HoriHeader.ncaret_Slope_Run(this.address());
        }

        @NativeType(value="FT_Short")
        public short caret_Offset() {
            return TT_HoriHeader.ncaret_Offset(this.address());
        }

        @NativeType(value="FT_Short[4]")
        public ShortBuffer Reserved() {
            return TT_HoriHeader.nReserved(this.address());
        }

        @NativeType(value="FT_Short")
        public short Reserved(int index) {
            return TT_HoriHeader.nReserved(this.address(), index);
        }

        @NativeType(value="FT_Short")
        public short metric_Data_Format() {
            return TT_HoriHeader.nmetric_Data_Format(this.address());
        }

        @NativeType(value="FT_UShort")
        public short number_Of_HMetrics() {
            return TT_HoriHeader.nnumber_Of_HMetrics(this.address());
        }

        @NativeType(value="void *")
        public @Nullable ByteBuffer long_metrics(int capacity) {
            return TT_HoriHeader.nlong_metrics(this.address(), capacity);
        }

        @NativeType(value="void *")
        public @Nullable ByteBuffer short_metrics(int capacity) {
            return TT_HoriHeader.nshort_metrics(this.address(), capacity);
        }
    }
}

