/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.freetype;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FT_Matrix
extends Struct<FT_Matrix>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int XX;
    public static final int XY;
    public static final int YX;
    public static final int YY;

    protected FT_Matrix(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected FT_Matrix create(long address, @Nullable ByteBuffer container) {
        return new FT_Matrix(address, container);
    }

    public FT_Matrix(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), FT_Matrix.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="FT_Fixed")
    public long xx() {
        return FT_Matrix.nxx(this.address());
    }

    @NativeType(value="FT_Fixed")
    public long xy() {
        return FT_Matrix.nxy(this.address());
    }

    @NativeType(value="FT_Fixed")
    public long yx() {
        return FT_Matrix.nyx(this.address());
    }

    @NativeType(value="FT_Fixed")
    public long yy() {
        return FT_Matrix.nyy(this.address());
    }

    public FT_Matrix xx(@NativeType(value="FT_Fixed") long value) {
        FT_Matrix.nxx(this.address(), value);
        return this;
    }

    public FT_Matrix xy(@NativeType(value="FT_Fixed") long value) {
        FT_Matrix.nxy(this.address(), value);
        return this;
    }

    public FT_Matrix yx(@NativeType(value="FT_Fixed") long value) {
        FT_Matrix.nyx(this.address(), value);
        return this;
    }

    public FT_Matrix yy(@NativeType(value="FT_Fixed") long value) {
        FT_Matrix.nyy(this.address(), value);
        return this;
    }

    public FT_Matrix set(long xx, long xy, long yx, long yy) {
        this.xx(xx);
        this.xy(xy);
        this.yx(yx);
        this.yy(yy);
        return this;
    }

    public FT_Matrix set(FT_Matrix src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static FT_Matrix malloc() {
        return new FT_Matrix(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static FT_Matrix calloc() {
        return new FT_Matrix(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static FT_Matrix create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new FT_Matrix(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static FT_Matrix create(long address) {
        return new FT_Matrix(address, null);
    }

    public static @Nullable FT_Matrix createSafe(long address) {
        return address == 0L ? null : new FT_Matrix(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)FT_Matrix.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FT_Matrix.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FT_Matrix malloc(MemoryStack stack) {
        return new FT_Matrix(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FT_Matrix calloc(MemoryStack stack) {
        return new FT_Matrix(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nxx(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)XX));
    }

    public static long nxy(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)XY));
    }

    public static long nyx(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)YX));
    }

    public static long nyy(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)YY));
    }

    public static void nxx(long struct, long value) {
        MemoryUtil.memPutCLong((long)(struct + (long)XX), (long)value);
    }

    public static void nxy(long struct, long value) {
        MemoryUtil.memPutCLong((long)(struct + (long)XY), (long)value);
    }

    public static void nyx(long struct, long value) {
        MemoryUtil.memPutCLong((long)(struct + (long)YX), (long)value);
    }

    public static void nyy(long struct, long value) {
        MemoryUtil.memPutCLong((long)(struct + (long)YY), (long)value);
    }

    static {
        Struct.Layout layout = FT_Matrix.__struct((Struct.Member[])new Struct.Member[]{FT_Matrix.__member((int)CLONG_SIZE), FT_Matrix.__member((int)CLONG_SIZE), FT_Matrix.__member((int)CLONG_SIZE), FT_Matrix.__member((int)CLONG_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        XX = layout.offsetof(0);
        XY = layout.offsetof(1);
        YX = layout.offsetof(2);
        YY = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<FT_Matrix, Buffer>
    implements NativeResource {
        private static final FT_Matrix ELEMENT_FACTORY = FT_Matrix.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected FT_Matrix getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="FT_Fixed")
        public long xx() {
            return FT_Matrix.nxx(this.address());
        }

        @NativeType(value="FT_Fixed")
        public long xy() {
            return FT_Matrix.nxy(this.address());
        }

        @NativeType(value="FT_Fixed")
        public long yx() {
            return FT_Matrix.nyx(this.address());
        }

        @NativeType(value="FT_Fixed")
        public long yy() {
            return FT_Matrix.nyy(this.address());
        }

        public Buffer xx(@NativeType(value="FT_Fixed") long value) {
            FT_Matrix.nxx(this.address(), value);
            return this;
        }

        public Buffer xy(@NativeType(value="FT_Fixed") long value) {
            FT_Matrix.nxy(this.address(), value);
            return this;
        }

        public Buffer yx(@NativeType(value="FT_Fixed") long value) {
            FT_Matrix.nyx(this.address(), value);
            return this;
        }

        public Buffer yy(@NativeType(value="FT_Fixed") long value) {
            FT_Matrix.nyy(this.address(), value);
            return this;
        }
    }
}

