/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.sat4j.pb.lcds;

import java.math.BigInteger;
import net.fabricmc.loader.impl.lib.sat4j.core.VecInt;
import net.fabricmc.loader.impl.lib.sat4j.minisat.core.ILits;
import net.fabricmc.loader.impl.lib.sat4j.pb.constraints.pb.PBConstr;
import net.fabricmc.loader.impl.lib.sat4j.pb.lcds.AbstractLBDComputerStrategy;
import net.fabricmc.loader.impl.lib.sat4j.specs.IVecInt;
import net.fabricmc.loader.impl.lib.sat4j.specs.IteratorInt;

public class EffectiveLiteralsOnlyLBDComputerStrategy
extends AbstractLBDComputerStrategy {
    private int currentPropagated;
    private BigInteger degree;
    private final IVecInt lbdCandidates = new VecInt();

    @Override
    protected void startComputeLBD(PBConstr constr, int propagated) {
        this.degree = constr.getDegree();
        this.currentPropagated = propagated;
        this.lbdCandidates.clear();
    }

    @Override
    protected int unassignedLiteral(ILits voc, PBConstr constr, int i) {
        this.degree = this.degree.subtract(constr.getCoef(i));
        return 0;
    }

    @Override
    protected int assignedLiteral(ILits voc, PBConstr constr, int i) {
        if (constr.get(i) == this.currentPropagated) {
            return 0;
        }
        if (voc.isSatisfied(constr.get(i))) {
            this.degree = this.degree.subtract(constr.getCoef(i));
            return 0;
        }
        this.lbdCandidates.push(i);
        return 1;
    }

    @Override
    protected int fixLbd(PBConstr constr, int lbd) {
        int v;
        int newLbd = 0;
        IteratorInt it = this.lbdCandidates.iterator();
        while (it.hasNext() && constr.getCoef(v = it.next()).compareTo(this.degree) >= 0) {
            ++newLbd;
        }
        return newLbd;
    }
}

