/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.utils;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.yuushya.modelling.blockentity.showblock.ShowBlock;
import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class YuushyaUtils {
    public static final Function<Map.Entry<Property<?>, Comparable<?>>, String> PROPERTY_ENTRY_TO_STRING_FUNCTION = new Function<Map.Entry<Property<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<Property<?>, Comparable<?>> propertyValueMap) {
            if (propertyValueMap == null) {
                return "<NULL>";
            }
            Property<?> property = propertyValueMap.getKey();
            return property.m_61708_() + "=" + this.getName(property, propertyValueMap.getValue());
        }

        private <T extends Comparable<T>> String getName(Property<T> property, Comparable<?> value) {
            return property.m_6940_(value);
        }
    };

    public static int vertexSize() {
        return DefaultVertexFormat.f_85811_.m_86020_() / 4;
    }

    public static void scale(PoseStack arg, Vector3f scales) {
        if (scales.x() != 1.0f || scales.y() != 1.0f || scales.z() != 1.0f) {
            arg.m_85837_(0.5, 0.5, 0.5);
            arg.m_85841_(scales.x(), scales.y(), scales.z());
            arg.m_85837_(-0.5, -0.5, -0.5);
        }
    }

    public static void translateAfterScale(PoseStack arg, Vector3d pos, Vector3f scales) {
        if (pos.x != 0.0 || pos.y != 0.0 || pos.z != 0.0) {
            arg.m_85837_(pos.x * (double)scales.x() / 16.0, pos.y * (double)scales.y() / 16.0, pos.z * (double)scales.z() / 16.0);
        }
    }

    public static void translate(PoseStack arg, Vector3d pos) {
        if (pos.x != 0.0 || pos.y != 0.0 || pos.z != 0.0) {
            arg.m_85837_(pos.x / 16.0, pos.y / 16.0, pos.z / 16.0);
        }
    }

    public static void rotate(PoseStack arg, Vector3f rot) {
        float roll = rot.z();
        float yaw = rot.y();
        float pitch = rot.x();
        if (roll != 0.0f || yaw != 0.0f || pitch != 0.0f) {
            arg.m_85837_(0.5, 0.5, 0.5);
            if (roll != 0.0f) {
                arg.m_252781_(Axis.f_252403_.m_252977_(roll));
            }
            if (yaw != 0.0f) {
                arg.m_252781_(Axis.f_252436_.m_252977_(yaw));
            }
            if (pitch != 0.0f) {
                arg.m_252781_(Axis.f_252529_.m_252977_(pitch));
            }
            arg.m_85837_(-0.5, -0.5, -0.5);
        }
    }

    public static int encodeTintWithState(int tint, BlockState state) {
        return Block.m_49956_((BlockState)state) << 8 | tint;
    }

    public static BlockState getBlockState(BlockState blockState, LevelAccessor world, BlockPos blockPos) {
        if (blockState.m_60734_() instanceof ShowBlock) {
            ShowBlockEntity blockEntity = (ShowBlockEntity)world.m_7702_(blockPos);
            return blockEntity.getTransFormDataNow().blockState;
        }
        return blockState;
    }

    public static String getBlockStateProperties(BlockState blockState) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!blockState.m_61148_().isEmpty()) {
            stringBuilder.append('[');
            stringBuilder.append(blockState.m_61148_().entrySet().stream().map(PROPERTY_ENTRY_TO_STRING_FUNCTION).collect(Collectors.joining(",")));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    public static <T> ListTag toListTag(T ... values) {
        ListTag listTag = new ListTag();
        Arrays.stream(values).toList().forEach(e -> {
            if (e instanceof Float) {
                Float e1 = (Float)e;
                listTag.add((Object)FloatTag.m_128566_((float)e1.floatValue()));
            } else if (e instanceof Double) {
                Double e1 = (Double)e;
                listTag.add((Object)DoubleTag.m_128500_((double)e1));
            }
        });
        return listTag;
    }

    public static BlockState readBlockState(CompoundTag tag) {
        if (!tag.m_128425_("Name", 8)) {
            return Blocks.f_50016_.m_49966_();
        }
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(tag.m_128461_("Name")));
        BlockState blockState = block.m_49966_();
        if (tag.m_128425_("Properties", 10)) {
            CompoundTag compoundTag = tag.m_128469_("Properties");
            StateDefinition stateDefinition = block.m_49965_();
            for (String string : compoundTag.m_128431_()) {
                Property property = stateDefinition.m_61081_(string);
                if (property == null) continue;
                blockState = YuushyaUtils.setValueHelper(blockState, property, string, compoundTag, tag);
            }
        }
        return blockState;
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S stateHolder, Property<T> property, String propertyName, CompoundTag propertiesTag, CompoundTag blockStateTag) {
        Optional optional = property.m_6215_(propertiesTag.m_128461_(propertyName));
        if (optional.isPresent()) {
            return (S)((StateHolder)stateHolder.m_61124_(property, (Comparable)optional.get()));
        }
        return stateHolder;
    }
}

