/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.utils;

import com.google.common.collect.ImmutableMap;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.yuushya.modelling.blockentity.TransformData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class ShareUtils {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).create();

    public static String transfer(List<TransformData> transformDataList) {
        ShareInformation shareInformation = ShareInformation.from(transformDataList);
        return GSON.toJson((Object)shareInformation, ShareInformation.class);
    }

    public static ShareInformation from(String json) {
        return (ShareInformation)GSON.fromJson(json, ShareInformation.class);
    }

    public record ShareInformation(Set<String> mods, List<ShareData> blocks) {
        public static ShareInformation from(List<TransformData> transformDataList) {
            HashSet<String> modIds = new HashSet<String>();
            ArrayList<ShareData> shareDataList = new ArrayList<ShareData>();
            for (TransformData data : transformDataList) {
                String namespace = BuiltInRegistries.f_256975_.m_7981_((Object)data.blockState.m_60734_()).m_135827_();
                if (!"minecraft".equals(namespace)) {
                    modIds.add(namespace);
                }
                shareDataList.add(ShareData.from(data));
            }
            return new ShareInformation(modIds, shareDataList);
        }

        public void transfer(List<TransformData> transformDataList) {
            if (!transformDataList.isEmpty()) {
                transformDataList.clear();
            }
            for (ShareData data : this.blocks) {
                transformDataList.add(data.transfer());
            }
        }

        public record ShareData(List<Double> pos, List<Float> rot, List<Float> scales, ShareBlockState blockState, boolean isShown) {
            public static ShareData from(TransformData data) {
                return new ShareData(List.of(Double.valueOf(data.pos.x), Double.valueOf(data.pos.y), Double.valueOf(data.pos.z)), List.of(Float.valueOf(data.rot.x), Float.valueOf(data.rot.y), Float.valueOf(data.rot.z)), List.of(Float.valueOf(data.scales.x), Float.valueOf(data.scales.y), Float.valueOf(data.scales.z)), ShareBlockState.from(data.blockState), data.isShown);
            }

            public TransformData transfer() {
                this.pos.add(0.0);
                this.pos.add(0.0);
                this.pos.add(0.0);
                this.rot.add(Float.valueOf(0.0f));
                this.rot.add(Float.valueOf(0.0f));
                this.rot.add(Float.valueOf(0.0f));
                this.scales.add(Float.valueOf(1.0f));
                this.scales.add(Float.valueOf(1.0f));
                this.scales.add(Float.valueOf(1.0f));
                return new TransformData(new Vector3d(this.pos.get(0).doubleValue(), this.pos.get(1).doubleValue(), this.pos.get(2).doubleValue()), new Vector3f(this.rot.get(0).floatValue(), this.rot.get(1).floatValue(), this.rot.get(2).floatValue()), new Vector3f(this.scales.get(0).floatValue(), this.scales.get(1).floatValue(), this.scales.get(2).floatValue()), this.blockState.transfer(), this.isShown);
            }

            public record ShareBlockState(String name, Map<String, String> properties) {
                public static ShareBlockState from(BlockState state) {
                    String name = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()).toString();
                    ImmutableMap map = state.m_61148_();
                    HashMap<String, String> properties = new HashMap<String, String>();
                    for (Map.Entry entry : map.entrySet()) {
                        Property property = (Property)entry.getKey();
                        Comparable value = (Comparable)entry.getValue();
                        properties.put(property.m_61708_(), ShareBlockState.getName(property, value));
                    }
                    return new ShareBlockState(name, properties);
                }

                public BlockState transfer() {
                    Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(this.name));
                    BlockState blockState = block.m_49966_();
                    StateDefinition stateDefinition = block.m_49965_();
                    for (String string : this.properties.keySet()) {
                        Property property = stateDefinition.m_61081_(string);
                        if (property == null) continue;
                        blockState = ShareBlockState.setValueHelper(blockState, property, this.properties.get(string));
                    }
                    return blockState;
                }

                private static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S stateHolder, Property<T> property, String value) {
                    return (S)property.m_6215_(value).map(t -> (StateHolder)stateHolder.m_61124_(property, t)).orElse(stateHolder);
                }

                private static <T extends Comparable<T>> String getName(Property<T> property, Comparable<T> value) {
                    return property.m_6940_(value);
                }
            }
        }
    }

    public static class StringSerialization {
        public static CompoundTag transfer(String string) throws CommandSyntaxException {
            return TagParser.m_129359_((String)string);
        }

        public static String from(CompoundTag tag) {
            return tag.m_7916_();
        }
    }
}

