/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.item.showblocktool;

import com.yuushya.modelling.item.showblocktool.PosTransItem;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;

public class RotTransItem
extends PosTransItem {
    public RotTransItem(Item.Properties properties, Integer tipLines) {
        super(properties, tipLines);
    }

    public float getDegreeAfterRotation(float degree, int mode) {
        if (mode > 0) {
            return degree + 22.5f < 360.0f ? degree + 22.5f : 0.0f;
        }
        return degree - 22.5f > 0.0f ? degree - 22.5f : 360.0f;
    }

    @Override
    public InteractionResult inMainHandRightClickOnBlock(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        this.getTag(handItemStack);
        return RotTransItem.translateData(player, blockState, level, blockPos, handItemStack, transformData -> {
            Vector3f rot = transformData.rot;
            switch (this.getForm()) {
                case 0: {
                    rot.set(this.getDegreeAfterRotation(rot.x(), 1), rot.y(), rot.z());
                    break;
                }
                case 1: {
                    rot.set(rot.x(), this.getDegreeAfterRotation(rot.y(), 1), rot.z());
                    break;
                }
                case 2: {
                    rot.set(rot.x(), rot.y(), this.getDegreeAfterRotation(rot.z(), 1));
                }
            }
            player.m_5661_((Component)Component.m_237110_((String)(this.m_5524_() + ".switch"), (Object[])new Object[]{Float.valueOf(rot.x()), Float.valueOf(rot.y()), Float.valueOf(rot.z())}), true);
        });
    }

    @Override
    public InteractionResult inMainHandLeftClickOnBlock(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        this.getTag(handItemStack);
        return RotTransItem.translateData(player, blockState, level, blockPos, handItemStack, transformData -> {
            Vector3f rot = transformData.rot;
            switch (this.getForm()) {
                case 0: {
                    rot.set(this.getDegreeAfterRotation(rot.x(), -1), rot.y(), rot.z());
                    break;
                }
                case 1: {
                    rot.set(rot.x(), this.getDegreeAfterRotation(rot.y(), -1), rot.z());
                    break;
                }
                case 2: {
                    rot.set(rot.x(), rot.y(), this.getDegreeAfterRotation(rot.z(), -1));
                }
            }
            player.m_5661_((Component)Component.m_237110_((String)(this.m_5524_() + ".switch"), (Object[])new Object[]{Float.valueOf(rot.x()), Float.valueOf(rot.y()), Float.valueOf(rot.z())}), true);
        });
    }
}

