/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.item.showblocktool;

import com.yuushya.modelling.blockentity.TransformData;
import com.yuushya.modelling.blockentity.showblock.ShowBlock;
import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import com.yuushya.modelling.item.AbstractMultiPurposeToolItem;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class PosTransItem
extends AbstractMultiPurposeToolItem {
    public static double getMaxPos(double scale) {
        return scale < 1.0 ? Math.ceil(24.0 / scale) - 8.0 : Math.ceil(16.0 / scale);
    }

    public static double getStep(double max) {
        return max < 16.0 ? max / 16.0 : 1.0;
    }

    public static double getUpdate(boolean increase, double pos, float scale) {
        double max = PosTransItem.getMaxPos(scale);
        double perPos = PosTransItem.getStep(max);
        if (increase) {
            double res = pos + perPos;
            return res > max ? 0.0 : res;
        }
        double res = pos - perPos;
        return res < -max ? 0.0 : res;
    }

    public PosTransItem(Item.Properties properties, Integer tipLines) {
        super(properties, tipLines);
        this.MAX_FORMS = 3;
    }

    @Override
    public InteractionResult inMainHandRightClickOnBlock(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        this.getTag(handItemStack);
        return PosTransItem.translateData(player, blockState, level, blockPos, handItemStack, transformData -> {
            Vector3d pos = transformData.pos;
            Vector3f scale = transformData.scales;
            switch (this.getForm()) {
                case 0: {
                    pos.x = PosTransItem.getUpdate(false, pos.x, scale.x);
                    break;
                }
                case 1: {
                    pos.y = PosTransItem.getUpdate(false, pos.y, scale.y);
                    break;
                }
                case 2: {
                    pos.z = PosTransItem.getUpdate(false, pos.z, scale.z);
                }
            }
            player.m_5661_((Component)Component.m_237110_((String)(this.m_5524_() + ".switch"), (Object[])new Object[]{pos.x, pos.y, pos.z}), true);
        });
    }

    @Override
    public InteractionResult inMainHandLeftClickOnBlock(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        this.getTag(handItemStack);
        return PosTransItem.translateData(player, blockState, level, blockPos, handItemStack, transformData -> {
            Vector3d pos = transformData.pos;
            Vector3f scale = transformData.scales;
            switch (this.getForm()) {
                case 0: {
                    pos.x = PosTransItem.getUpdate(true, pos.x, scale.x);
                    break;
                }
                case 1: {
                    pos.y = PosTransItem.getUpdate(true, pos.y, scale.y);
                    break;
                }
                case 2: {
                    pos.z = PosTransItem.getUpdate(true, pos.z, scale.z);
                }
            }
            player.m_5661_((Component)Component.m_237110_((String)(this.m_5524_() + ".switch"), (Object[])new Object[]{pos.x, pos.y, pos.z}), true);
        });
    }

    protected static InteractionResult translateData(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack, Consumer<TransformData> consumer) {
        if (blockState.m_60734_() instanceof ShowBlock) {
            ShowBlockEntity showBlockEntity = (ShowBlockEntity)level.m_7702_(blockPos);
            TransformData transformData = showBlockEntity.getTransFormDataNow();
            consumer.accept(transformData);
            showBlockEntity.saveChanged();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

