/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.item.showblocktool;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yuushya.modelling.blockentity.showblock.ShowBlock;
import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import com.yuushya.modelling.item.AbstractToolItem;
import com.yuushya.modelling.utils.YuushyaUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class GetBlockStateItem
extends AbstractToolItem {
    private BlockState blockState = Blocks.f_50016_.m_49966_();

    public GetBlockStateItem(Item.Properties properties, Integer tipLines) {
        super(properties, tipLines);
    }

    @Override
    public InteractionResult inMainHandRightClickOnBlock(Player player, BlockState blockStateTarget, Level level, BlockPos blockPos, ItemStack handItemStack) {
        this.getTag(level, handItemStack);
        if (blockStateTarget.m_60734_() instanceof ShowBlock) {
            ShowBlockEntity showBlockEntity = (ShowBlockEntity)level.m_7702_(blockPos);
            BlockState blockStateShowBlock = showBlockEntity.getTransFormDataNow().blockState;
            if (!(blockStateShowBlock.m_60734_() instanceof AirBlock)) {
                blockStateTarget = blockStateShowBlock;
                showBlockEntity.removeTransFormDataNow();
                showBlockEntity.saveChanged();
            } else {
                player.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".mainhand.pass")), true);
                return InteractionResult.PASS;
            }
        }
        this.blockState = blockStateTarget;
        this.setTag(handItemStack);
        player.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".mainhand.success")), true);
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult inOffHandRightClickOnBlock(Player player, BlockState blockStateTarget, Level level, BlockPos blockPos, ItemStack handItemStack) {
        this.getTag(level, handItemStack);
        if (this.blockState.m_60734_() instanceof AirBlock) {
            player.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".offhand.fail")), true);
            return InteractionResult.SUCCESS;
        }
        if (blockStateTarget.m_60734_() instanceof ShowBlock) {
            ShowBlockEntity showBlockEntity = (ShowBlockEntity)level.m_7702_(blockPos);
            showBlockEntity.setSlotBlockStateNow(this.blockState);
            showBlockEntity.setSlotShown(showBlockEntity.getSlot(), true);
            showBlockEntity.saveChanged();
            player.m_5661_((Component)Component.m_237115_((String)(this.m_5524_() + ".offhand.success")), true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void getTag(Level level, ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        this.blockState = YuushyaUtils.readBlockState(compoundTag.m_128469_("BlockState"));
    }

    public void setTag(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        compoundTag.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        itemStack.m_41751_(compoundTag);
    }

    public static void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BlockState blockState = YuushyaUtils.readBlockState(stack.m_41784_().m_128469_("BlockState"));
        BlockRenderDispatcher blockRenderDispatcher = Minecraft.m_91087_().m_91289_();
        itemRenderer.m_115143_(stack, displayContext, false, matrices, vertexConsumers, light, overlay, blockRenderDispatcher.m_110910_(blockState));
    }
}

