/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.item;

import com.yuushya.modelling.block.blockstate.YuushyaBlockStates;
import com.yuushya.modelling.blockentity.showblock.ShowBlock;
import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import com.yuushya.modelling.item.AbstractToolItem;
import com.yuushya.modelling.utils.YuushyaUtils;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class YuushyaDebugStickItem
extends AbstractToolItem {
    public YuushyaDebugStickItem(Item.Properties properties, Integer tipLines) {
        super(properties, tipLines);
    }

    @Override
    public InteractionResult inMainHandRightClickOnBlock(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        return !this.handleInteraction(player, level.m_8055_(blockPos), (LevelAccessor)level, blockPos, true, handItemStack) ? InteractionResult.FAIL : InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult inMainHandLeftClickOnBlock(Player player, BlockState blockState, Level level, BlockPos blockPos, ItemStack handItemStack) {
        this.handleInteraction(player, blockState, (LevelAccessor)level, blockPos, false, player.m_21120_(InteractionHand.MAIN_HAND));
        return InteractionResult.PASS;
    }

    private boolean handleInteraction(Player player, BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos, boolean isRightClicked, ItemStack itemStack) {
        if (!player.m_36337_()) {
            return false;
        }
        boolean isShowBlock = blockState.m_60734_() instanceof ShowBlock;
        blockState = YuushyaUtils.getBlockState(blockState, levelAccessor, blockPos);
        StateDefinition stateDefinition = blockState.m_60734_().m_49965_();
        Collection collection = stateDefinition.m_61092_();
        String blockName = BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_()).toString();
        if (collection.isEmpty()) {
            player.m_5661_((Component)Component.m_237110_((String)(this.m_5524_() + ".empty"), (Object[])new Object[]{blockName}), true);
            return false;
        }
        CompoundTag compoundTag = itemStack.m_41698_("DebugProperty");
        String propertyName = compoundTag.m_128461_(blockName);
        Property property = stateDefinition.m_61081_(propertyName);
        if (isRightClicked) {
            if (property == null) {
                property = (Property)collection.iterator().next();
            }
            BlockState blockStateNew = YuushyaBlockStates.cycleState(blockState, property, player.m_36341_());
            if (isShowBlock) {
                ShowBlockEntity showBlockEntity = (ShowBlockEntity)levelAccessor.m_7702_(blockPos);
                showBlockEntity.setSlotBlockState(0, blockStateNew);
                showBlockEntity.saveChanged();
            } else {
                levelAccessor.m_7731_(blockPos, blockStateNew, 18);
            }
            player.m_5661_((Component)Component.m_237110_((String)(this.m_5524_() + ".update"), (Object[])new Object[]{property.m_61708_(), YuushyaDebugStickItem.getNameHelper(blockStateNew, property)}), true);
        } else {
            property = YuushyaBlockStates.getRelative(collection, property, player.m_36341_());
            String propertyNameNew = property.m_61708_();
            compoundTag.m_128359_(blockName, propertyNameNew);
            player.m_5661_((Component)Component.m_237110_((String)(this.m_5524_() + ".select"), (Object[])new Object[]{propertyNameNew, YuushyaDebugStickItem.getNameHelper(blockState, property)}), true);
        }
        return true;
    }

    public static <T extends Comparable<T>> String getNameHelper(BlockState blockState, Property<T> property) {
        return property.m_6940_(blockState.m_61143_(property));
    }
}

