/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui.validate;

import com.yuushya.modelling.gui.SliderButton;
import com.yuushya.modelling.gui.validate.DoubleRange;
import com.yuushya.modelling.gui.validate.StepRange;
import com.yuushya.modelling.gui.validate.ValidateRange;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public final class LazyDoubleRange
implements ValidateRange<Double>,
StepRange<Double> {
    private final Supplier<Double> minInclusiveSupplier;
    private final Supplier<Double> maxInclusiveSupplier;
    private double step = 0.001;
    private Supplier<Double> stepSupplier;

    public LazyDoubleRange(Supplier<Double> minInclusiveSupplier, Supplier<Double> maxInclusiveSupplier, Supplier<Double> stepSupplier) {
        this(minInclusiveSupplier, maxInclusiveSupplier);
        this.stepSupplier = stepSupplier;
        this.step = 0.0;
    }

    public LazyDoubleRange(Supplier<Double> minInclusiveSupplier, Supplier<Double> maxInclusiveSupplier) {
        this.minInclusiveSupplier = minInclusiveSupplier;
        this.maxInclusiveSupplier = maxInclusiveSupplier;
        this.stepSupplier = () -> this.step;
    }

    @Override
    public Double minInclusive() {
        return this.minInclusiveSupplier.get();
    }

    @Override
    public Double maxInclusive() {
        return this.maxInclusiveSupplier.get();
    }

    @Override
    public Optional<Double> validateValue(Double value) {
        if (value < this.minInclusive()) {
            return Optional.of(this.minInclusive());
        }
        if (value > this.maxInclusive()) {
            return Optional.of(this.maxInclusive());
        }
        return Optional.of(DoubleRange.near(value / this.getStep()) * this.getStep());
    }

    public void setStepSupplier(Supplier<Double> stepSupplier) {
        this.stepSupplier = stepSupplier;
    }

    @Override
    public void setStep(Double step) {
        this.step = step;
    }

    @Override
    public Double getStep() {
        return this.step == 0.0 ? this.stepSupplier.get() : this.step;
    }

    @Override
    public double toSliderValue(Double value) {
        return Mth.m_144914_((double)value, (double)this.minInclusive(), (double)this.maxInclusive(), (double)0.0, (double)1.0);
    }

    @Override
    public Double fromSliderValue(double sliderValue) {
        return Mth.m_144914_((double)sliderValue, (double)0.0, (double)1.0, (double)this.minInclusive(), (double)this.maxInclusive());
    }

    public static Component captionToString(Component caption, Double value) {
        return Component.m_237119_().m_7220_(caption).m_7220_((Component)Component.m_237113_((String)":").m_7220_((Component)Component.m_237113_((String)String.format("%05.1f", value))));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LazyDoubleRange that = (LazyDoubleRange)obj;
        return Objects.equals(this.minInclusiveSupplier.get(), that.minInclusiveSupplier.get()) && Objects.equals(this.maxInclusiveSupplier.get(), that.maxInclusiveSupplier.get()) && Objects.equals(this.step, that.step);
    }

    public int hashCode() {
        return Objects.hash(this.minInclusiveSupplier.get(), this.maxInclusiveSupplier.get(), this.step);
    }

    public String toString() {
        return "LazyDoubleRange[minInclusive=" + String.valueOf(this.minInclusiveSupplier.get()) + ", maxInclusive=" + String.valueOf(this.maxInclusiveSupplier.get()) + ", step=" + this.step + "]";
    }

    public static ButtonBuilder buttonBuilder(Component caption, Supplier<Double> minInclusiveSupplier, Supplier<Double> maxInclusiveSupplier, Consumer<Double> onValueChanged) {
        return new ButtonBuilder(caption, minInclusiveSupplier, maxInclusiveSupplier, onValueChanged);
    }

    public static ButtonBuilder buttonBuilder(Component caption, Supplier<Double> minInclusiveSupplier, Supplier<Double> maxInclusiveSupplier, Supplier<Double> stepSupplier, Consumer<Double> onValueChanged) {
        return new ButtonBuilder(caption, minInclusiveSupplier, maxInclusiveSupplier, stepSupplier, onValueChanged);
    }

    public static class ButtonBuilder
    extends SliderButton.Builder<Double> {
        public ButtonBuilder(Component caption, Supplier<Double> minInclusiveSupplier, Supplier<Double> maxInclusiveSupplier, Consumer<Double> onValueChanged) {
            super(caption, new LazyDoubleRange(minInclusiveSupplier, maxInclusiveSupplier), onValueChanged);
            this.text(LazyDoubleRange::captionToString);
            this.initial(minInclusiveSupplier.get());
        }

        public ButtonBuilder(Component caption, Supplier<Double> minInclusiveSupplier, Supplier<Double> maxInclusiveSupplier, Supplier<Double> stepSupplier, Consumer<Double> onValueChanged) {
            super(caption, new LazyDoubleRange(minInclusiveSupplier, maxInclusiveSupplier, stepSupplier), onValueChanged);
            this.text(LazyDoubleRange::captionToString);
            this.initial(minInclusiveSupplier.get());
        }
    }
}

