/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui.showblock;

import com.yuushya.modelling.block.blockstate.YuushyaBlockStates;
import com.yuushya.modelling.blockentity.TransformData;
import com.yuushya.modelling.blockentity.TransformDataNetwork;
import com.yuushya.modelling.blockentity.TransformType;
import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import com.yuushya.modelling.gui.SliderButton;
import com.yuushya.modelling.gui.engrave.EngraveItemResultLoader;
import com.yuushya.modelling.gui.showblock.BlockStateIconList;
import com.yuushya.modelling.gui.showblock.EditScreen;
import com.yuushya.modelling.gui.validate.DividedDoubleRange;
import com.yuushya.modelling.gui.validate.DoubleRange;
import com.yuushya.modelling.gui.validate.LazyDoubleRange;
import com.yuushya.modelling.item.YuushyaDebugStickItem;
import com.yuushya.modelling.item.showblocktool.PosTransItem;
import com.yuushya.modelling.utils.ShareUtils;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ShowBlockScreen
extends Screen {
    private final ShowBlockEntity blockEntity;
    private final BlockState newBlockState;
    private int slot;
    private final Map<TransformType, Double> storage = new HashMap<TransformType, Double>();
    private final Map<TransformType, TransformComponent> panel = new LinkedHashMap<TransformType, TransformComponent>();
    private CycleButton<Mode> modeButton;
    private Button addStateButton;
    private Button removeStateButton;
    private Button replaceButton;
    private Button copyButton;
    private Button parseButton;
    private Button saveButton;
    private CycleButton<Boolean> shownStateButton;
    private final Map<TransformType, EditBox> editBoxes = new HashMap<TransformType, EditBox>();
    private BlockStateIconList blockStateList;
    private Button leftPropertyButton;
    private Property<?> property;
    private Button rightPropertyButton;
    private Button leftStateButton;
    private Button rightStateButton;
    private static final int TOP = 10;
    private static final int PER_HEIGHT = 20;
    private static final int RIGHT_COLUMN_X = 2;
    private static final int RIGHT_BAR_WIDTH = 20;
    private static final int SMALL_BUTTON_WIDTH = 10;
    private static final int RIGHT_LIST_WIDTH = 40;
    private static final int RIGHT_LIST_PER_HEIGHT = 45;
    private static final int RIGHT_LIST_TOP = 35;
    private static final int RIGHT_LIST_HEIGHT = 137;
    private static final int RIGHT_LIST_BOTTOM = 172;
    private static final int RIGHT_STATE_INFORM_X = 45;
    private static final int RIGHT_STATE_PANEL_Y = 177;

    public void setSlot(int slot) {
        for (TransformType key : this.storage.keySet()) {
            TransformDataNetwork.sendToServerSide(this.blockEntity.m_58899_(), this.slot, key, this.storage.get((Object)key));
        }
        this.storage.clear();
        this.slot = slot;
        this.blockEntity.setSlot(slot);
        for (TransformComponent component : this.panel.values()) {
            component.setSliderInitial(this.blockEntity, this.slot);
        }
        this.shownStateButton.m_168892_((Object)this.blockEntity.getTransformData((int)slot).isShown);
        this.updateStateButtonVisible(true);
    }

    private TransformComponent choose(TransformType type) {
        return this.panel.computeIfAbsent(type, TransformComponent::new);
    }

    public boolean updateStateButtonVisible(boolean force) {
        boolean stateButtonVisible;
        Collection<Property<?>> collection = this.blockStateList.updateRenderProperties(this.getBlockState());
        boolean bl = stateButtonVisible = !collection.isEmpty();
        if (stateButtonVisible && (this.property == null || force)) {
            this.property = collection.iterator().next();
        }
        this.leftStateButton.f_93624_ = stateButtonVisible;
        this.rightStateButton.f_93624_ = stateButtonVisible;
        this.leftPropertyButton.f_93624_ = stateButtonVisible;
        this.rightPropertyButton.f_93624_ = stateButtonVisible;
        return stateButtonVisible;
    }

    public BlockState getBlockState() {
        return this.blockEntity.getTransformData((int)this.slot).blockState;
    }

    public ShowBlockScreen(ShowBlockEntity blockEntity, BlockState newBlockState) {
        super(GameNarrator.f_93310_);
        this.blockEntity = blockEntity;
        this.newBlockState = newBlockState;
        if (blockEntity.getSlot() < blockEntity.getTransformDatas().size()) {
            this.slot = blockEntity.getSlot();
        }
    }

    private int leftColumnX() {
        return this.f_96543_ / 4 * 3 + 10;
    }

    private int leftColumnWidth() {
        return this.f_96543_ / 4 - 20;
    }

    private static int top(int i, int offset) {
        return 40 + 20 * i + offset;
    }

    protected void m_7856_() {
        this.addStateButton = Button.m_253074_((Component)Component.m_237113_((String)"+"), btn -> {
            int chosen = this.blockStateList.getChosenOne();
            if (chosen != -1) {
                this.blockStateList.addSlot();
                this.blockEntity.getTransformDatas().add(new TransformData());
                this.updateTransformDataServerImmediate(this.blockEntity.getTransformData(chosen), this.slot);
                TransformDataNetwork.sendToServerSideSuccess(this.blockEntity.m_58899_());
                this.updateStateButtonVisible(true);
            } else if (this.newBlockState != null) {
                this.blockStateList.addSlot();
                this.updateTransformData(TransformType.BLOCK_STATE, Double.valueOf(Block.m_49956_((BlockState)this.newBlockState)));
                this.updateTransformData(TransformType.SHOWN, 1.0);
                this.updateStateButtonVisible(true);
            }
        }).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.showBlockScreen.display.add"))).m_252987_(2, 10, 20, 20).m_253136_();
        this.removeStateButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00d7"), btn -> {
            this.updateTransformData(TransformType.REMOVE, 0.0);
            this.updateStateButtonVisible(true);
        }).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.showBlockScreen.display.remove"))).m_252987_(22, 10, 20, 20).m_253136_();
        this.replaceButton = Button.m_253074_((Component)Component.m_237113_((String)"\u21c4"), btn -> {
            int chosen = this.blockStateList.getChosenOne();
            if (chosen != -1 && chosen != this.slot) {
                this.updateTransformData(TransformType.BLOCK_STATE, Double.valueOf(Block.m_49956_((BlockState)this.blockEntity.getTransformData((int)chosen).blockState)));
                this.updateStateButtonVisible(true);
            } else {
                this.updateTransformData(TransformType.BLOCK_STATE, Double.valueOf(Block.m_49956_((BlockState)this.newBlockState)));
                this.updateStateButtonVisible(true);
            }
        }).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.showBlockScreen.display.replace"))).m_252987_(42, 10, 20, 20).m_253136_();
        this.shownStateButton = CycleButton.m_168896_((Component)Component.m_237113_((String)"\ud83d\udd76"), (Component)Component.m_237113_((String)"\ud83d\udc40")).m_168929_().m_168948_((Object)true).m_232498_(on -> Tooltip.m_257550_((Component)(on != false ? Component.m_237115_((String)"gui.showBlockScreen.display.on") : Component.m_237115_((String)"gui.showBlockScreen.display.off")))).m_168936_(62, 10, 20, 20, (Component)Component.m_237119_(), (btn, bl) -> this.updateTransformData(TransformType.SHOWN, bl != false ? 1.0 : 0.0));
        this.copyButton = Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udce4").m_130940_(ChatFormatting.BOLD), btn -> {
            String res = ShareUtils.transfer(this.blockEntity.getTransformDatas());
            this.setClipboard(res);
            this.f_96541_.m_91300_().m_94922_((Toast)SystemToast.m_94847_((Minecraft)this.f_96541_, (SystemToast.SystemToastIds)SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237115_((String)"gui.showBlockScreen.workshop.copy_pass"), (Component)Component.m_237115_((String)"gui.showBlockScreen.workshop.share_hint")));
        }).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.showBlockScreen.workshop.copy"))).m_252987_(102, 10, 20, 20).m_253136_();
        this.parseButton = Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udce5").m_130940_(ChatFormatting.BOLD), btn -> {
            String string = this.getClipboard();
            try {
                ShareUtils.ShareInformation shareInformation = ShareUtils.from(string);
                this.checkModLack(shareInformation);
                this.updateAllTransformData(shareInformation);
                this.updateStateButtonVisible(true);
                this.f_96541_.m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237115_((String)"gui.showBlockScreen.workshop.paste_pass"), null));
            }
            catch (Exception e) {
                this.f_96541_.m_91300_().m_94922_((Toast)SystemToast.m_94847_((Minecraft)this.f_96541_, (SystemToast.SystemToastIds)SystemToast.SystemToastIds.PACK_LOAD_FAILURE, (Component)Component.m_237115_((String)"gui.showBlockScreen.workshop.error"), (Component)Component.m_237113_((String)e.getMessage())));
            }
        }).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.showBlockScreen.workshop.paste"))).m_252987_(122, 10, 20, 20).m_253136_();
        this.saveButton = Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udcbe").m_130940_(ChatFormatting.BOLD), btn -> this.f_96541_.m_91152_((Screen)new EditScreen(this, (Component)Component.m_237115_((String)"gui.showBlockScreen.workshop.save"), (Component)Component.m_237115_((String)"gui.showBlockScreen.workshop.save.tip"), string -> {
            if (string != null) {
                String res = ShareUtils.transfer(this.blockEntity.getTransformDatas());
                try {
                    EngraveItemResultLoader.save(res, string);
                    this.f_96541_.m_91300_().m_94922_((Toast)SystemToast.m_94847_((Minecraft)this.f_96541_, (SystemToast.SystemToastIds)SystemToast.SystemToastIds.NARRATOR_TOGGLE, (Component)Component.m_237115_((String)"gui.showBlockScreen.workshop.save_pass"), (Component)Component.m_237115_((String)"gui.showBlockScreen.workshop.share_hint")));
                }
                catch (IOException e) {
                    this.f_96541_.m_91300_().m_94922_((Toast)SystemToast.m_94847_((Minecraft)this.f_96541_, (SystemToast.SystemToastIds)SystemToast.SystemToastIds.PACK_LOAD_FAILURE, (Component)Component.m_237115_((String)"gui.showBlockScreen.workshop.save_error"), (Component)Component.m_237113_((String)e.getMessage())));
                }
                this.f_96541_.m_91152_((Screen)this);
            } else {
                this.f_96541_.m_91152_((Screen)this);
            }
        }, string -> true))).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.showBlockScreen.workshop.save"))).m_252987_(142, 10, 20, 20).m_253136_();
        this.blockStateList = new BlockStateIconList(this.f_96541_, 40, 137, 2, 35, 172, 40, 45, this.blockEntity.getTransformDatas(), this);
        this.leftPropertyButton = Button.m_253074_((Component)Component.m_237113_((String)"<"), btn -> {
            this.property = YuushyaBlockStates.getRelative(this.blockStateList.updateRenderProperties(this.getBlockState()), this.property, true);
        }).m_252987_(2, 177, 10, 20).m_253136_();
        this.rightPropertyButton = Button.m_253074_((Component)Component.m_237113_((String)">"), btn -> {
            this.property = YuushyaBlockStates.getRelative(this.blockStateList.updateRenderProperties(this.getBlockState()), this.property, false);
        }).m_252987_(62, 177, 10, 20).m_253136_();
        this.leftStateButton = Button.m_253074_((Component)Component.m_237113_((String)"<"), btn -> {
            BlockState nextBlockState = YuushyaBlockStates.cycleState(this.getBlockState(), this.property, true);
            this.updateTransformData(TransformType.BLOCK_STATE, Double.valueOf(Block.m_49956_((BlockState)nextBlockState)));
        }).m_252987_(2, 197, 10, 20).m_253136_();
        this.rightStateButton = Button.m_253074_((Component)Component.m_237113_((String)">"), btn -> {
            BlockState nextBlockState = YuushyaBlockStates.cycleState(this.getBlockState(), this.property, true);
            this.updateTransformData(TransformType.BLOCK_STATE, Double.valueOf(Block.m_49956_((BlockState)nextBlockState)));
        }).m_252987_(62, 197, 10, 20).m_253136_();
        this.modeButton = CycleButton.m_168894_(Mode::getSymbol).m_168929_().m_168961_((Object[])Mode.values()).m_168948_((Object)Mode.SLIDER).m_232498_(mode -> Tooltip.m_257550_((Component)(switch (mode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> Component.m_237115_((String)"gui.showBlockScreen.mode.slider.tooltip");
            case 1 -> Component.m_237115_((String)"gui.showBlockScreen.mode.fine_tune.tooltip");
            case 2 -> Component.m_237115_((String)"gui.showBlockScreen.mode.edit.tooltip");
        }))).m_168936_(this.leftColumnX(), 10, this.leftColumnWidth(), 20, (Component)Component.m_237113_((String)"MODE"), (btn, mode) -> {
            switch (mode.ordinal()) {
                case 0: {
                    this.panel.values().forEach(TransformComponent::setSliderStep);
                    break;
                }
                case 1: 
                case 2: {
                    this.panel.values().forEach(TransformComponent::setSliderFineTune);
                }
            }
            switch (mode.ordinal()) {
                case 0: 
                case 1: {
                    this.panel.values().forEach(it -> it.triggerVisible(true));
                    break;
                }
                case 2: {
                    this.panel.values().forEach(it -> it.triggerVisible(false));
                }
            }
        });
        this.choose(TransformType.SCALE_X);
        this.choose((TransformType)TransformType.POS_X).sliderButton = LazyDoubleRange.buttonBuilder((Component)Component.m_237115_((String)"gui.yuushya.showBlockScreen.pos_text"), () -> -PosTransItem.getMaxPos(this.blockEntity.getTransformData((int)this.slot).scales.x), () -> PosTransItem.getMaxPos(this.blockEntity.getTransformData((int)this.slot).scales.x), () -> PosTransItem.getStep(PosTransItem.getMaxPos(this.blockEntity.getTransformData((int)this.slot).scales.x)), number -> this.updateTransformData(TransformType.POS_X, (Double)number)).text((caption, number) -> Component.m_237119_().m_7220_(caption).m_7220_((Component)Component.m_237110_((String)"block.yuushya.showblock.x", (Object[])new Object[]{String.format("%05.1f", number)}).m_130940_(ChatFormatting.DARK_RED))).step(this.choose(TransformType.POS_X).setStandardStep(0.0)).onMouseOver(btn -> {
            this.blockEntity.setShowAxis(Direction.Axis.X);
            this.blockEntity.setShowPosAixs();
        }).initial(TransformType.POS_X.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ShowBlockScreen.top(0, 0), this.leftColumnWidth(), 20).build();
        this.choose((TransformType)TransformType.POS_Y).sliderButton = LazyDoubleRange.buttonBuilder((Component)Component.m_237115_((String)"gui.yuushya.showBlockScreen.pos_text"), () -> -PosTransItem.getMaxPos(this.blockEntity.getTransformData((int)this.slot).scales.y), () -> PosTransItem.getMaxPos(this.blockEntity.getTransformData((int)this.slot).scales.y), () -> PosTransItem.getStep(PosTransItem.getMaxPos(this.blockEntity.getTransformData((int)this.slot).scales.y)), number -> this.updateTransformData(TransformType.POS_Y, (Double)number)).text((caption, number) -> Component.m_237119_().m_7220_(caption).m_7220_((Component)Component.m_237110_((String)"block.yuushya.showblock.y", (Object[])new Object[]{String.format("%05.1f", number)}).m_130940_(ChatFormatting.GREEN))).step(this.choose(TransformType.POS_Y).setStandardStep(0.0)).onMouseOver(btn -> {
            this.blockEntity.setShowAxis(Direction.Axis.Y);
            this.blockEntity.setShowPosAixs();
        }).initial(TransformType.POS_Y.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ShowBlockScreen.top(1, 0), this.leftColumnWidth(), 20).build();
        this.choose((TransformType)TransformType.POS_Z).sliderButton = LazyDoubleRange.buttonBuilder((Component)Component.m_237115_((String)"gui.yuushya.showBlockScreen.pos_text"), () -> -PosTransItem.getMaxPos(this.blockEntity.getTransformData((int)this.slot).scales.z), () -> PosTransItem.getMaxPos(this.blockEntity.getTransformData((int)this.slot).scales.z), () -> PosTransItem.getStep(PosTransItem.getMaxPos(this.blockEntity.getTransformData((int)this.slot).scales.z)), number -> this.updateTransformData(TransformType.POS_Z, (Double)number)).text((caption, number) -> Component.m_237119_().m_7220_(caption).m_7220_((Component)Component.m_237110_((String)"block.yuushya.showblock.z", (Object[])new Object[]{String.format("%05.1f", number)}).m_130940_(ChatFormatting.BLUE))).step(this.choose(TransformType.POS_Z).setStandardStep(0.0)).onMouseOver(btn -> {
            this.blockEntity.setShowAxis(Direction.Axis.Z);
            this.blockEntity.setShowPosAixs();
        }).initial(TransformType.POS_Z.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ShowBlockScreen.top(2, 0), this.leftColumnWidth(), 20).build();
        this.choose((TransformType)TransformType.ROT_X).sliderButton = DoubleRange.buttonBuilder((Component)Component.m_237115_((String)"gui.yuushya.showBlockScreen.rot_text"), 0.0, 360.0, number -> this.updateTransformData(TransformType.ROT_X, (Double)number)).text((caption, number) -> Component.m_237119_().m_7220_(caption).m_7220_((Component)Component.m_237110_((String)"block.yuushya.showblock.x", (Object[])new Object[]{String.format("%05.1f", number)}).m_130940_(ChatFormatting.DARK_RED))).step(this.choose(TransformType.ROT_X).setStandardStep(22.5)).onMouseOver(btn -> {
            this.blockEntity.setShowAxis(Direction.Axis.X);
            this.blockEntity.setShowRotAixs();
        }).initial(TransformType.ROT_X.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ShowBlockScreen.top(3, 10), this.leftColumnWidth(), 20).build();
        this.choose((TransformType)TransformType.ROT_Y).sliderButton = DoubleRange.buttonBuilder((Component)Component.m_237115_((String)"gui.yuushya.showBlockScreen.rot_text"), 0.0, 360.0, number -> this.updateTransformData(TransformType.ROT_Y, (Double)number)).text((caption, number) -> Component.m_237119_().m_7220_(caption).m_7220_((Component)Component.m_237110_((String)"block.yuushya.showblock.y", (Object[])new Object[]{String.format("%05.1f", number)}).m_130940_(ChatFormatting.GREEN))).step(this.choose(TransformType.ROT_Y).setStandardStep(22.5)).onMouseOver(btn -> {
            this.blockEntity.setShowAxis(Direction.Axis.Y);
            this.blockEntity.setShowRotAixs();
        }).initial(TransformType.ROT_Y.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ShowBlockScreen.top(4, 10), this.leftColumnWidth(), 20).build();
        this.choose((TransformType)TransformType.ROT_Z).sliderButton = DoubleRange.buttonBuilder((Component)Component.m_237115_((String)"gui.yuushya.showBlockScreen.rot_text"), 0.0, 360.0, number -> this.updateTransformData(TransformType.ROT_Z, (Double)number)).text((caption, number) -> Component.m_237119_().m_7220_(caption).m_7220_((Component)Component.m_237110_((String)"block.yuushya.showblock.z", (Object[])new Object[]{String.format("%05.1f", number)}).m_130940_(ChatFormatting.BLUE))).step(this.choose(TransformType.ROT_Z).setStandardStep(22.5)).onMouseOver(btn -> {
            this.blockEntity.setShowAxis(Direction.Axis.Z);
            this.blockEntity.setShowRotAixs();
        }).initial(TransformType.ROT_Z.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ShowBlockScreen.top(5, 10), this.leftColumnWidth(), 20).build();
        this.choose((TransformType)TransformType.SCALE_X).sliderButton = DividedDoubleRange.buttonBuilder((Component)Component.m_237119_(), 0.0, 1.0, 10.0, number -> {
            this.updateTransformData(TransformType.SCALE_X, (Double)number);
            this.updateTransformData(TransformType.SCALE_Y, (Double)number);
            this.updateTransformData(TransformType.SCALE_Z, (Double)number);
            this.choose((TransformType)TransformType.POS_X).sliderButton.setValidatedValue(this.choose((TransformType)TransformType.POS_X).sliderButton.getValidatedValue());
            this.choose((TransformType)TransformType.POS_Y).sliderButton.setValidatedValue(this.choose((TransformType)TransformType.POS_Y).sliderButton.getValidatedValue());
            this.choose((TransformType)TransformType.POS_Z).sliderButton.setValidatedValue(this.choose((TransformType)TransformType.POS_Z).sliderButton.getValidatedValue());
        }).text((caption, number) -> Component.m_237110_((String)"gui.yuushya.showBlockScreen.scale_text", (Object[])new Object[]{String.format("%05.1f", number)})).step(this.choose(TransformType.SCALE_X).setStandardStep(0.1)).initial(TransformType.SCALE_X.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ShowBlockScreen.top(6, 20), this.leftColumnWidth(), 20).build();
        this.choose((TransformType)TransformType.LIT).sliderButton = DoubleRange.buttonBuilder((Component)Component.m_237115_((String)"gui.yuushya.showBlockScreen.brightness_text"), 0.0, 15.0, number -> this.updateTransformData(TransformType.LIT, (Double)number)).text(LazyDoubleRange::captionToString).step(this.choose(TransformType.LIT).setStandardStep(1.0)).initial(TransformType.LIT.extract(this.blockEntity, this.slot)).bounds(this.leftColumnX(), ShowBlockScreen.top(7, 30), this.leftColumnWidth(), 20).build();
        for (TransformComponent component : this.panel.values()) {
            component.initWidget(this.f_96547_);
            this.m_142416_((GuiEventListener)component.sliderButton);
            this.m_142416_((GuiEventListener)component.minusButton);
            this.m_142416_((GuiEventListener)component.addButton);
            this.m_142416_((GuiEventListener)component.editBox);
            this.m_142416_((GuiEventListener)component.cancelButton);
            this.m_142416_((GuiEventListener)component.finishButton);
        }
        this.m_142416_((GuiEventListener)this.modeButton);
        this.m_7787_((GuiEventListener)this.blockStateList);
        this.m_142416_((GuiEventListener)this.addStateButton);
        this.m_142416_((GuiEventListener)this.removeStateButton);
        this.m_142416_((GuiEventListener)this.replaceButton);
        this.m_142416_((GuiEventListener)this.shownStateButton);
        this.m_142416_((GuiEventListener)this.leftPropertyButton);
        this.m_142416_((GuiEventListener)this.rightPropertyButton);
        this.m_142416_((GuiEventListener)this.leftStateButton);
        this.m_142416_((GuiEventListener)this.rightStateButton);
        this.m_142416_((GuiEventListener)this.copyButton);
        this.m_142416_((GuiEventListener)this.parseButton);
        this.m_142416_((GuiEventListener)this.saveButton);
        this.blockStateList.setSelectedSlot(this.slot);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.blockStateList.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        BlockState blockState = this.getBlockState();
        guiGraphics.m_280614_(this.f_96547_, (Component)this.blockStateList.updateRenderDisplayName(blockState), 45, 36, -1, false);
        List<String> properties = this.blockStateList.updateRenderBlockStateProperties(blockState);
        for (int i = 0; i < properties.size(); ++i) {
            MutableComponent displayBlockState = Component.m_237113_((String)properties.get(i));
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280614_(this.f_96547_, (Component)displayBlockState, 45, 36 + 9 * (i + 1) + 1, 16772038, false);
        }
        if (this.updateStateButtonVisible(false)) {
            guiGraphics.m_280056_(this.f_96547_, this.property.m_61708_(), 22, 182, -1, false);
            guiGraphics.m_280056_(this.f_96547_, YuushyaDebugStickItem.getNameHelper(blockState, this.property), 22, 202, -1, false);
        }
        if (this.modeButton.m_168883_() == Mode.EDIT) {
            for (TransformComponent component : this.panel.values()) {
                guiGraphics.m_280430_(this.f_96547_, component.editBox.m_6035_(), component.editBox.m_252754_() + component.editBox.m_5711_() / 2, component.editBox.m_252907_() + component.editBox.m_93694_() / 3, 0x707070);
                component.editBox.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            }
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void m_86600_() {
        for (TransformComponent component : this.panel.values()) {
            component.editBox.m_94120_();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7861_() {
        for (TransformType key : this.storage.keySet()) {
            TransformDataNetwork.sendToServerSide(this.blockEntity.m_58899_(), this.slot, key, this.storage.get((Object)key));
        }
        this.storage.clear();
        TransformDataNetwork.sendToServerSideSuccess(this.blockEntity.m_58899_());
    }

    public void checkModLack(ShareUtils.ShareInformation shareInformation) {
        List<String> unLoaded = shareInformation.mods().stream().filter(id -> !Platform.getModIds().contains(id)).toList();
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)SystemToast.m_94847_((Minecraft)Minecraft.m_91087_(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.PACK_LOAD_FAILURE, (Component)Component.m_237113_((String)"Mod Lack"), (Component)Component.m_237113_((String)String.join((CharSequence)", ", unLoaded))));
    }

    private void updateAllTransformData(ShareUtils.ShareInformation shareInformation) {
        int slot;
        List<TransformData> dataList = this.blockEntity.getTransformDatas();
        BlockPos pos = this.blockEntity.m_58899_();
        int currentSize = dataList.size();
        for (int slot2 = 0; slot2 < currentSize; ++slot2) {
            this.blockEntity.removeTransformData(slot2);
            TransformDataNetwork.sendToServerSide(pos, slot2, TransformType.REMOVE, 0.0);
        }
        shareInformation.transfer(dataList);
        int nextSize = dataList.size();
        this.blockEntity.m_58904_().m_7260_(pos, this.blockEntity.m_58900_(), this.blockEntity.m_58900_(), 11);
        this.storage.clear();
        for (slot = 0; slot < nextSize; ++slot) {
            TransformData data = dataList.get(slot);
            this.updateTransformDataServerImmediate(data, slot);
        }
        TransformDataNetwork.sendToServerSideSuccess(pos);
        for (slot = nextSize - 1; slot < currentSize; ++slot) {
            this.blockEntity.setSlot(slot);
        }
        this.blockStateList.updateRenderList();
    }

    private void updateTransformDataServerImmediate(TransformData data, int slot) {
        BlockPos pos = this.blockEntity.m_58899_();
        TransformDataNetwork.sendToServerSide(pos, slot, TransformType.POS_X, data.pos.x);
        TransformDataNetwork.sendToServerSide(pos, slot, TransformType.POS_Y, data.pos.y);
        TransformDataNetwork.sendToServerSide(pos, slot, TransformType.POS_Z, data.pos.z);
        TransformDataNetwork.sendToServerSide(pos, slot, TransformType.ROT_X, data.rot.x);
        TransformDataNetwork.sendToServerSide(pos, slot, TransformType.ROT_Y, data.rot.y);
        TransformDataNetwork.sendToServerSide(pos, slot, TransformType.ROT_Z, data.rot.z);
        TransformDataNetwork.sendToServerSide(pos, slot, TransformType.SCALE_X, data.scales.x);
        TransformDataNetwork.sendToServerSide(pos, slot, TransformType.SCALE_Y, data.scales.y);
        TransformDataNetwork.sendToServerSide(pos, slot, TransformType.SCALE_Z, data.scales.z);
        TransformDataNetwork.sendToServerSide(pos, slot, TransformType.BLOCK_STATE, Block.m_49956_((BlockState)data.blockState));
        TransformDataNetwork.sendToServerSide(pos, slot, TransformType.SHOWN, data.isShown ? 1.0 : 0.0);
    }

    private void updateTransformData(TransformType type, Double number) {
        this.storage.put(type, number);
        type.modify(this.blockEntity, this.slot, number);
        this.blockEntity.m_58904_().m_7260_(this.blockEntity.m_58899_(), this.blockEntity.m_58900_(), this.blockEntity.m_58900_(), 11);
    }

    private void setClipboard(String clipboardValue) {
        if (this.f_96541_ != null) {
            TextFieldHelper.m_95155_((Minecraft)this.f_96541_, (String)clipboardValue);
        }
    }

    private String getClipboard() {
        return this.f_96541_ != null ? TextFieldHelper.m_95169_((Minecraft)this.f_96541_) : "";
    }

    public static final class TransformComponent {
        TransformType type;
        double standardStep;
        double fine_tuneStep = 0.001;
        SliderButton<Double> sliderButton;
        Button minusButton;
        Button addButton;
        EditBox editBox;
        Button cancelButton;
        Button finishButton;

        TransformComponent(TransformType type) {
            this.type = type;
        }

        double setStandardStep(double step) {
            this.standardStep = step;
            return step;
        }

        void setSliderInitial(ShowBlockEntity blockEntity, int slot) {
            double step = this.sliderButton.getStep();
            this.sliderButton.setStep(this.fine_tuneStep);
            this.sliderButton.setInitialValidatedValue(this.type.extract(blockEntity, slot));
            this.sliderButton.setStep(step);
        }

        void setSliderStep() {
            this.sliderButton.setStep(this.standardStep);
        }

        void setSliderFineTune() {
            this.sliderButton.setStep(this.fine_tuneStep);
        }

        void step(boolean increase) {
            if (increase) {
                this.sliderButton.setValidatedValue(this.sliderButton.getValidatedValue() + this.sliderButton.getStep());
            } else {
                this.sliderButton.setValidatedValue(this.sliderButton.getValidatedValue() - this.sliderButton.getStep());
            }
        }

        void setEditBoxInitial() {
            this.editBox.m_94144_(String.valueOf(this.sliderButton.getValidatedValue()));
        }

        void saveEditBoxValue() {
            double number;
            try {
                number = Double.parseDouble(this.editBox.m_94155_());
            }
            catch (NumberFormatException ignored) {
                number = this.sliderButton.getValidatedValue();
            }
            this.sliderButton.setValidatedValue(number);
            this.setEditBoxInitial();
        }

        void triggerVisible(boolean sliderVisible) {
            this.sliderButton.f_93624_ = sliderVisible;
            this.addButton.f_93624_ = sliderVisible;
            this.minusButton.f_93624_ = sliderVisible;
            if (!sliderVisible) {
                this.setEditBoxInitial();
            }
            this.editBox.m_94194_(!sliderVisible);
            this.finishButton.f_93624_ = !sliderVisible;
            this.cancelButton.f_93624_ = !sliderVisible;
        }

        Component editBoxComponent() {
            MutableComponent component = switch (this.type) {
                case TransformType.POS_X, TransformType.ROT_X -> Component.m_237110_((String)"block.yuushya.showblock.x", (Object[])new Object[]{""}).m_130940_(ChatFormatting.DARK_RED);
                case TransformType.POS_Y, TransformType.ROT_Y -> Component.m_237110_((String)"block.yuushya.showblock.y", (Object[])new Object[]{""}).m_130940_(ChatFormatting.GREEN);
                case TransformType.POS_Z, TransformType.ROT_Z -> Component.m_237110_((String)"block.yuushya.showblock.z", (Object[])new Object[]{""}).m_130940_(ChatFormatting.BLUE);
                case TransformType.SCALE_X -> Component.m_237110_((String)"gui.yuushya.showBlockScreen.scale_text", (Object[])new Object[]{""});
                default -> Component.m_237119_();
            };
            return Component.m_237119_().m_7220_(this.sliderButton.getCaption()).m_7220_((Component)component);
        }

        void initWidget(Font font) {
            this.minusButton = Button.m_253074_((Component)Component.m_237113_((String)"-"), btn -> this.step(false)).m_252987_(this.sliderButton.m_252754_() - 10, this.sliderButton.m_252907_(), 10, 20).m_253136_();
            this.addButton = Button.m_253074_((Component)Component.m_237113_((String)"+"), btn -> this.step(true)).m_252987_(this.sliderButton.m_252754_() + this.sliderButton.m_5711_(), this.sliderButton.m_252907_(), 10, 20).m_253136_();
            this.editBox = new EditBox(font, this.sliderButton.m_252754_(), this.sliderButton.m_252907_(), this.sliderButton.m_5711_(), 20, this.editBoxComponent());
            this.editBox.m_94199_(15);
            this.setEditBoxInitial();
            this.cancelButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00d7"), btn -> this.setEditBoxInitial()).m_252987_(this.sliderButton.m_252754_() - 10, this.sliderButton.m_252907_(), 10, 20).m_253136_();
            this.finishButton = Button.m_253074_((Component)Component.m_237113_((String)"\u221a"), btn -> this.saveEditBoxValue()).m_252987_(this.sliderButton.m_252754_() + this.sliderButton.m_5711_(), this.sliderButton.m_252907_(), 10, 20).m_253136_();
            this.triggerVisible(true);
        }
    }

    public static enum Mode implements StringRepresentable
    {
        SLIDER("slider"),
        FINE_TUNE("fine_tune"),
        EDIT("edit");

        private final String name;
        private final Component symbol;

        private Mode(String name) {
            this.name = name;
            this.symbol = Component.m_237115_((String)("gui.showBlockScreen.mode." + name));
        }

        public String m_7912_() {
            return this.name;
        }

        public Component getSymbol() {
            return this.symbol;
        }
    }
}

