/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui.showblock;

import com.mojang.math.Axis;
import com.yuushya.modelling.blockentity.TransformData;
import com.yuushya.modelling.gui.showblock.ShowBlockScreen;
import com.yuushya.modelling.registries.YuushyaRegistries;
import com.yuushya.modelling.utils.YuushyaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BlockStateIconList
extends ObjectSelectionList<Entry> {
    protected final List<TransformData> transformDataList;
    protected final List<Entry> chosen = new ArrayList<Entry>();
    protected final ShowBlockScreen screen;
    private int itemHeight;
    private int itemWidth;
    private final Map<Integer, MutableComponent> rememberDisplayName = new HashMap<Integer, MutableComponent>();
    private final Map<Integer, List<String>> rememberBlockStateProperties = new HashMap<Integer, List<String>>();
    private final Map<Integer, ItemStack> rememberItemStack = new HashMap<Integer, ItemStack>();
    private final Map<Integer, Collection<Property<?>>> rememberProperties = new HashMap();

    public BlockStateIconList(Minecraft minecraft, int width, int height, int x, int y0, int y1, int itemWidth, int itemHeight, List<TransformData> transformDataList, ShowBlockScreen showBlockScreen) {
        super(minecraft, width, height, y0, y1, itemHeight);
        this.m_93507_(x);
        this.transformDataList = transformDataList;
        this.screen = showBlockScreen;
        this.f_93394_ = false;
        this.m_93496_(false);
        this.m_93488_(false);
        this.itemWidth = itemWidth;
        this.itemHeight = itemHeight;
        this.updateRenderList();
    }

    public MutableComponent updateRenderDisplayName(BlockState blockState) {
        return this.rememberDisplayName.computeIfAbsent(Block.m_49956_((BlockState)blockState), id -> {
            BlockState blockState1 = Block.m_49803_((int)id);
            Item item = blockState1.m_60734_().m_5456_();
            return item == Items.f_41852_ ? blockState1.m_60734_().m_49954_() : (MutableComponent)item.m_7626_(item.m_7968_());
        });
    }

    public List<String> updateRenderBlockStateProperties(BlockState blockState) {
        return this.rememberBlockStateProperties.computeIfAbsent(Block.m_49956_((BlockState)blockState), id -> Block.m_49803_((int)id).m_61148_().entrySet().stream().map(YuushyaUtils.PROPERTY_ENTRY_TO_STRING_FUNCTION).toList());
    }

    public ItemStack updateRenderItemstack(BlockState blockState) {
        return this.rememberItemStack.computeIfAbsent(Block.m_49956_((BlockState)blockState), id -> {
            ItemStack itemStack = ((Item)YuushyaRegistries.ITEMS.get("get_blockstate_item").get()).m_7968_();
            CompoundTag compoundTag = itemStack.m_41784_();
            compoundTag.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)Block.m_49803_((int)id)));
            itemStack.m_41751_(compoundTag);
            return itemStack;
        });
    }

    public Collection<Property<?>> updateRenderProperties(BlockState blockState) {
        return this.rememberProperties.computeIfAbsent(Block.m_49956_((BlockState)blockState), id -> Block.m_49803_((int)id).m_60734_().m_49965_().m_61092_());
    }

    public int m_5759_() {
        return this.itemWidth;
    }

    protected int m_5756_() {
        return this.f_93392_ - 4;
    }

    public void updateRenderList() {
        this.m_93516_();
        for (int i = 0; i < this.transformDataList.size(); ++i) {
            this.m_7085_((AbstractSelectionList.Entry)new Entry(this, i));
        }
        this.notifyListUpdated();
    }

    public void addSlot() {
        if (this.m_93511_() != null && this.transformDataList.get((int)((Entry)this.m_93511_()).slot).blockState.m_60734_() == Blocks.f_50016_) {
            return;
        }
        if (this.m_6702_().size() == this.transformDataList.size()) {
            Entry entry = new Entry(this, this.transformDataList.size());
            this.m_7085_((AbstractSelectionList.Entry)entry);
            this.setSelected(entry);
        }
    }

    private void notifyListUpdated() {
    }

    public void setSelectedSlot(int slot) {
        this.setSelected((Entry)((Object)this.m_6702_().get(slot)));
    }

    public void setSelected(@Nullable Entry selected) {
        super.m_6987_((AbstractSelectionList.Entry)selected);
        if (selected != null) {
            this.screen.setSlot(selected.slot);
        }
    }

    public int getChosenOne() {
        if (!this.chosen.isEmpty()) {
            return this.chosen.get((int)(this.chosen.size() - 1)).slot;
        }
        return -1;
    }

    public void setChosenCurrent() {
        Entry selected = (Entry)this.m_93511_();
        if (selected != null) {
            selected.chosen = true;
            this.chosen.add(selected);
        }
    }

    public void clearChosen() {
        for (Entry entry : this.chosen) {
            entry.chosen = false;
        }
        this.chosen.clear();
    }

    public static final class Entry
    extends ObjectSelectionList.Entry<Entry> {
        private final BlockStateIconList parent;
        private final int slot;
        private final Minecraft minecraft;
        private boolean chosen = false;

        public TransformData getTransformData() {
            return this.parent.transformDataList.size() > this.slot ? this.parent.transformDataList.get(this.slot) : new TransformData();
        }

        public BlockState updateRenderState() {
            return this.parent.transformDataList.size() > this.slot ? this.parent.transformDataList.get((int)this.slot).blockState : Blocks.f_50016_.m_49966_();
        }

        public boolean updateRenderShown() {
            return this.parent.transformDataList.size() > this.slot ? this.parent.transformDataList.get((int)this.slot).isShown : true;
        }

        public Entry(BlockStateIconList parent, int slot) {
            this.parent = parent;
            this.minecraft = parent.f_93386_;
            this.slot = slot;
        }

        public Component m_142172_() {
            BlockState blockState = this.updateRenderState();
            Item item = blockState.m_60734_().m_5456_();
            MutableComponent displayName = item == Items.f_41852_ ? blockState.m_60734_().m_49954_() : (MutableComponent)item.m_7626_(item.m_7968_());
            return displayName;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            Entry preSelected = (Entry)this.parent.m_93511_();
            this.parent.setSelected(this);
            if (preSelected == this) {
                if (this.chosen) {
                    this.chosen = false;
                    this.parent.chosen.remove((Object)this);
                } else {
                    this.chosen = true;
                    this.parent.chosen.add(this);
                }
            }
            return true;
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            BlockState blockState = this.updateRenderState();
            MutableComponent displayName = this.parent.updateRenderDisplayName(blockState);
            Font font = this.minecraft.f_91062_;
            Objects.requireNonNull(font);
            int fontHeight = 9;
            guiGraphics.m_280614_(font, (Component)displayName, left + 3, top + 32, 0xFFFFFF, false);
            if (this.updateRenderShown()) {
                guiGraphics.m_280509_(left, top, left + 32 + 4, top + fontHeight + 32, -1601138544);
            }
            if (this.chosen) {
                guiGraphics.m_280509_(left, top, left + 32 + 4, top + fontHeight + 32, 1608014895);
            }
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)(left + 16), (float)(top + 16), 32.0f);
            guiGraphics.m_280168_().m_85841_(32.0f, 32.0f, 32.0f);
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(180.0f));
            ItemStack itemStack = this.parent.updateRenderItemstack(blockState);
            BakedModel model = this.minecraft.m_91291_().m_174264_(itemStack, (Level)this.minecraft.f_91073_, null, this.minecraft.f_91074_.m_19879_());
            this.minecraft.m_91291_().m_115143_(itemStack, ItemDisplayContext.GUI, false, guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, model);
            guiGraphics.m_280168_().m_85849_();
        }
    }
}

