/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui.engrave;

import com.yuushya.modelling.gui.engrave.EngraveItemResult;
import com.yuushya.modelling.gui.engrave.EngraveMenu;
import com.yuushya.modelling.registries.YuushyaRegistries;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TransformDataListNetwork {
    public static final ResourceLocation TRANSFORM_DATA_LIST_PACKET_ID = new ResourceLocation("yuushya_modelling", "transform_data_list_packet");
    private static final Map<String, ItemStack> HandlingCache = new HashMap<String, ItemStack>();
    public static final Set<String> SendingCache = new HashSet<String>();

    public static void updateSendingCache(String name) {
        SendingCache.remove(name);
    }

    public static void sendToServerSide(EngraveItemResult itemResult) {
        CompoundTag tag;
        String name = itemResult.getName();
        if (SendingCache.contains(name)) {
            tag = new CompoundTag();
        } else {
            ItemStack itemStack = itemResult.getResultItem();
            tag = itemStack.m_41698_("BlockEntityTag");
        }
        tag.m_128359_("ItemName", name);
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        new TransformDataListPacket(tag).encoder(buf);
        NetworkManager.sendToServer((ResourceLocation)TRANSFORM_DATA_LIST_PACKET_ID, (FriendlyByteBuf)buf);
    }

    public static void registerServerSideReceiver() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)TRANSFORM_DATA_LIST_PACKET_ID, (buf, context) -> {
            TransformDataListPacket packet = TransformDataListPacket.decoder(buf);
            packet.handler(() -> context);
        });
    }

    public record TransformDataListPacket(CompoundTag tag) {
        public static TransformDataListPacket decoder(FriendlyByteBuf buf) {
            return new TransformDataListPacket(buf.m_130260_());
        }

        public void encoder(FriendlyByteBuf buf) {
            buf.m_130079_(this.tag);
        }

        public void handler(Supplier<NetworkManager.PacketContext> ctx) {
            ctx.get().queue(() -> {
                Player player = ((NetworkManager.PacketContext)ctx.get()).getPlayer();
                AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                if (abstractContainerMenu instanceof EngraveMenu) {
                    EngraveMenu menu = (EngraveMenu)abstractContainerMenu;
                    if (!menu.m_6875_(player)) {
                        return;
                    }
                    String name = this.tag.m_128461_("ItemName");
                    String hash = player.m_20149_() + name;
                    if (!this.tag.m_128441_("Blocks") && HandlingCache.containsKey(hash)) {
                        menu.setupResultSlotServer(HandlingCache.get(hash));
                    } else {
                        ItemStack itemStack = ((Item)YuushyaRegistries.ITEMS.get("showblock").get()).m_7968_();
                        itemStack.m_41700_("BlockEntityTag", (Tag)this.tag);
                        itemStack.m_41714_((Component)Component.m_237113_((String)name));
                        HandlingCache.put(hash, itemStack);
                        menu.setupResultSlotServer(itemStack);
                    }
                }
            });
        }
    }
}

