/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.gui;

import com.yuushya.modelling.gui.validate.ValidateRange;
import java.util.function.Consumer;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class SliderButton<T extends Comparable<T>>
extends AbstractSliderButton {
    private final OptionInstance.CaptionBasedToString<T> captionBasedToString;
    private final T initialValue;
    private final Component caption;
    private final ValidateRange<T> validateRange;
    private final OptionInstance.TooltipSupplier<T> tooltipSupplier;
    private final Consumer<SliderButton<T>> onMouseOver;
    private final Consumer<T> onValueChanged;

    public Component getCaption() {
        return this.caption;
    }

    public SliderButton(Component caption, int x, int y, int width, int height, OptionInstance.TooltipSupplier<T> tooltipSupplier, OptionInstance.CaptionBasedToString<T> captionBasedToString, ValidateRange<T> validateRange, T initialValue, Consumer<SliderButton<T>> onMouseOver, Consumer<T> onValueChanged) {
        super(x, y, width, height, CommonComponents.f_237098_, validateRange.toSliderValue(initialValue));
        this.caption = caption;
        this.initialValue = initialValue;
        this.validateRange = validateRange;
        this.tooltipSupplier = tooltipSupplier;
        this.captionBasedToString = captionBasedToString;
        this.onMouseOver = onMouseOver;
        this.onValueChanged = onValueChanged;
        this.m_5695_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.f_93622_) {
            this.onMouseOver.accept(this);
        }
    }

    protected void m_5695_() {
        Comparable value = (Comparable)this.validateRange.fromSliderValue(this.f_93577_);
        Comparable object = this.validateRange.validateValue(value).orElseGet(() -> this.initialValue);
        this.m_93666_(this.captionBasedToString.m_231580_(this.caption, (Object)object));
        this.m_257544_(this.tooltipSupplier.m_257630_((Object)object));
    }

    protected void m_5697_() {
        Comparable value = (Comparable)this.validateRange.fromSliderValue(this.f_93577_);
        Comparable object = this.validateRange.validateValue(value).orElseGet(() -> this.initialValue);
        this.onValueChanged.accept(object);
    }

    public static <R extends Comparable<R>> Builder<R> builder(Component caption, ValidateRange<R> validateRange, Consumer<R> onValueChanged) {
        return new Builder<R>(caption, validateRange, onValueChanged);
    }

    public void setValidatedValue(T value) {
        this.setValue(this.validateRange.toSliderValue(value));
    }

    public void setInitialValidatedValue(T value) {
        this.f_93577_ = this.validateRange.toSliderValue(value);
        this.m_5695_();
    }

    public T getValidatedValue() {
        return (T)((Comparable)this.validateRange.fromSliderValue(this.f_93577_));
    }

    public void setValue(double value) {
        double d = this.f_93577_;
        this.f_93577_ = Mth.m_14008_((double)value, (double)0.0, (double)1.0);
        if (d != this.f_93577_) {
            this.m_5697_();
        }
        this.m_5695_();
    }

    public void setStep(T step) {
        this.validateRange.setStep(step);
    }

    public T getStep() {
        return this.validateRange.getStep();
    }

    public static class Builder<R extends Comparable<R>> {
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;
        private OptionInstance.CaptionBasedToString<R> captionBasedToString = (caption, number) -> caption;
        private OptionInstance.TooltipSupplier<R> tooltipSupplier = OptionInstance.m_231498_();
        private R initialValue;
        private final Component caption;
        private final ValidateRange<R> validateRange;
        private final Consumer<R> onValueChanged;
        private Consumer<SliderButton<R>> onMouseOver = btn -> {};
        private R step;

        public Builder(Component caption2, ValidateRange<R> validateRange, Consumer<R> onValueChanged) {
            this.caption = caption2;
            this.onValueChanged = onValueChanged;
            this.validateRange = validateRange;
            this.initialValue = validateRange.defaultValue();
        }

        public Builder<R> pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder<R> width(int width) {
            this.width = width;
            return this;
        }

        public Builder<R> size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder<R> bounds(int x, int y, int width, int height) {
            return this.pos(x, y).size(width, height);
        }

        public Builder<R> text(OptionInstance.CaptionBasedToString<R> textCalculate) {
            this.captionBasedToString = textCalculate;
            return this;
        }

        public Builder<R> tooltip(OptionInstance.TooltipSupplier<R> tooltipSupplier) {
            this.tooltipSupplier = tooltipSupplier;
            return this;
        }

        public Builder<R> onMouseOver(Consumer<SliderButton<R>> onMouseOver) {
            this.onMouseOver = onMouseOver;
            return this;
        }

        public Builder<R> initial(R number) {
            this.initialValue = number;
            return this;
        }

        public Builder<R> step(R step) {
            this.step = step;
            return this;
        }

        public SliderButton<R> build() {
            this.validateRange.setStep(this.step);
            return new SliderButton<R>(this.caption, this.x, this.y, this.width, this.height, this.tooltipSupplier, this.captionBasedToString, this.validateRange, this.initialValue, this.onMouseOver, this.onValueChanged);
        }
    }
}

