/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.forge;

import com.yuushya.modelling.YuushyaClient;
import com.yuushya.modelling.forge.client.ShowBlockModel;
import com.yuushya.modelling.registries.YuushyaRegistries;
import com.yuushya.modelling.utils.YuushyaUtils;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="yuushya_modelling", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class YuushyaClientForge {
    @SubscribeEvent
    public static void onInitializeClient(FMLClientSetupEvent event) {
        YuushyaClient.onInitializeClient();
    }

    @SubscribeEvent
    public static void onModelBaked(ModelEvent.ModifyBakingResult event) {
        ModelResourceLocation inventory = new ModelResourceLocation(new ResourceLocation("yuushya", "showblock"), "inventory");
        event.getModels().put(inventory, new ShowBlockModel(Direction.SOUTH, (BakedModel)event.getModels().get(inventory)));
        for (BlockState blockState : ((Block)YuushyaRegistries.BLOCKS.get("showblock").get()).m_49965_().m_61056_()) {
            ModelResourceLocation stateResourceLocation = BlockModelShaper.m_110895_((BlockState)blockState);
            event.getModels().put(stateResourceLocation, new ShowBlockModel((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_), (BakedModel)event.getModels().get(stateResourceLocation)));
        }
    }

    @SubscribeEvent
    public static void handleBlockColor(RegisterColorHandlersEvent.Block event) {
        event.getBlockColors().m_92589_((state, view, pos, tintIndex) -> {
            if (tintIndex > -1) {
                BlockState trueState = Block.m_49803_((int)(tintIndex >> 8));
                int trueTint = tintIndex & 0xFF;
                return event.getBlockColors().m_92577_(trueState, view, pos, trueTint);
            }
            return -1;
        }, new Block[]{(Block)YuushyaRegistries.SHOW_BLOCK.get()});
    }

    @SubscribeEvent
    public static void handleItemColor(RegisterColorHandlersEvent.Item event) {
        event.getItemColors().m_92689_((itemStack, i) -> {
            CompoundTag compoundTag = itemStack.m_41784_();
            BlockState blockState = YuushyaUtils.readBlockState(compoundTag.m_128469_("BlockState"));
            return event.getBlockColors().m_92577_(blockState, null, null, i);
        }, new ItemLike[]{(ItemLike)YuushyaRegistries.ITEMS.get("get_blockstate_item").get()});
        event.getItemColors().m_92689_((arg, tintIndex) -> {
            if (tintIndex > -1) {
                BlockState trueState = Block.m_49803_((int)(tintIndex >> 8));
                int trueTint = tintIndex & 0xFF;
                return event.getBlockColors().m_92577_(trueState, null, null, trueTint);
            }
            return -1;
        }, new ItemLike[]{(ItemLike)YuushyaRegistries.ITEMS.get("showblock").get()});
    }
}

