/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity.showblock;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.yuushya.modelling.blockentity.TransformData;
import com.yuushya.modelling.utils.YuushyaUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class ShowBlockModel
implements BakedModel,
UnbakedModel {
    protected final Direction facing;
    protected final BakedModel backup;

    public ShowBlockModel(Direction facing) {
        this.facing = facing;
        this.backup = this;
    }

    public ShowBlockModel(Direction facing, BakedModel backup) {
        this.facing = facing;
        this.backup = backup;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, List<TransformData> transformDatas) {
        int vertexSize = YuushyaUtils.vertexSize();
        BlockRenderDispatcher blockRenderDispatcher = Minecraft.m_91087_().m_91289_();
        ArrayList<BakedQuad> finalQuads = new ArrayList<BakedQuad>();
        if (side != null) {
            return Collections.emptyList();
        }
        ArrayList<Direction> directions = new ArrayList<Direction>(Arrays.asList(Direction.values()));
        directions.add(null);
        float f = this.facing.m_122435_();
        PoseStack stack = new PoseStack();
        stack.m_252880_(0.5f, 0.5f, 0.5f);
        stack.m_252781_(Axis.f_252436_.m_252977_(-f));
        stack.m_252880_(-0.5f, -0.5f, -0.5f);
        for (TransformData transformData : transformDatas) {
            if (!transformData.isShown) continue;
            BlockState blockState = transformData.blockState;
            BakedModel blockModel = blockRenderDispatcher.m_110910_(blockState);
            for (Direction value : directions) {
                List blockModelQuads = blockModel.m_213637_(blockState, value, rand);
                for (BakedQuad bakedQuad : blockModelQuads) {
                    int[] vertex = (int[])bakedQuad.m_111303_().clone();
                    stack.m_85836_();
                    YuushyaUtils.scale(stack, transformData.scales);
                    YuushyaUtils.translate(stack, transformData.pos);
                    YuushyaUtils.rotate(stack, transformData.rot);
                    for (int i = 0; i < 4; ++i) {
                        Vector4f vector4f = new Vector4f(Float.intBitsToFloat(vertex[vertexSize * i]), Float.intBitsToFloat(vertex[vertexSize * i + 1]), Float.intBitsToFloat(vertex[vertexSize * i + 2]), 1.0f);
                        stack.m_85850_().m_252922_().transform(vector4f);
                        vertex[vertexSize * i] = Float.floatToRawIntBits(vector4f.x());
                        vertex[vertexSize * i + 1] = Float.floatToRawIntBits(vector4f.y());
                        vertex[vertexSize * i + 2] = Float.floatToRawIntBits(vector4f.z());
                    }
                    stack.m_85849_();
                    if (bakedQuad.m_111305_() > -1) {
                        finalQuads.add(new BakedQuad(vertex, YuushyaUtils.encodeTintWithState(bakedQuad.m_111305_(), blockState), bakedQuad.m_111306_(), bakedQuad.m_173410_(), bakedQuad.m_111307_()));
                        continue;
                    }
                    finalQuads.add(new BakedQuad(vertex, bakedQuad.m_111305_(), bakedQuad.m_111306_(), bakedQuad.m_173410_(), bakedQuad.m_111307_()));
                }
            }
        }
        return finalQuads;
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState blockState, @Nullable Direction side, RandomSource rand) {
        if (this.backup != this) {
            return this.backup.m_213637_(blockState, side, rand);
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        if (this.backup != this) {
            return this.backup.m_7547_();
        }
        return false;
    }

    public boolean m_7539_() {
        if (this.backup != this) {
            return this.backup.m_7539_();
        }
        return true;
    }

    public boolean m_7547_() {
        if (this.backup != this) {
            return this.backup.m_7547_();
        }
        return false;
    }

    public boolean m_7521_() {
        if (this.backup != this) {
            return this.backup.m_7521_();
        }
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        if (this.backup != this) {
            return this.backup.m_6160_();
        }
        return Minecraft.m_91087_().m_91289_().m_110910_(Blocks.f_50075_.m_49966_()).m_6160_();
    }

    public ItemTransforms m_7442_() {
        if (this.backup != this) {
            return this.backup.m_7442_();
        }
        return Minecraft.m_91087_().m_91289_().m_110910_(Blocks.f_50075_.m_49966_()).m_7442_();
    }

    public ItemOverrides m_7343_() {
        if (this.backup != this) {
            return this.backup.m_7343_();
        }
        return ItemOverrides.f_111734_;
    }

    public Collection<ResourceLocation> m_7970_() {
        return Collections.emptyList();
    }

    @Nullable
    public BakedModel m_7611_(ModelBaker modelBakery, Function<Material, TextureAtlasSprite> function, ModelState modelState, ResourceLocation resourceLocation) {
        return this;
    }

    public void m_5500_(Function<ResourceLocation, UnbakedModel> function) {
    }
}

