/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity.showblock;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.yuushya.modelling.blockentity.TransformData;
import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import com.yuushya.modelling.utils.YuushyaUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3d;

public class ShowBlockEntityRender
implements BlockEntityRenderer<ShowBlockEntity> {
    private final Font font;
    public static final Vector3d MIDDLE = new Vector3d(8.0, 8.0, 8.0);
    public static final Vector3d _MIDDLE = new Vector3d(-8.0, -8.0, -8.0);

    public ShowBlockEntityRender(BlockEntityRendererProvider.Context context) {
        this.font = context.m_173586_();
    }

    public void render(ShowBlockEntity blockEntity, float tickDelta, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource multiBufferSource, int light, int overlay) {
        if (blockEntity.showFrame()) {
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110504_());
            LevelRenderer.m_109621_((PoseStack)matrixStack, (VertexConsumer)vertexConsumer, (double)-0.01, (double)-0.01, (double)-0.01, (double)1.01, (double)1.01, (double)1.01, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
            blockEntity.consumeShowFrame();
        }
        if (blockEntity.showRotAxis() || blockEntity.showPosAxis() || blockEntity.showText()) {
            TransformData transformData = blockEntity.getTransFormDataNow();
            if (transformData.isShown && (blockEntity.showPosAxis() || blockEntity.showRotAxis())) {
                matrixStack.m_85836_();
                Direction facing = (Direction)blockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
                float f = facing.m_122435_();
                matrixStack.m_252880_(0.5f, 0.5f, 0.5f);
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(-f));
                matrixStack.m_252880_(-0.5f, -0.5f, -0.5f);
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferBuilder = tesselator.m_85915_();
                RenderSystem.setShader(GameRenderer::m_172757_);
                RenderSystem.depthMask((boolean)true);
                RenderSystem.disableCull();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.lineWidth((float)8.0f);
                bufferBuilder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
                YuushyaUtils.translateAfterScale(matrixStack, transformData.pos, transformData.scales);
                YuushyaUtils.translate(matrixStack, MIDDLE);
                boolean showRotAxis = blockEntity.showRotAxis();
                int redX = 1692817990;
                int greenY = 1688263770;
                int blueZ = 1683666140;
                if (blockEntity.getShowAxis() != null) {
                    switch (blockEntity.getShowAxis()) {
                        case X: {
                            redX = -1680826;
                            break;
                        }
                        case Y: {
                            greenY = -6235046;
                            break;
                        }
                        case Z: {
                            blueZ = -10832676;
                        }
                    }
                }
                if (showRotAxis) {
                    matrixStack.m_252781_(Axis.f_252403_.m_252977_(transformData.rot.z()));
                }
                bufferBuilder.m_252986_(matrixStack.m_85850_().m_252922_(), 0.0f, 0.0f, -1.5f).m_193479_(blueZ).m_5601_(0.0f, 0.0f, 1.5f).m_5752_();
                bufferBuilder.m_252986_(matrixStack.m_85850_().m_252922_(), 0.0f, 0.0f, 1.5f).m_193479_(blueZ).m_5601_(0.0f, 0.0f, 1.5f).m_5752_();
                if (showRotAxis) {
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_(transformData.rot.y()));
                }
                bufferBuilder.m_252986_(matrixStack.m_85850_().m_252922_(), 0.0f, -1.5f, 0.0f).m_193479_(greenY).m_5601_(0.0f, 1.5f, 0.0f).m_5752_();
                bufferBuilder.m_252986_(matrixStack.m_85850_().m_252922_(), 0.0f, 1.5f, 0.0f).m_193479_(greenY).m_5601_(0.0f, 1.5f, 0.0f).m_5752_();
                if (showRotAxis) {
                    matrixStack.m_252781_(Axis.f_252529_.m_252977_(transformData.rot.x()));
                }
                bufferBuilder.m_252986_(matrixStack.m_85850_().m_252922_(), -1.5f, 0.0f, 0.0f).m_193479_(redX).m_5601_(1.5f, 0.0f, 0.0f).m_5752_();
                bufferBuilder.m_252986_(matrixStack.m_85850_().m_252922_(), 1.5f, 0.0f, 0.0f).m_193479_(redX).m_5601_(1.5f, 0.0f, 0.0f).m_5752_();
                tesselator.m_85914_();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.disableBlend();
                RenderSystem.enableCull();
                matrixStack.m_85849_();
            }
            if (blockEntity.showText()) {
                matrixStack.m_85836_();
                ShowBlockEntityRender.renderText(this.font, (Component)Component.m_237115_((String)"block.yuushya.showblock.pos_text").m_7220_((Component)Component.m_237110_((String)"block.yuushya.showblock.x", (Object[])new Object[]{String.format("%05.1f", transformData.pos.x)}).m_130940_(ChatFormatting.DARK_RED)).m_7220_((Component)Component.m_237110_((String)"block.yuushya.showblock.y", (Object[])new Object[]{String.format("%05.1f", transformData.pos.y)}).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237110_((String)"block.yuushya.showblock.z", (Object[])new Object[]{String.format("%05.1f", transformData.pos.z)}).m_130940_(ChatFormatting.BLUE)), 0.8f, matrixStack, multiBufferSource, light);
                ShowBlockEntityRender.renderText(this.font, (Component)Component.m_237115_((String)"block.yuushya.showblock.rot_text").m_7220_((Component)Component.m_237110_((String)"block.yuushya.showblock.x", (Object[])new Object[]{String.format("%05.1f", Float.valueOf(transformData.rot.x()))}).m_130940_(ChatFormatting.DARK_RED)).m_7220_((Component)Component.m_237110_((String)"block.yuushya.showblock.y", (Object[])new Object[]{String.format("%05.1f", Float.valueOf(transformData.rot.y()))}).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237110_((String)"block.yuushya.showblock.z", (Object[])new Object[]{String.format("%05.1f", Float.valueOf(transformData.rot.z()))}).m_130940_(ChatFormatting.BLUE)), 0.55f, matrixStack, multiBufferSource, light);
                ShowBlockEntityRender.renderText(this.font, (Component)Component.m_237110_((String)"block.yuushya.showblock.scale_text", (Object[])new Object[]{Float.valueOf(transformData.scales.x())}), 0.3f, matrixStack, multiBufferSource, light);
                float high = 0.3f;
                for (TransformData everyTransformData : blockEntity.getTransformDatas()) {
                    int slot = blockEntity.getTransformDatas().indexOf(everyTransformData);
                    Style style = blockEntity.getSlot() == slot ? Style.f_131099_.m_131140_(ChatFormatting.GOLD).m_131136_(Boolean.valueOf(true)) : (everyTransformData.isShown ? Style.f_131099_.m_131140_(ChatFormatting.WHITE) : Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true)));
                    Block block = everyTransformData.blockState.m_60734_();
                    Item item = block.m_5456_();
                    MutableComponent displayName = item == Items.f_41852_ ? block.m_49954_() : (MutableComponent)item.m_7626_(item.m_7968_());
                    MutableComponent component = Component.m_237110_((String)"block.yuushya.showblock.slot_text", (Object[])new Object[]{String.format("%2d", slot)}).m_7220_((Component)displayName.m_7220_((Component)Component.m_237113_((String)YuushyaUtils.getBlockStateProperties(everyTransformData.blockState))).m_130948_(style));
                    ShowBlockEntityRender.renderText(this.font, (Component)component, high -= 0.25f, matrixStack, multiBufferSource, light);
                }
                matrixStack.m_85849_();
            }
            blockEntity.consumeShow();
            blockEntity.consumeShowAxis();
        }
    }

    public static void renderText(Font font, Component component, float high, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        matrixStack.m_85836_();
        matrixStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        matrixStack.m_252880_(2.0f, 2.0f + high, 1.0f);
        matrixStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        float g = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int backgroundColor = (int)(g * 255.0f) << 24;
        float floatx = (float)(-font.m_92852_((FormattedText)component)) / 2.0f;
        font.m_272077_(component, 0.0f, 0.0f, -1, false, matrix4f, buffer, Font.DisplayMode.SEE_THROUGH, backgroundColor, 0xF000F0);
        matrixStack.m_85849_();
    }
}

