/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity.showblock;

import com.yuushya.modelling.blockentity.ITransformDataInventory;
import com.yuushya.modelling.blockentity.TransformData;
import com.yuushya.modelling.registries.YuushyaRegistries;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ShowBlockEntity
extends BlockEntity
implements ITransformDataInventory {
    private final List<TransformData> transformDatas = new ArrayList<TransformData>();
    private Integer slot;
    private Integer showFrame = 0;
    private Integer showRotAxis = 0;
    private Integer showPosAxis = 0;
    private Integer showText = 0;
    private Direction.Axis showAxis = null;

    @Override
    public List<TransformData> getTransformDatas() {
        return this.transformDatas;
    }

    @NotNull
    public TransformData getTransFormDataNow() {
        return this.getTransformData(this.slot);
    }

    public void removeTransFormDataNow() {
        this.removeTransformData(this.slot);
    }

    public void setTransformDataNow(TransformData transformData) {
        this.setTransformData(this.slot, transformData);
    }

    public void setSlotBlockStateNow(BlockState blockState) {
        this.setSlotBlockState(this.slot, blockState);
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        if (slot >= this.transformDatas.size()) {
            for (int i = slot - this.transformDatas.size() + 1; i > 0; --i) {
                this.transformDatas.add(new TransformData());
            }
        }
        this.slot = slot;
    }

    public boolean showFrame() {
        return this.showFrame > 0;
    }

    public void setShowFrame() {
        this.showFrame = 5;
    }

    public void consumeShowFrame() {
        this.showFrame = this.showFrame < 0 ? 0 : this.showFrame - 1;
    }

    public boolean showRotAxis() {
        return this.showRotAxis > 0;
    }

    public void setShowRotAixs() {
        this.showRotAxis = 5;
    }

    public boolean showPosAxis() {
        return this.showPosAxis > 0;
    }

    public void setShowPosAixs() {
        this.showPosAxis = 5;
    }

    public boolean showText() {
        return this.showText > 0;
    }

    public void setShowText() {
        this.showText = 5;
    }

    public Direction.Axis getShowAxis() {
        return this.showAxis;
    }

    public void setShowAxis(Direction.Axis axis) {
        this.showAxis = axis;
    }

    public void consumeShowAxis() {
        if (this.showRotAxis <= 0 && this.showPosAxis <= 0) {
            this.showAxis = null;
        }
    }

    public void consumeShow() {
        this.showRotAxis = this.showRotAxis < 0 ? 0 : this.showRotAxis - 1;
        this.showPosAxis = this.showPosAxis < 0 ? 0 : this.showPosAxis - 1;
        this.showText = this.showText < 0 ? 0 : this.showText - 1;
    }

    public ShowBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)YuushyaRegistries.SHOW_BLOCK_ENTITY.get(), blockPos, blockState);
        this.transformDatas.add(new TransformData());
        this.slot = 0;
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        ITransformDataInventory.load(compoundTag, this.transformDatas);
        this.slot = compoundTag.m_128445_("ControlSlot");
        if (this.m_58904_() != null && this.m_58904_().f_46443_) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 11);
        }
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        ITransformDataInventory.saveAdditional(compoundTag, this.transformDatas);
        compoundTag.m_128344_("ControlSlot", this.slot.byteValue());
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundTag = super.m_5995_();
        ITransformDataInventory.saveAdditional(compoundTag, this.transformDatas);
        return compoundTag;
    }

    public void saveChanged() {
        this.m_6596_();
        if (this.m_58904_() != null && !this.m_58904_().f_46443_) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 11);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag compoundTag = this.m_5995_();
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, blockEntity -> {
            this.m_183515_(compoundTag);
            return compoundTag;
        });
    }
}

