/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity;

import com.mojang.logging.LogUtils;
import com.yuushya.modelling.blockentity.TransformType;
import com.yuushya.modelling.blockentity.showblock.ShowBlock;
import com.yuushya.modelling.blockentity.showblock.ShowBlockEntity;
import dev.architectury.networking.NetworkChannel;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.slf4j.Logger;

public class TransformDataNetwork {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation TRANSFORM_DATA_PACKET_ID = new ResourceLocation("yuushya_modelling", "transform_data_packet");
    public static final NetworkChannel INSTANCE = NetworkChannel.create((ResourceLocation)TRANSFORM_DATA_PACKET_ID);

    public static void sendToServerSide(BlockPos blockPos, int slot, TransformType type, double number) {
        INSTANCE.sendToServer((Object)new TransformDataOncePacket(blockPos, type, slot, number));
    }

    public static void sendToServerSideSuccess(BlockPos blockPos) {
        TransformDataNetwork.sendToServerSide(blockPos, 0, TransformType.SUCCESS, 0.0);
    }

    public static void registerChannel() {
        INSTANCE.register(TransformDataOncePacket.class, TransformDataOncePacket::encoder, TransformDataOncePacket::decoder, TransformDataOncePacket::handler);
    }

    public static void sendToServerSideLegacy(BlockPos blockPos, int slot, TransformType type, double number) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        new TransformDataOncePacket(blockPos, type, slot, number).encoder(buf);
        NetworkManager.sendToServer((ResourceLocation)TRANSFORM_DATA_PACKET_ID, (FriendlyByteBuf)buf);
    }

    public static void registerServerSideReceiverLegacy() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)TRANSFORM_DATA_PACKET_ID, (buf, context) -> {
            TransformDataOncePacket packet = TransformDataOncePacket.decoder(buf);
            packet.handler(() -> context);
        });
    }

    public record TransformDataOncePacket(BlockPos blockPos, TransformType transformType, int slot, double number) {
        public static TransformDataOncePacket decoder(FriendlyByteBuf buf) {
            return new TransformDataOncePacket(buf.m_130135_(), TransformType.from(buf.readByte()), buf.readByte(), buf.readDouble());
        }

        public void encoder(FriendlyByteBuf buf) {
            buf.m_130064_(this.blockPos);
            buf.writeByte(this.transformType.type);
            buf.writeByte(this.slot);
            buf.writeDouble(this.number);
        }

        public void handler(Supplier<NetworkManager.PacketContext> ctx) {
            ctx.get().queue(() -> {
                ServerLevel serverLevel;
                Level level = ((NetworkManager.PacketContext)ctx.get()).getPlayer().m_9236_();
                if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_46805_(this.blockPos) && serverLevel.m_8055_(this.blockPos).m_60734_() instanceof ShowBlock) {
                    BlockEntity blockEntity = serverLevel.m_7702_(this.blockPos);
                    if (!(blockEntity instanceof ShowBlockEntity)) {
                        return;
                    }
                    ShowBlockEntity showBlockEntity = (ShowBlockEntity)blockEntity;
                    this.transformType.modify(showBlockEntity, this.slot, this.number);
                }
            });
        }
    }
}

