/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity;

import com.yuushya.modelling.utils.YuushyaUtils;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;

public class TransformData {
    public Vector3d pos = new Vector3d(0.0, 0.0, 0.0);
    public Vector3f rot = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f scales = new Vector3f(1.0f, 1.0f, 1.0f);
    public BlockState blockState = Blocks.f_50016_.m_49966_();
    public boolean isShown = false;

    public TransformData() {
    }

    public TransformData(Vector3d pos, Vector3f rot, Vector3f scales, BlockState blockState, boolean isShown) {
        this();
        this.pos.set((Vector3dc)pos);
        this.rot.set(rot.x(), rot.y(), rot.z());
        this.scales.set(scales.x(), scales.y(), scales.z());
        this.blockState = blockState;
        this.isShown = isShown;
    }

    public void set(Vector3d pos, Vector3f rot, Vector3f scales, BlockState blockState, boolean isShown) {
        this.pos.set((Vector3dc)pos);
        this.rot.set(rot.x(), rot.y(), rot.z());
        this.scales.set(scales.x(), scales.y(), scales.z());
        this.blockState = blockState;
        this.isShown = isShown;
    }

    public void set(TransformData old) {
        this.set(old.pos, old.rot, old.scales, old.blockState, old.isShown);
    }

    public void set() {
        this.pos.set(0.0, 0.0, 0.0);
        this.rot.set(0.0f, 0.0f, 0.0f);
        this.scales.set(1.0f, 1.0f, 1.0f);
        this.blockState = Blocks.f_50016_.m_49966_();
        this.isShown = false;
    }

    public void load(CompoundTag compoundTag) {
        ListTag listTagPos = compoundTag.m_128437_("ShowPos", 6);
        ListTag listTagRot = compoundTag.m_128437_("ShowRotation", 5);
        ListTag listTagScales = compoundTag.m_128437_("ShowScales", 5);
        this.pos.set(listTagPos.m_128772_(0), listTagPos.m_128772_(1), listTagPos.m_128772_(2));
        this.rot.set(listTagRot.m_128775_(0), listTagRot.m_128775_(1), listTagRot.m_128775_(2));
        this.scales.set(listTagScales.m_128775_(0), listTagScales.m_128775_(1), listTagScales.m_128775_(2));
        this.isShown = compoundTag.m_128471_("isShown");
        this.blockState = YuushyaUtils.readBlockState(compoundTag.m_128469_("BlockState"));
    }

    public void saveAdditional(CompoundTag compoundTag) {
        compoundTag.m_128365_("ShowPos", (Tag)YuushyaUtils.toListTag(this.pos.x, this.pos.y, this.pos.z));
        compoundTag.m_128365_("ShowRotation", (Tag)YuushyaUtils.toListTag(Float.valueOf(this.rot.x()), Float.valueOf(this.rot.y()), Float.valueOf(this.rot.z())));
        compoundTag.m_128365_("ShowScales", (Tag)YuushyaUtils.toListTag(Float.valueOf(this.scales.x()), Float.valueOf(this.scales.y()), Float.valueOf(this.scales.z())));
        compoundTag.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        compoundTag.m_128365_("isShown", (Tag)ByteTag.m_128273_((boolean)this.isShown));
    }
}

