/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.modelling.blockentity;

import com.yuushya.modelling.blockentity.TransformData;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public interface ITransformDataInventory {
    public List<TransformData> getTransformDatas();

    public static ITransformDataInventory of(List<TransformData> transformDatas) {
        return () -> transformDatas;
    }

    default public int size() {
        return this.getTransformDatas().size();
    }

    default public boolean isEmpty() {
        for (TransformData transformData : this.getTransformDatas()) {
            if (transformData.blockState.m_60734_() instanceof AirBlock) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public TransformData getTransformData(int slot) {
        if (slot < this.size()) {
            return this.getTransformDatas().get(slot);
        }
        return this.getTransformDatas().get(Math.min(this.size() - 1, 0));
    }

    default public void addTransformData(int slot, TransformData transformData) {
        if (slot < this.size()) {
            this.getTransformDatas().add(slot, transformData);
        } else {
            this.getTransformDatas().add(transformData);
        }
    }

    default public void addTransformData(TransformData transformData) {
        this.getTransformDatas().add(transformData);
    }

    default public void removeTransformData(int slot) {
        this.getTransformData(slot).set();
    }

    default public void removeSlotBlockState(int slot) {
        this.getTransformData((int)slot).blockState = Blocks.f_50016_.m_49966_();
    }

    default public void setTransformData(int slot, TransformData transformData) {
        this.getTransformData(slot).set(transformData);
    }

    default public void setSlotBlockState(int slot, BlockState blockState) {
        this.getTransformData((int)slot).blockState = blockState;
    }

    default public void setSlotShown(int slot, boolean isShown) {
        this.getTransformData((int)slot).isShown = isShown;
    }

    default public void clear() {
        this.getTransformDatas().clear();
    }

    public static void load(CompoundTag compoundTag, List<TransformData> transformDatas) {
        ListTag listTag = compoundTag.m_128437_("Blocks", 10);
        if (!transformDatas.isEmpty()) {
            transformDatas.clear();
        }
        for (int index = 0; index < listTag.size(); ++index) {
            TransformData transformData = new TransformData();
            CompoundTag compoundTagTemp = listTag.m_128728_(index);
            transformData.load(compoundTagTemp);
            transformDatas.add(transformData);
        }
        if (transformDatas.isEmpty()) {
            transformDatas.add(new TransformData());
        }
    }

    public static void saveAdditional(CompoundTag compoundTag, List<TransformData> transformDatas) {
        ListTag listTag = new ListTag();
        int index = 0;
        for (TransformData transformData : transformDatas) {
            CompoundTag compoundTagTemp = new CompoundTag();
            compoundTagTemp.m_128344_("Slot", (byte)index);
            transformData.saveAdditional(compoundTagTemp);
            listTag.add((Object)compoundTagTemp);
            ++index;
        }
        if (!listTag.isEmpty()) {
            compoundTag.m_128365_("Blocks", (Tag)listTag);
        }
    }

    public static void saveAdditionalWithoutAir(CompoundTag compoundTag, List<TransformData> transformDatas) {
        ListTag listTag = new ListTag();
        int index = 0;
        for (TransformData transformData : transformDatas) {
            if (!(transformData.blockState.m_60734_() instanceof AirBlock)) {
                CompoundTag compoundTagTemp = new CompoundTag();
                compoundTagTemp.m_128344_("Slot", (byte)index);
                transformData.saveAdditional(compoundTagTemp);
                listTag.add((Object)compoundTagTemp);
            }
            ++index;
        }
        if (!listTag.isEmpty()) {
            compoundTag.m_128365_("Blocks", (Tag)listTag);
        }
    }
}

