/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.registries;

import com.google.common.base.Suppliers;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YuushyaDeferredRegister<T> {
    private final Map<String, RegistrySupplier<T>> OBJECT_MAP = new LinkedHashMap<String, RegistrySupplier<T>>();
    private static final Supplier<RegistrarManager> REGISTRIES = Suppliers.memoize(() -> RegistrarManager.get((String)"yuushya"));
    private final Registrar<T> REGISTER;

    public YuushyaDeferredRegister(ResourceKey<Registry<T>> key) {
        this.REGISTER = REGISTRIES.get().get(key);
    }

    public <I extends T> RegistrySupplier<T> register(String name, Supplier<I> sup) {
        if (this.OBJECT_MAP.containsKey(name)) {
            return this.OBJECT_MAP.get(name);
        }
        RegistrySupplier registryObject = this.REGISTER.register(new ResourceLocation("yuushya", name), sup);
        this.OBJECT_MAP.put(name, registryObject);
        return registryObject;
    }

    @Nullable
    public T getValue(String name) {
        return (T)this.OBJECT_MAP.get(name).get();
    }

    @Nullable
    public RegistrySupplier<T> get(String name) {
        return this.OBJECT_MAP.get(name);
    }

    @NotNull
    public T getInstanceOrDefault(String name, T defaultObject) {
        RegistrySupplier<T> registryObject = this.get(name);
        if (registryObject == null) {
            return defaultObject;
        }
        return (T)registryObject.get();
    }
}

