/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.item;

import com.yuushya.item.AbstractYuushyaItem;
import com.yuushya.registries.YuushyaRegistries;
import com.yuushya.registries.YuushyaRegistryData;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class TemplateBlockItem
extends AbstractYuushyaItem {
    public String templateType;
    private final YuushyaRegistryData.Block block;
    private final List<YuushyaRegistryData.Block> usageList;

    public TemplateBlockItem(Item.Properties properties, Integer tipLines, String templateType) {
        super(properties, tipLines);
        this.templateType = templateType;
        this.block = YuushyaRegistries.BlockTemplate.get(templateType);
        this.usageList = YuushyaRegistries.getTemplateUsageList(this.block);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(usedHand));
        }
        ItemStack itemStack = player.m_21120_(usedHand).m_41777_();
        if (player.m_7500_()) {
            player.m_21008_(usedHand, ItemStack.f_41583_);
        } else {
            player.m_21120_(usedHand).m_41764_(0);
        }
        player.m_5893_(this.getMenuProvider(level, player.m_20183_(), itemStack));
        player.m_36220_(Stats.f_12978_);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(usedHand));
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        Player player = useOnContext.m_43723_();
        Level level = useOnContext.m_43725_();
        InteractionHand hand = useOnContext.m_43724_();
        BlockPos blockPos = useOnContext.m_8083_();
        if (hand == InteractionHand.MAIN_HAND) {
            ItemStack itemStackOffHand = player.m_21120_(InteractionHand.OFF_HAND);
            if (!itemStackOffHand.m_41619_()) {
                Item item = itemStackOffHand.m_41720_();
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    ResourceLocation resourceLocation = BuiltInRegistries.f_256975_.m_7981_((Object)blockItem.m_40614_());
                    if (resourceLocation.m_135827_().equals("yuushya")) {
                        YuushyaRegistryData.Block blockFind = YuushyaRegistries.BlockALL.get(resourceLocation.m_135815_());
                        if (blockFind != null && this.usageList.contains(blockFind)) {
                            BlockItem replaceBlockItem = (BlockItem)YuushyaRegistries.ITEMS.get(this.templateType + "_" + resourceLocation.m_135815_()).get();
                            return replaceBlockItem.m_6225_(useOnContext);
                        }
                    } else {
                        YuushyaRegistryData.Block blockFind = YuushyaRegistries.BlockRemain.get(resourceLocation.toString());
                        if (blockFind != null && this.usageList.contains(blockFind)) {
                            BlockItem replaceBlockItem = (BlockItem)YuushyaRegistries.ITEMS.get(this.templateType + "_" + resourceLocation.m_135815_()).get();
                            return replaceBlockItem.m_6225_(useOnContext);
                        }
                    }
                }
            } else {
                if (level.f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                ItemStack itemStack = player.m_21120_(hand).m_41777_();
                if (player.m_7500_()) {
                    player.m_21008_(hand, ItemStack.f_41583_);
                } else {
                    player.m_21120_(hand).m_41764_(0);
                }
                player.m_5893_(this.getMenuProvider(level, player.m_20183_(), itemStack));
                player.m_36220_(Stats.f_12978_);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public static StonecutterMenu getStonecutterMenu(int i, Inventory inventory, Level level, BlockPos pos, final ItemStack itemStack) {
        return new StonecutterMenu(i, inventory, ContainerLevelAccess.m_39289_((Level)level, (BlockPos)pos)){
            {
                super(containerId, playerInventory, access);
                this.m_38853_(0).m_5852_(itemStack);
            }

            public boolean m_6875_(Player _player) {
                return !this.f_40284_.m_8020_(0).m_41619_();
            }
        };
    }

    public MenuProvider getMenuProvider(Level level, BlockPos pos, ItemStack itemStack) {
        return new SimpleMenuProvider((i, inventory, _player) -> TemplateBlockItem.getStonecutterMenu(i, inventory, level, pos, itemStack), this.m_41466_());
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        NonNullList nonNullList = NonNullList.m_122779_();
        for (YuushyaRegistryData.Block block : this.usageList) {
            ResourceLocation resourceLocation = block.classType.equals("remain") ? new ResourceLocation(block.name) : new ResourceLocation("yuushya", block.name);
            nonNullList.add((Object)((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation("yuushya", this.block.name + "_" + resourceLocation.m_135815_()))).m_5456_().m_7968_());
        }
        return Optional.of(new BundleTooltip(nonNullList, nonNullList.size()));
    }

    @Override
    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltips, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, tooltips, tooltipFlag);
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }
}

