/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.item;

import com.yuushya.registries.YuushyaRegistryData;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class FoodItem
extends BlockItem {
    private ResourceLocation finishedItem = null;

    public FoodItem(Block block, YuushyaRegistryData.Block yuushyaBlock, Item.Properties properties) {
        super(block, properties.m_41489_(FoodItem.foodProperties(yuushyaBlock)));
        if (yuushyaBlock.properties != null && yuushyaBlock.properties.food != null && yuushyaBlock.properties.food.finishedItem != null) {
            this.finishedItem = new ResourceLocation(yuushyaBlock.properties.food.finishedItem);
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player.m_36341_()) {
            return super.m_6225_(context);
        }
        InteractionResultHolder<ItemStack> result = this.m_7203_(context.m_43725_(), player, context.m_43724_());
        return result.m_19089_();
    }

    public static FoodProperties foodProperties(YuushyaRegistryData.Block block) {
        int forms = 1;
        if (block.blockstate != null && block.blockstate.forms != null) {
            forms = block.blockstate.forms.size();
        }
        if (block.properties != null && block.properties.food != null) {
            YuushyaRegistryData.Item.Properties.Food food = block.properties.food;
            return new FoodProperties.Builder().m_38760_(food.nutrition * forms).m_38758_(food.saturation * (float)forms).m_38767_();
        }
        return Foods.f_38810_;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        if (this.m_41472_()) {
            ItemStack itemStack = player.m_21120_(usedHand);
            if (player.m_36391_(this.m_41473_().m_38747_())) {
                player.m_6672_(usedHand);
                return InteractionResultHolder.m_19096_((Object)itemStack);
            }
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(usedHand));
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        ItemStack itemStack = super.m_5922_(stack, level, livingEntity);
        if (livingEntity instanceof Player && ((Player)livingEntity).m_150110_().f_35937_) {
            return itemStack;
        }
        if (!level.f_46443_ && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.finishedItem != null && BuiltInRegistries.f_257033_.m_7804_(this.finishedItem)) {
                FoodItem.giveItem((Item)BuiltInRegistries.f_257033_.m_7745_(this.finishedItem), player, 1);
            }
        }
        return itemStack;
    }

    private static void giveItem(Item item, Player player, int count) {
        int maxStackSize = item.m_41459_();
        int currenCount = count;
        int onceGiveCount = Math.min(maxStackSize, currenCount);
        currenCount -= onceGiveCount;
        ItemStack itemStack = new ItemStack((ItemLike)item, count);
        boolean canGive = player.m_150109_().m_36054_(itemStack);
        if (canGive && itemStack.m_41619_()) {
            itemStack.m_41764_(1);
            ItemEntity itemEntity = player.m_36176_(itemStack, false);
            if (itemEntity != null) {
                itemEntity.m_32065_();
            }
            player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
            player.f_36096_.m_38946_();
        } else {
            ItemEntity itemEntity = player.m_36176_(itemStack, false);
            if (itemEntity != null) {
                itemEntity.m_32061_();
                itemEntity.m_266426_(player.m_20148_());
            }
        }
    }
}

