/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.block.blockstate;

import com.yuushya.block.blockstate.ConnectedHorizonState;
import com.yuushya.block.blockstate.HalfSlabState;
import com.yuushya.block.blockstate.PositionDirectionXState;
import com.yuushya.block.blockstate.PositionDirectionZState;
import com.yuushya.block.blockstate.PositionHorizonState;
import com.yuushya.block.blockstate.PositionVerticalState;
import com.yuushya.block.blockstate.ShapeState;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class YuushyaBlockStates {
    public static final EnumProperty<PositionDirectionXState> XPOS = EnumProperty.m_61587_((String)"xpos", PositionDirectionXState.class);
    public static final EnumProperty<PositionDirectionZState> ZPOS = EnumProperty.m_61587_((String)"zpos", PositionDirectionZState.class);
    public static final EnumProperty<PositionVerticalState> YPOS = EnumProperty.m_61587_((String)"ypos", PositionVerticalState.class);
    public static final EnumProperty<PositionHorizonState> POS_HORIZON = EnumProperty.m_61587_((String)"pos", PositionHorizonState.class);
    public static final EnumProperty<PositionVerticalState> POS_VERTICAL = EnumProperty.m_61587_((String)"pos", PositionVerticalState.class);
    public static final EnumProperty<ConnectedHorizonState> FRONT = EnumProperty.m_61587_((String)"front", ConnectedHorizonState.class);
    public static final EnumProperty<ConnectedHorizonState> BACK = EnumProperty.m_61587_((String)"back", ConnectedHorizonState.class);
    public static final EnumProperty<ShapeState> SHAPE = EnumProperty.m_61587_((String)"shape", ShapeState.class);
    public static final IntegerProperty X = IntegerProperty.m_61631_((String)"x", (int)0, (int)11);
    public static final IntegerProperty Y = IntegerProperty.m_61631_((String)"y", (int)0, (int)11);
    public static final IntegerProperty Z = IntegerProperty.m_61631_((String)"z", (int)0, (int)11);
    public static final IntegerProperty FORM8 = IntegerProperty.m_61631_((String)"form", (int)0, (int)7);
    public static final IntegerProperty FORM7 = IntegerProperty.m_61631_((String)"form", (int)0, (int)6);
    public static final IntegerProperty FORM6 = IntegerProperty.m_61631_((String)"form", (int)0, (int)5);
    public static final IntegerProperty FORM5 = IntegerProperty.m_61631_((String)"form", (int)0, (int)4);
    public static final IntegerProperty FORM4 = IntegerProperty.m_61631_((String)"form", (int)0, (int)3);
    public static final IntegerProperty FORM3 = IntegerProperty.m_61631_((String)"form", (int)0, (int)2);
    public static final IntegerProperty FORM2 = IntegerProperty.m_61631_((String)"form", (int)0, (int)1);
    public static final IntegerProperty LIT = IntegerProperty.m_61631_((String)"lit", (int)0, (int)15);
    public static final IntegerProperty DISTANCE = IntegerProperty.m_61631_((String)"distance", (int)0, (int)15);
    public static final BooleanProperty ISEND = BooleanProperty.m_61465_((String)"isend");
    public static final BooleanProperty ISHUB = BooleanProperty.m_61465_((String)"ishub");
    public static final EnumProperty<HalfSlabState> HS_TYPE = EnumProperty.m_61587_((String)"type", HalfSlabState.class);
    public static final EnumProperty<HalfSlabState> HS_OTHER = EnumProperty.m_61587_((String)"other", HalfSlabState.class);

    public static Property<?> forms(int n) {
        return switch (n) {
            case 2 -> FORM2;
            case 3 -> FORM3;
            case 4 -> FORM4;
            case 5 -> FORM5;
            case 6 -> FORM6;
            case 7 -> FORM7;
            default -> FORM8;
        };
    }

    public static int getFormMax(IntegerProperty form) {
        if (form == FORM2) {
            return 2;
        }
        if (form == FORM3) {
            return 3;
        }
        if (form == FORM4) {
            return 4;
        }
        if (form == FORM5) {
            return 5;
        }
        if (form == FORM6) {
            return 6;
        }
        if (form == FORM7) {
            return 7;
        }
        if (form == FORM8) {
            return 8;
        }
        return 1;
    }

    public static Property<?> toBlockStateProperty(String name) {
        return switch (name) {
            case "xpos" -> XPOS;
            case "zpos" -> ZPOS;
            case "pos_horizon" -> POS_HORIZON;
            case "pos_vertical" -> POS_VERTICAL;
            case "form" -> FORM8;
            case "powered" -> BlockStateProperties.f_61448_;
            case "face" -> BlockStateProperties.f_61376_;
            case "horizontal_facing" -> BlockStateProperties.f_61374_;
            case "facing" -> BlockStateProperties.f_61372_;
            case "ishub" -> ISHUB;
            case "shape" -> SHAPE;
            case "front" -> FRONT;
            case "back" -> BACK;
            default -> throw new IllegalStateException("Unexpected value: " + name);
        };
    }

    public static BlockState getDefaultBlockState(BlockState defaultState) {
        List properties = (List)defaultState.m_60734_().m_49965_().m_61092_();
        if (properties.contains(BlockStateProperties.f_61448_)) {
            defaultState = (BlockState)defaultState.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false));
        }
        if (properties.contains(BlockStateProperties.f_61372_)) {
            defaultState = (BlockState)defaultState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH);
        }
        if (properties.contains(BlockStateProperties.f_61376_)) {
            defaultState = (BlockState)defaultState.m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)AttachFace.FLOOR);
        }
        if (properties.contains(BlockStateProperties.f_61374_)) {
            defaultState = (BlockState)defaultState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH);
        }
        if (properties.contains(BlockStateProperties.f_61362_)) {
            defaultState = (BlockState)defaultState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
        }
        if (properties.contains(POS_VERTICAL)) {
            defaultState = (BlockState)defaultState.m_61124_(POS_VERTICAL, (Comparable)((Object)PositionVerticalState.NONE));
        }
        if (properties.contains(YPOS)) {
            defaultState = (BlockState)defaultState.m_61124_(YPOS, (Comparable)((Object)PositionVerticalState.NONE));
        }
        if (properties.contains(POS_HORIZON)) {
            defaultState = (BlockState)defaultState.m_61124_(POS_HORIZON, (Comparable)((Object)PositionHorizonState.NONE));
        }
        if (properties.contains(FRONT)) {
            defaultState = (BlockState)defaultState.m_61124_(FRONT, (Comparable)((Object)ConnectedHorizonState.NONE));
        }
        if (properties.contains(BACK)) {
            defaultState = (BlockState)defaultState.m_61124_(BACK, (Comparable)((Object)ConnectedHorizonState.NONE));
        }
        if (properties.contains(XPOS)) {
            defaultState = (BlockState)defaultState.m_61124_(XPOS, (Comparable)((Object)PositionDirectionXState.NONE));
        }
        if (properties.contains(ZPOS)) {
            defaultState = (BlockState)defaultState.m_61124_(ZPOS, (Comparable)((Object)PositionDirectionZState.NONE));
        }
        if (properties.contains(SHAPE)) {
            defaultState = (BlockState)defaultState.m_61124_(SHAPE, (Comparable)((Object)ShapeState.STRAIGHT));
        }
        return defaultState;
    }

    public static <T extends Comparable<T>> BlockState cycleState(BlockState blockState, Property<T> property, boolean doGetPre) {
        return (BlockState)blockState.m_61124_(property, YuushyaBlockStates.getRelative(property.m_6908_(), blockState.m_61143_(property), doGetPre));
    }

    public static <T> T getRelative(Iterable<T> iterable, @Nullable T object, boolean doGetPre) {
        return (T)(doGetPre ? Util.m_137554_(iterable, object) : Util.m_137466_(iterable, object));
    }
}

