/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.block;

import com.yuushya.block.AbstractYuushyaBlock;
import com.yuushya.block.AbstractYuushyaBlockType;
import com.yuushya.block.AttachmentBlock;
import com.yuushya.block.CableBlock;
import com.yuushya.block.ColumnBlock;
import com.yuushya.block.CompactBlock;
import com.yuushya.block.FaceBlock;
import com.yuushya.block.FoodBlock;
import com.yuushya.block.HalfSlabBlock;
import com.yuushya.block.LineBlock;
import com.yuushya.block.LineCornerBlock;
import com.yuushya.block.LineCrossBlock;
import com.yuushya.block.NormalBlock;
import com.yuushya.block.PoleBlock;
import com.yuushya.block.PoleLineBlock;
import com.yuushya.block.RepeatBlock;
import com.yuushya.block.SnowLayerLikeBlock;
import com.yuushya.block.TriPartBlock;
import com.yuushya.block.TubeBlock;
import com.yuushya.block.blockstate.YuushyaBlockStates;
import com.yuushya.collision.CollisionFileReader;
import com.yuushya.entity.ChairEntityUtils;
import com.yuushya.registries.YuushyaRegistries;
import com.yuushya.registries.YuushyaRegistryData;
import com.yuushya.utils.YuushyaUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YuushyaBlockFactory {
    private static final Map<String, VoxelShape> yuushyaVoxelShapes = new HashMap<String, VoxelShape>();
    private static final Map<String, VoxelShape> yuushyaCollisionShapes = new HashMap<String, VoxelShape>();
    private final AbstractYuushyaBlockType finalKitType;
    private final YuushyaRegistryData.Block yuushyaBlock;

    public static Map<String, VoxelShape> getYuushyaVoxelShapes() {
        return yuushyaVoxelShapes;
    }

    public static Map<String, VoxelShape> getYuushyaCollisionShapes() {
        return yuushyaCollisionShapes;
    }

    public YuushyaBlockFactory(AbstractYuushyaBlockType finalKitType, YuushyaRegistryData.Block yuushyaBlock) {
        this.finalKitType = finalKitType;
        this.yuushyaBlock = yuushyaBlock;
    }

    public static BlockBehaviour.Properties getBlockProperties(BlockBehaviour.Properties blockProperties, YuushyaRegistryData.Block.Properties yuushyaBlockProperties) {
        blockProperties = blockProperties.m_60913_(yuushyaBlockProperties.hardness, yuushyaBlockProperties.resistance);
        if (yuushyaBlockProperties.sound != null && !yuushyaBlockProperties.sound.isEmpty()) {
            blockProperties = blockProperties.m_60918_(YuushyaUtils.toSound(yuushyaBlockProperties.sound));
        }
        if (yuushyaBlockProperties.lightLevel != 0) {
            blockProperties = blockProperties.m_60953_(state -> yuushyaBlockProperties.lightLevel);
        }
        if (!yuushyaBlockProperties.hasCollision) {
            blockProperties = blockProperties.m_60910_();
        }
        if (yuushyaBlockProperties.isDelicate) {
            blockProperties = blockProperties.m_60966_();
        }
        if (!yuushyaBlockProperties.isSolid) {
            blockProperties = blockProperties.m_60955_();
        } else {
            blockProperties.m_280606_();
        }
        return blockProperties;
    }

    public static BlockBehaviour.Properties getBlockProperties(YuushyaRegistryData.Block.Properties yuushyaBlockProperties) {
        if (yuushyaBlockProperties == null) {
            return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_);
        }
        BlockBehaviour.Properties blockProperties = BlockBehaviour.Properties.m_284310_().m_60918_(YuushyaUtils.toSound(yuushyaBlockProperties.material)).m_284180_(YuushyaUtils.toBlockMaterial(yuushyaBlockProperties.material));
        return YuushyaBlockFactory.getBlockProperties(blockProperties, yuushyaBlockProperties);
    }

    private static List<? extends Property<?>> getBlockStateProperties(YuushyaRegistryData.Block.BlockState yuushyaBlockState) {
        if (yuushyaBlockState == null || yuushyaBlockState.states == null) {
            return List.of();
        }
        return yuushyaBlockState.states.stream().map(YuushyaBlockStates::toBlockStateProperty).toList();
    }

    public static Block create(YuushyaRegistryData.Block yuushyaBlock) {
        return YuushyaBlockFactory.create(YuushyaBlockFactory.getBlockProperties(yuushyaBlock.properties), yuushyaBlock);
    }

    public static Block create(BlockBehaviour.Properties properties, final YuushyaRegistryData.Block yuushyaBlock) {
        if (yuushyaBlock.autoGenerated == null) {
            yuushyaBlock.autoGenerated = new YuushyaRegistryData.Block.AutoGenerated();
            yuushyaBlock.autoGenerated.collision = "block";
        }
        AbstractYuushyaBlockType kitType = null;
        if (yuushyaBlock.blockstate.kit != null && !yuushyaBlock.blockstate.kit.isEmpty()) {
            switch (yuushyaBlock.blockstate.kit) {
                case "normal": {
                    kitType = new NormalBlock();
                    break;
                }
                case "attachment": {
                    kitType = new AttachmentBlock();
                    break;
                }
                case "line": {
                    kitType = new LineBlock();
                    break;
                }
                case "line_corner": {
                    kitType = new LineCornerBlock();
                    break;
                }
                case "face": {
                    kitType = new FaceBlock();
                    break;
                }
                case "pole": {
                    kitType = new PoleBlock();
                    break;
                }
                case "tri_part": {
                    kitType = new TriPartBlock();
                    break;
                }
                case "tube": {
                    kitType = new TubeBlock();
                    break;
                }
                case "compact": {
                    kitType = new CompactBlock();
                    break;
                }
                case "column": {
                    kitType = new ColumnBlock();
                    break;
                }
                case "pole_line": {
                    kitType = new PoleLineBlock();
                    break;
                }
                case "repeat": {
                    kitType = new RepeatBlock();
                    break;
                }
                case "line_cross": 
                case "line_cross_simple": {
                    kitType = new LineCrossBlock();
                    break;
                }
                case "block": {
                    break;
                }
                case "VanillaSlabBlock": {
                    return new SlabBlock(properties){

                        public void m_5871_(@NotNull ItemStack itemStack, @Nullable BlockGetter blockGetter, @NotNull List<Component> tooltips, @NotNull TooltipFlag tooltipFlag) {
                            for (int i = 1; i <= yuushyaBlock.properties.lines; ++i) {
                                tooltips.add((Component)Component.m_237115_((String)(this.m_7705_() + ".line" + i)));
                            }
                        }
                    };
                }
                case "HalfSlabBlock": {
                    return new HalfSlabBlock(properties){

                        public void m_5871_(@NotNull ItemStack itemStack, @Nullable BlockGetter blockGetter, @NotNull List<Component> tooltips, @NotNull TooltipFlag tooltipFlag) {
                            for (int i = 1; i <= yuushyaBlock.properties.lines; ++i) {
                                tooltips.add((Component)Component.m_237115_((String)(this.m_7705_() + ".line" + i)));
                            }
                        }
                    };
                }
                case "VanillaDoorBlock": {
                    return new DoorBlock(properties, YuushyaUtils.toBlockSetType(yuushyaBlock.properties)){

                        public void m_5871_(@NotNull ItemStack itemStack, @Nullable BlockGetter blockGetter, @NotNull List<Component> tooltips, @NotNull TooltipFlag tooltipFlag) {
                            for (int i = 1; i <= yuushyaBlock.properties.lines; ++i) {
                                tooltips.add((Component)Component.m_237115_((String)(this.m_7705_() + ".line" + i)));
                            }
                        }
                    };
                }
                case "VanillaStairBlock": {
                    BlockState blockState = Blocks.f_50705_.m_49966_();
                    if (yuushyaBlock.properties.parent != null) {
                        blockState = yuushyaBlock.properties.parent.contains(":") ? ((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(yuushyaBlock.properties.parent))).m_49966_() : ((Block)YuushyaRegistries.BLOCKS.get(yuushyaBlock.properties.parent).get()).m_49966_();
                    }
                    return new StairBlock(blockState, properties){

                        public void m_5871_(@NotNull ItemStack itemStack, @Nullable BlockGetter blockGetter, @NotNull List<Component> tooltips, @NotNull TooltipFlag tooltipFlag) {
                            for (int i = 1; i <= yuushyaBlock.properties.lines; ++i) {
                                tooltips.add((Component)Component.m_237115_((String)(this.m_7705_() + ".line" + i)));
                            }
                        }
                    };
                }
                case "VanillaSnowLayerBlock": {
                    return new SnowLayerLikeBlock(properties){

                        public void m_5871_(@NotNull ItemStack itemStack, @Nullable BlockGetter blockGetter, @NotNull List<Component> tooltips, @NotNull TooltipFlag tooltipFlag) {
                            for (int i = 1; i <= yuushyaBlock.properties.lines; ++i) {
                                tooltips.add((Component)Component.m_237115_((String)(this.m_7705_() + ".line" + i)));
                            }
                        }
                    };
                }
            }
        }
        switch (yuushyaBlock.classType) {
            case "CableBlock": {
                return new CableBlock(properties, yuushyaBlock.properties.lines, "CableBlock");
            }
            case "": {
                return new Block(properties);
            }
        }
        if (yuushyaBlock.properties.isSolid) {
            return new YuushyaBlockFactory(kitType, yuushyaBlock).new BlockWithClassTypeNormal(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType);
        }
        return new YuushyaBlockFactory(kitType, yuushyaBlock).new BlockWithClassTypeWaterLogged(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType);
    }

    public static boolean isTheSameBlock(BlockState state1, BlockState state2) {
        return state2.m_60734_() == state1.m_60734_();
    }

    public static boolean isTheSameFacing(BlockState blockState1, BlockState blockState2) {
        return blockState1.m_61143_((Property)BlockStateProperties.f_61374_) == blockState2.m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public static boolean isTheSameLine(BlockState blockState1, BlockState blockState2) {
        return blockState1.m_61143_((Property)BlockStateProperties.f_61374_) == blockState2.m_61143_((Property)BlockStateProperties.f_61374_) || blockState1.m_61143_((Property)BlockStateProperties.f_61374_) == ((Direction)blockState2.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_();
    }

    public static boolean isPerpendicular(BlockState blockState1, BlockState blockState2) {
        Direction direction2;
        Direction direction1 = (Direction)blockState1.m_61143_((Property)BlockStateProperties.f_61374_);
        return direction1 == (direction2 = (Direction)blockState2.m_61143_((Property)BlockStateProperties.f_61374_)).m_122427_() || direction1 == direction2.m_122428_();
    }

    public class BlockWithClassTypeNormal
    extends BlockWithClassType {
        public BlockWithClassTypeNormal(BlockBehaviour.Properties properties, Integer tipLines, String classType) {
            super(properties, tipLines, classType);
            this.m_49959_(YuushyaBlockStates.getDefaultBlockState((BlockState)this.f_49792_.m_61090_()));
            if (YuushyaBlockFactory.this.finalKitType != null) {
                YuushyaBlockFactory.this.finalKitType.defaultBlockState = this.m_49966_();
            }
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
            int forms;
            List<Property<?>> blockStateProperties = YuushyaBlockFactory.getBlockStateProperties(YuushyaBlockFactory.this.yuushyaBlock.blockstate);
            if (YuushyaBlockFactory.this.finalKitType != null) {
                stateBuilder.m_61104_((Property[])YuushyaBlockFactory.this.finalKitType.getBlockStateProperty().toArray(Property[]::new));
            } else if (!blockStateProperties.isEmpty()) {
                stateBuilder.m_61104_((Property[])blockStateProperties.toArray(Property[]::new));
            }
            if (!YuushyaBlockFactory.this.yuushyaBlock.properties.isSolid) {
                stateBuilder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
            }
            if (YuushyaBlockFactory.this.yuushyaBlock.blockstate != null && YuushyaBlockFactory.this.yuushyaBlock.blockstate.forms != null && !blockStateProperties.contains(YuushyaBlockStates.FORM8) && (forms = YuushyaBlockFactory.this.yuushyaBlock.blockstate.forms.size()) > 1) {
                stateBuilder.m_61104_(new Property[]{YuushyaBlockStates.forms(forms)});
            }
        }

        public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
            if (YuushyaBlockFactory.this.finalKitType != null) {
                YuushyaBlockFactory.this.finalKitType.setPlacedBy(level, pos, state, placer, stack);
            } else {
                super.m_6402_(level, pos, state, placer, stack);
            }
        }

        public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
            if (YuushyaBlockFactory.this.finalKitType != null) {
                YuushyaBlockFactory.this.finalKitType.playerWillDestroy(level, pos, state, player);
            }
            super.m_5707_(level, pos, state, player);
        }

        @Nullable
        public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
            BlockState res = this.m_49966_();
            Level levelAccessor = blockPlaceContext.m_43725_();
            BlockPos blockPos = blockPlaceContext.m_8083_();
            if (YuushyaBlockFactory.this.finalKitType != null) {
                res = YuushyaBlockFactory.this.finalKitType.getStateForPlacement(blockPlaceContext);
            } else {
                if (res.m_61138_((Property)BlockStateProperties.f_61376_) && res.m_61138_((Property)BlockStateProperties.f_61374_)) {
                    Direction direction = blockPlaceContext.m_7820_();
                    res = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)res.m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)blockPlaceContext.m_8125_()) : (BlockState)((BlockState)res.m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)AttachFace.WALL)).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction.m_122424_());
                } else if (res.m_61138_((Property)BlockStateProperties.f_61374_)) {
                    BlockState blockState = res = blockPlaceContext.m_43719_().m_122434_() == Direction.Axis.Y ? (BlockState)res.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)blockPlaceContext.m_8125_()) : (BlockState)res.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)blockPlaceContext.m_43719_().m_122424_());
                }
                if (res.m_61138_(YuushyaBlockStates.XPOS)) {
                    res = (BlockState)res.m_61124_(YuushyaBlockStates.XPOS, (Comparable)((Object)FaceBlock.getPositionOfFaceX(this.m_49966_(), (LevelAccessor)levelAccessor, blockPos)));
                }
                if (res.m_61138_(YuushyaBlockStates.ZPOS)) {
                    res = (BlockState)res.m_61124_(YuushyaBlockStates.ZPOS, (Comparable)((Object)FaceBlock.getPositionOfFaceZ(this.m_49966_(), (LevelAccessor)levelAccessor, blockPos)));
                }
                if (res.m_61138_(YuushyaBlockStates.YPOS)) {
                    res = (BlockState)res.m_61124_(YuushyaBlockStates.YPOS, (Comparable)((Object)PoleBlock.getPositionOfPole(this.m_49966_(), (LevelAccessor)levelAccessor, blockPos)));
                }
            }
            if (res != null && res.m_61138_((Property)BlockStateProperties.f_61362_)) {
                res = (BlockState)res.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(levelAccessor.m_6425_(blockPos).m_192917_((Fluid)Fluids.f_76193_)));
            }
            return res;
        }

        public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
            if (YuushyaBlockFactory.this.finalKitType != null) {
                return YuushyaBlockFactory.this.finalKitType.canSurvive(blockState, levelReader, blockPos);
            }
            return super.m_7898_(blockState, levelReader, blockPos);
        }

        public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
            BlockState res = this.m_49966_();
            res = YuushyaBlockFactory.this.finalKitType != null ? YuushyaBlockFactory.this.finalKitType.updateShape(state, direction, neighborState, level, currentPos, neighborPos) : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
            if (res != null && res.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)res.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
            }
            return res;
        }

        public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
            YuushyaRegistryData.Block.Usage usage = YuushyaBlockFactory.this.yuushyaBlock.usage;
            if (YuushyaBlockFactory.this.yuushyaBlock.properties != null && YuushyaBlockFactory.this.yuushyaBlock.properties.food != null) {
                YuushyaRegistryData.Item.Properties.Food food = YuushyaBlockFactory.this.yuushyaBlock.properties.food;
                ResourceLocation finishedItem = null;
                if (YuushyaBlockFactory.this.yuushyaBlock.properties.food.finishedItem != null) {
                    finishedItem = new ResourceLocation(YuushyaBlockFactory.this.yuushyaBlock.properties.food.finishedItem);
                }
                return FoodBlock.use(finishedItem, food.nutrition, food.saturation, state, level, pos, player, hand, hit);
            }
            if (usage != null) {
                IntegerProperty property;
                if (!level.f_46443_ && usage.sound != null && !usage.sound.isBlank() && player.m_21120_(hand).m_41619_()) {
                    SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation(usage.sound));
                    level.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 0.2f);
                }
                if (usage.sitPos != null && usage.sitPos.size() == 3 && player.m_21120_(hand).m_41619_()) {
                    return ChairEntityUtils.use(new Vec3((double)usage.sitPos.get(0).floatValue(), (double)usage.sitPos.get(1).floatValue(), (double)usage.sitPos.get(2).floatValue()), state, level, pos, player, hand, hit);
                }
                if (usage.cycleForms != null && !usage.cycleForms.isEmpty() && player.m_21120_(hand).m_41619_() && (property = YuushyaUtils.getFormFromState(state)) != null) {
                    while (!usage.cycleForms.contains((state = (BlockState)state.m_61122_((Property)property)).m_61143_((Property)property))) {
                    }
                    level.m_7731_(pos, state, 2);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
    }

    public class BlockWithClassTypeWaterLogged
    extends BlockWithClassTypeNormal
    implements SimpleWaterloggedBlock {
        public BlockWithClassTypeWaterLogged(BlockBehaviour.Properties properties, Integer tipLines, String classType) {
            super(properties, tipLines, classType);
        }
    }

    public static class BlockWithClassType
    extends AbstractYuushyaBlock {
        public String classType;
        private final Map<String, VoxelShape> voxelShapeCache = new HashMap<String, VoxelShape>();
        private final Map<String, VoxelShape> collisionShapeCache = new HashMap<String, VoxelShape>();

        public BlockWithClassType(BlockBehaviour.Properties properties, Integer tipLines, String classType) {
            super(properties, tipLines);
            this.classType = classType;
        }

        public boolean isTheSameType(BlockWithClassType block) {
            return this.classType.equals(block.classType);
        }

        public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
            String id = blockState.toString();
            if (!this.voxelShapeCache.containsKey(id)) {
                if (!YuushyaBlockFactory.getYuushyaVoxelShapes().containsKey(id)) {
                    CollisionFileReader.readCollisionToVoxelShape(blockState, BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_()).toString());
                }
                VoxelShape shape = YuushyaBlockFactory.getYuushyaVoxelShapes().getOrDefault(id, Shapes.m_83144_());
                this.voxelShapeCache.put(id, shape);
                return shape;
            }
            return this.voxelShapeCache.get(id);
        }

        public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
            if (!this.f_60443_) {
                return Shapes.m_83040_();
            }
            String id = blockState.toString();
            if (!this.collisionShapeCache.containsKey(id)) {
                if (!YuushyaBlockFactory.getYuushyaCollisionShapes().containsKey(id)) {
                    VoxelShape collisionShape = this.m_5940_(blockState, blockGetter, blockPos, collisionContext);
                    if (!YuushyaBlockFactory.getYuushyaCollisionShapes().containsKey(id)) {
                        YuushyaBlockFactory.getYuushyaCollisionShapes().put(id, CollisionFileReader.restrictShape(collisionShape));
                    }
                }
                VoxelShape shape = YuushyaBlockFactory.getYuushyaCollisionShapes().getOrDefault(id, Shapes.m_83040_());
                this.collisionShapeCache.put(id, shape);
            }
            return this.collisionShapeCache.get(id);
        }

        public BlockState m_6843_(BlockState state, Rotation rotation) {
            if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
            } else if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
            }
            if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
                state = switch (rotation) {
                    case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                        switch ((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)) {
                            case X: {
                                yield (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Z);
                            }
                            case Z: {
                                yield (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.X);
                            }
                        }
                        yield state;
                    }
                    default -> state;
                };
            }
            return state;
        }

        public BlockState m_6943_(BlockState state, Mirror mirror) {
            if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
                return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
            }
            if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
            }
            return super.m_6943_(state, mirror);
        }

        public FluidState m_5888_(BlockState state) {
            if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
                return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
            }
            return super.m_5888_(state);
        }
    }
}

