/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.taczaddon.common;

import com.mafuyu404.taczaddon.init.Config;
import com.mafuyu404.taczaddon.init.DataStorage;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.util.AllowAttachmentTagMatcher;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;

public class BetterGunSmithTable {
    private static ResourceLocation recipeId;

    public static ResourceLocation storeRecipeId(ResourceLocation id) {
        recipeId = id;
        return id;
    }

    public static String controlRecipes(String groupName, String selectedAttachmentProp) {
        if (!Config.enableBetterGunSmithTable()) {
            return groupName;
        }
        if (ModList.get().isLoaded("tacztweaks")) {
            return groupName;
        }
        Object data = DataStorage.get("BetterGunSmithTable.storedAttachmentData");
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack gunItem = player.m_21206_();
        if (IGun.getIGunOrNull((ItemStack)player.m_21205_()) != null) {
            gunItem = player.m_21205_();
        }
        IGun iGun = IGun.getIGunOrNull((ItemStack)gunItem);
        if (!recipeId.toString().contains("/") && (iGun == null || Objects.equals(selectedAttachmentProp, "\u9009\u62e9\u5c5e\u6027"))) {
            return groupName;
        }
        ResourceLocation itemId = ResourceLocation.m_135820_((String)(recipeId.toString().split(":")[0] + ":" + recipeId.toString().split("/")[1]));
        if (iGun != null) {
            ResourceLocation gunId = iGun.getGunId(gunItem);
            boolean isAmmo = TimelessAPI.getCommonGunIndex((ResourceLocation)gunId).map(gunIndex -> gunIndex.getGunData().getAmmoId().equals((Object)itemId)).orElse(false);
            boolean isAttachment = AllowAttachmentTagMatcher.match((ResourceLocation)gunId, (ResourceLocation)itemId);
            if (!isAmmo && !isAttachment) {
                return "hidden";
            }
        }
        return groupName;
    }

    public static boolean allowAttachment(ItemStack gunItem, ResourceLocation attachmentId) {
        IGun iGun = IGun.getIGunOrNull((ItemStack)gunItem);
        ResourceLocation gunId = null;
        if (iGun != null) {
            gunId = iGun.getGunId(gunItem);
        }
        return AllowAttachmentTagMatcher.match(gunId, (ResourceLocation)attachmentId);
    }

    public static boolean allowAmmo(ItemStack gunItem, ResourceLocation ammoId) {
        IGun iGun = IGun.getIGunOrNull((ItemStack)gunItem);
        ResourceLocation gunId = null;
        if (iGun != null) {
            gunId = iGun.getGunId(gunItem);
        }
        return TimelessAPI.getCommonGunIndex(gunId).map(gunIndex -> gunIndex.getGunData().getAmmoId().equals((Object)ammoId)).orElse(false);
    }

    public static boolean isHoldingGun(Player player) {
        if (IGun.getIGunOrNull((ItemStack)player.m_21205_()) != null) {
            return true;
        }
        return IGun.getIGunOrNull((ItemStack)player.m_21206_()) != null;
    }

    public static ItemStack getHoldingGun(Player player) {
        IGun main = IGun.getIGunOrNull((ItemStack)player.m_21205_());
        IGun off = IGun.getIGunOrNull((ItemStack)player.m_21206_());
        if (main != null) {
            return player.m_21205_();
        }
        if (off != null) {
            return player.m_21206_();
        }
        return null;
    }

    public static String getTranslationKey(Component component) {
        ComponentContents contents = component.m_214077_();
        if (contents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)contents;
            return translatable.m_237508_();
        }
        return null;
    }
}

