/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.components.refit;

import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.util.LaserColorUtil;
import java.awt.Color;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ForgeSlider;
import org.jetbrains.annotations.NotNull;

public class HSVSliderGroup {
    private final Inventory inventory;
    private final int gunItemIndex;
    private final AttachmentType type;
    private final LaserColorSlider hueSlider;
    private final LaserColorSlider saturationSlider;

    public HSVSliderGroup(int x, int y, int width, int height, Inventory inventory, int gunItemIndex, @NotNull AttachmentType type) {
        this.inventory = inventory;
        this.gunItemIndex = gunItemIndex;
        this.type = type;
        int color = this.getColor(type);
        float[] hsb = Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, null);
        this.hueSlider = new LaserColorSlider(x, y, width, height, this, hsb[0]);
        this.saturationSlider = new LaserColorSlider(x, y + 2 + height, width, height, this, hsb[1]);
    }

    public LaserColorSlider getHueSlider() {
        return this.hueSlider;
    }

    public LaserColorSlider getSaturationSlider() {
        return this.saturationSlider;
    }

    public void apply() {
        ItemStack gun = this.inventory.m_8020_(this.gunItemIndex);
        Item item = gun.m_41720_();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            int rgb_new = Color.HSBtoRGB((float)this.hueSlider.getValue(), (float)this.saturationSlider.getValue(), 1.0f);
            if (this.type == AttachmentType.NONE) {
                iGun.setLaserColor(gun, rgb_new);
                return;
            }
            ItemStack laser = iGun.getAttachment(gun, this.type);
            Item item2 = laser.m_41720_();
            if (item2 instanceof IAttachment) {
                IAttachment iAttachment = (IAttachment)item2;
                iAttachment.setLaserColor(laser, rgb_new);
            }
        }
    }

    private int getColor(AttachmentType type) {
        if (this.inventory == null) {
            return 0xFF0000;
        }
        ItemStack gun = this.inventory.m_8020_(this.gunItemIndex);
        Item item = gun.m_41720_();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            if (type == AttachmentType.NONE) {
                return LaserColorUtil.getLaserColor(gun);
            }
            ItemStack attachment = iGun.getAttachment(gun, type);
            return LaserColorUtil.getLaserColor(attachment);
        }
        return 0xFF0000;
    }

    public static class LaserColorSlider
    extends ForgeSlider {
        private final HSVSliderGroup parent;

        public LaserColorSlider(int x, int y, int width, int height, HSVSliderGroup parent, double current) {
            super(x, y, width, height, (Component)Component.m_237119_(), (Component)Component.m_237119_(), 0.0, 1.0, current, 0.01, 0, true);
            this.parent = parent;
        }

        protected void m_5697_() {
            this.parent.apply();
        }
    }
}

