/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.event;

import com.github.exopandora.shouldersurfing.api.client.IShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.api.client.ShoulderSurfing;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.event.BeforeRenderHandEvent;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.api.item.nbt.AttachmentItemDataAccessor;
import com.tacz.guns.api.modifier.ParameterizedCache;
import com.tacz.guns.api.modifier.ParameterizedCachePair;
import com.tacz.guns.client.renderer.item.AnimateGeoItemRenderer;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.compat.shouldersurfing.ShoulderSurfingCompat;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.custom.RecoilModifier;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.math.MathUtil;
import com.tacz.guns.util.math.SecondOrderDynamics;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tacz")
public class CameraSetupEvent {
    public static final SecondOrderDynamics WORLD_FOV_DYNAMICS = new SecondOrderDynamics(0.5f, 1.2f, 0.5f, 0.0f);
    public static final SecondOrderDynamics ITEM_MODEL_FOV_DYNAMICS = new SecondOrderDynamics(0.5f, 1.2f, 0.5f, 0.0f);
    private static PolynomialSplineFunction pitchSplineFunction;
    private static PolynomialSplineFunction yawSplineFunction;
    private static long shootTimeStamp;
    private static double xRotO;
    private static double yRotO;

    @SubscribeEvent
    public static void applyLevelCameraAnimation(ViewportEvent.ComputeCameraAngles event) {
        if (!((Boolean)Minecraft.m_91087_().f_91066_.m_231830_().m_231551_()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = KeepingItemRenderer.getRenderer().getCurrentItem();
        BlockEntityWithoutLevelRenderer blockEntityWithoutLevelRenderer = IClientItemExtensions.of((Item)stack.m_41720_()).getCustomRenderer();
        if (blockEntityWithoutLevelRenderer instanceof AnimateGeoItemRenderer) {
            AnimateGeoItemRenderer renderer = (AnimateGeoItemRenderer)blockEntityWithoutLevelRenderer;
            renderer.applyLevelCameraAnimation(event, stack, player);
        }
    }

    @SubscribeEvent
    public static void applyItemInHandCameraAnimation(BeforeRenderHandEvent event) {
        if (!((Boolean)Minecraft.m_91087_().f_91066_.m_231830_().m_231551_()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = KeepingItemRenderer.getRenderer().getCurrentItem();
        BlockEntityWithoutLevelRenderer blockEntityWithoutLevelRenderer = IClientItemExtensions.of((Item)stack.m_41720_()).getCustomRenderer();
        if (blockEntityWithoutLevelRenderer instanceof AnimateGeoItemRenderer) {
            AnimateGeoItemRenderer renderer = (AnimateGeoItemRenderer)blockEntityWithoutLevelRenderer;
            renderer.applyItemInHandCameraAnimation(event, stack, player);
        }
    }

    @SubscribeEvent
    public static void applyScopeMagnification(ViewportEvent.ComputeFov event) {
        if (!event.usedConfiguredFov()) {
            return;
        }
        Entity entity = event.getCamera().m_90592_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack stack = KeepingItemRenderer.getRenderer().getCurrentItem();
            Item item = stack.m_41720_();
            if (!(item instanceof IGun)) {
                float fov = WORLD_FOV_DYNAMICS.update((float)event.getFOV());
                event.setFOV((double)fov);
                return;
            }
            IGun iGun = (IGun)item;
            float zoom = iGun.getAimingZoom(stack);
            if (livingEntity instanceof LocalPlayer) {
                LocalPlayer localPlayer = (LocalPlayer)livingEntity;
                IClientPlayerGunOperator gunOperator = IClientPlayerGunOperator.fromLocalPlayer(localPlayer);
                float aimingProgress = gunOperator.getClientAimingProgress((float)event.getPartialTick());
                float fov = WORLD_FOV_DYNAMICS.update((float)MathUtil.magnificationToFov(1.0f + (zoom - 1.0f) * aimingProgress, event.getFOV()));
                event.setFOV((double)fov);
            } else {
                IGunOperator gunOperator = IGunOperator.fromLivingEntity(livingEntity);
                float aimingProgress = gunOperator.getSynAimingProgress();
                float fov = WORLD_FOV_DYNAMICS.update((float)MathUtil.magnificationToFov(1.0f + (zoom - 1.0f) * aimingProgress, event.getFOV()));
                event.setFOV((double)fov);
            }
        }
    }

    @SubscribeEvent
    public static void applyGunModelFovModifying(ViewportEvent.ComputeFov event) {
        if (event.usedConfiguredFov()) {
            return;
        }
        Entity entity = event.getCamera().m_90592_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack stack = KeepingItemRenderer.getRenderer().getCurrentItem();
            Item item = stack.m_41720_();
            if (!(item instanceof IGun)) {
                float fov = ITEM_MODEL_FOV_DYNAMICS.update((float)event.getFOV());
                event.setFOV((double)fov);
                return;
            }
            IGun iGun = (IGun)item;
            ResourceLocation scopeItemId = iGun.getAttachmentId(stack, AttachmentType.SCOPE);
            if (scopeItemId.equals((Object)DefaultAssets.EMPTY_ATTACHMENT_ID)) {
                scopeItemId = iGun.getBuiltInAttachmentId(stack, AttachmentType.SCOPE);
            }
            CompoundTag scopeTag = iGun.getAttachmentTag(stack, AttachmentType.SCOPE);
            int zoomNumber = AttachmentItemDataAccessor.getZoomNumberFromTag(scopeTag);
            float modifiedFov = TimelessAPI.getClientAttachmentIndex(scopeItemId).map(index -> {
                float[] viewsFov = index.getViewsFov();
                return Float.valueOf(viewsFov[zoomNumber % viewsFov.length]);
            }).orElse(TimelessAPI.getGunDisplay(stack).map(GunDisplayInstance::getZoomModelFov).orElse(Float.valueOf((float)event.getFOV()))).floatValue();
            if (livingEntity instanceof LocalPlayer) {
                LocalPlayer localPlayer = (LocalPlayer)livingEntity;
                IClientPlayerGunOperator gunOperator = IClientPlayerGunOperator.fromLocalPlayer(localPlayer);
                float aimingProgress = gunOperator.getClientAimingProgress((float)event.getPartialTick());
                float fov = ITEM_MODEL_FOV_DYNAMICS.update(Mth.m_14179_((float)aimingProgress, (float)((float)event.getFOV()), (float)modifiedFov));
                event.setFOV((double)fov);
            } else {
                IGunOperator gunOperator = IGunOperator.fromLivingEntity(livingEntity);
                float aimingProgress = gunOperator.getSynAimingProgress();
                float fov = ITEM_MODEL_FOV_DYNAMICS.update(Mth.m_14179_((float)aimingProgress, (float)((float)event.getFOV()), (float)modifiedFov));
                event.setFOV((double)fov);
            }
        }
    }

    @SubscribeEvent
    public static void initialCameraRecoil(GunFireEvent event) {
        if (event.getLogicalSide().isClient()) {
            LocalPlayer player;
            LivingEntity shooter = event.getShooter();
            if (!shooter.equals((Object)(player = Minecraft.m_91087_().f_91074_))) {
                return;
            }
            ItemStack mainHandItem = player.m_21205_();
            Item item = mainHandItem.m_41720_();
            if (!(item instanceof IGun)) {
                return;
            }
            IGun iGun = (IGun)item;
            AttachmentCacheProperty cacheProperty = IGunOperator.fromLivingEntity((LivingEntity)player).getCacheProperty();
            if (cacheProperty == null) {
                return;
            }
            ResourceLocation gunId = iGun.getGunId(mainHandItem);
            Optional<ClientGunIndex> gunIndexOptional = TimelessAPI.getClientGunIndex(gunId);
            if (gunIndexOptional.isEmpty()) {
                return;
            }
            ClientGunIndex gunIndex = gunIndexOptional.get();
            GunData gunData = gunIndex.getGunData();
            ParameterizedCachePair attachmentRecoilModifier = (ParameterizedCachePair)cacheProperty.getCache(RecoilModifier.ID);
            IClientPlayerGunOperator clientPlayerGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
            float partialTicks = Minecraft.m_91087_().m_91296_();
            float aimingProgress = clientPlayerGunOperator.getClientAimingProgress(partialTicks);
            float zoom = iGun.getAimingZoom(mainHandItem);
            float aimingRecoilModifier = 1.0f - aimingProgress + aimingProgress / (float)Math.min(Math.sqrt(zoom), 1.5);
            if (!player.m_6069_() && player.m_20089_() == Pose.SWIMMING) {
                aimingRecoilModifier *= gunData.getCrawlRecoilMultiplier();
            }
            pitchSplineFunction = gunData.getRecoil().genPitchSplineFunction((float)((ParameterizedCache)attachmentRecoilModifier.left()).eval(aimingRecoilModifier));
            yawSplineFunction = gunData.getRecoil().genYawSplineFunction((float)((ParameterizedCache)attachmentRecoilModifier.right()).eval(aimingRecoilModifier));
            shootTimeStamp = System.currentTimeMillis();
            xRotO = 0.0;
            yRotO = 0.0;
        }
    }

    @SubscribeEvent
    public static void applyCameraRecoil(ViewportEvent.ComputeCameraAngles event) {
        IShoulderSurfingCamera camera;
        double value;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        long timeTotal = System.currentTimeMillis() - shootTimeStamp;
        if (pitchSplineFunction != null && pitchSplineFunction.isValidPoint((double)timeTotal)) {
            value = pitchSplineFunction.value((double)timeTotal);
            if (ShoulderSurfingCompat.isInstalled() && ShoulderSurfing.getInstance().isShoulderSurfing()) {
                camera = ShoulderSurfing.getInstance().getCamera();
                camera.setXRot(camera.getXRot() - (float)(value - xRotO));
            } else {
                player.m_146926_(player.m_146909_() - (float)(value - xRotO));
            }
            xRotO = value;
        }
        if (yawSplineFunction != null && yawSplineFunction.isValidPoint((double)timeTotal)) {
            value = yawSplineFunction.value((double)timeTotal);
            if (ShoulderSurfingCompat.isInstalled() && ShoulderSurfing.getInstance().isShoulderSurfing()) {
                camera = ShoulderSurfing.getInstance().getCamera();
                camera.setYRot(camera.getYRot() - (float)(value - yRotO));
            } else {
                player.m_146922_(player.m_146908_() - (float)(value - yRotO));
            }
            yRotO = value;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onComputeMovementFov(ComputeFovModifierEvent event) {
        if (!((Boolean)RenderConfig.DISABLE_MOVEMENT_ATTRIBUTE_FOV.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        float f = 1.0f;
        if (player.m_21205_().m_41720_() instanceof AbstractGunItem) {
            if (player.m_150110_().f_35935_) {
                f *= 1.1f;
            }
            event.setNewFovModifier(player.m_20142_() ? 1.15f * f : f);
        }
    }

    static {
        shootTimeStamp = -1L;
        xRotO = 0.0;
        yRotO = 0.0;
    }
}

