/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.nbt;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.IGun;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface AmmoBoxItemDataAccessor
extends IAmmoBox {
    public static final String AMMO_ID_TAG = "AmmoId";
    public static final String AMMO_COUNT_TAG = "AmmoCount";
    public static final String CREATIVE_TAG = "Creative";
    public static final String ALL_TYPE_CREATIVE_TAG = "AllTypeCreative";
    public static final String LEVEL_TAG = "Level";

    @Override
    default public ResourceLocation getAmmoId(ItemStack ammoBox) {
        CompoundTag tag = ammoBox.m_41784_();
        if (tag.m_128425_(AMMO_ID_TAG, 8)) {
            return new ResourceLocation(tag.m_128461_(AMMO_ID_TAG));
        }
        return DefaultAssets.EMPTY_AMMO_ID;
    }

    @Override
    default public void setAmmoId(ItemStack ammoBox, ResourceLocation ammoId) {
        CompoundTag tag = ammoBox.m_41784_();
        tag.m_128359_(AMMO_ID_TAG, ammoId.toString());
    }

    @Override
    default public int getAmmoCount(ItemStack ammoBox) {
        CompoundTag tag = ammoBox.m_41784_();
        if (this.isAllTypeCreative(ammoBox) || this.isCreative(ammoBox)) {
            return Integer.MAX_VALUE;
        }
        if (tag.m_128425_(AMMO_COUNT_TAG, 3)) {
            return tag.m_128451_(AMMO_COUNT_TAG);
        }
        return 0;
    }

    @Override
    default public void setAmmoCount(ItemStack ammoBox, int count) {
        CompoundTag tag = ammoBox.m_41784_();
        if (this.isCreative(ammoBox)) {
            tag.m_128405_(AMMO_COUNT_TAG, Integer.MAX_VALUE);
            return;
        }
        tag.m_128405_(AMMO_COUNT_TAG, count);
    }

    @Override
    default public boolean isAmmoBoxOfGun(ItemStack gun, ItemStack ammoBox) {
        Item item = gun.m_41720_();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            item = ammoBox.m_41720_();
            if (item instanceof IAmmoBox) {
                IAmmoBox iAmmoBox = (IAmmoBox)item;
                if (this.isAllTypeCreative(ammoBox)) {
                    return true;
                }
                ResourceLocation ammoId = iAmmoBox.getAmmoId(ammoBox);
                if (ammoId.equals((Object)DefaultAssets.EMPTY_AMMO_ID)) {
                    return false;
                }
                ResourceLocation gunId = iGun.getGunId(gun);
                return TimelessAPI.getCommonGunIndex(gunId).map(gunIndex -> gunIndex.getGunData().getAmmoId().equals((Object)ammoId)).orElse(false);
            }
        }
        return false;
    }

    @Override
    default public ItemStack setAmmoLevel(ItemStack ammoBox, int level) {
        CompoundTag tag = ammoBox.m_41784_();
        tag.m_128405_(LEVEL_TAG, Math.max(level, 0));
        return ammoBox;
    }

    @Override
    default public int getAmmoLevel(ItemStack ammoBox) {
        CompoundTag tag = ammoBox.m_41784_();
        if (tag.m_128425_(LEVEL_TAG, 3)) {
            return tag.m_128451_(LEVEL_TAG);
        }
        return 0;
    }

    @Override
    default public boolean isCreative(ItemStack ammoBox) {
        CompoundTag tag = ammoBox.m_41783_();
        if (tag != null && tag.m_128425_(CREATIVE_TAG, 1)) {
            return tag.m_128471_(CREATIVE_TAG);
        }
        return false;
    }

    @Override
    default public boolean isAllTypeCreative(ItemStack ammoBox) {
        CompoundTag tag = ammoBox.m_41783_();
        if (tag != null && tag.m_128425_(ALL_TYPE_CREATIVE_TAG, 1)) {
            return tag.m_128471_(ALL_TYPE_CREATIVE_TAG);
        }
        return false;
    }

    @Override
    default public ItemStack setCreative(ItemStack ammoBox, boolean isAllType) {
        CompoundTag tag = ammoBox.m_41784_();
        if (isAllType) {
            if (tag.m_128425_(CREATIVE_TAG, 1)) {
                tag.m_128473_(CREATIVE_TAG);
            }
            tag.m_128379_(ALL_TYPE_CREATIVE_TAG, true);
            return ammoBox;
        }
        if (tag.m_128425_(ALL_TYPE_CREATIVE_TAG, 1)) {
            tag.m_128473_(ALL_TYPE_CREATIVE_TAG);
        }
        tag.m_128379_(CREATIVE_TAG, true);
        return ammoBox;
    }
}

